/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import ij.ImagePlus;
import ij.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.ServiceMediator;
import org.imagearchive.lsm.toolbox.info.CZLSMInfoExtended;
import org.imagearchive.lsm.toolbox.info.scaninfo.Recording;

public class NotesDialog
extends JDialog {
    private JTextArea tsnotes;
    private JTextArea tdnotes;
    private JPanel panel;
    private final MasterModel masterModel = MasterModel.getMasterModel();

    public NotesDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initializeGUI();
    }

    private void initializeGUI() {
        this.setTitle("LSM Notes");
        this.getContentPane().setLayout(new BorderLayout());
        JLabel snotes = new JLabel("Short Notes :");
        JLabel dnotes = new JLabel("Detailed Notes :");
        this.tsnotes = new JTextArea("");
        this.tdnotes = new JTextArea("");
        this.tsnotes.setEditable(false);
        this.tsnotes.setEditable(false);
        this.tdnotes.setRows(4);
        this.tdnotes.setRows(4);
        this.tsnotes.setColumns(20);
        this.tdnotes.setColumns(20);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)snotes, gbc);
        gbc.gridy = 1;
        this.panel.add((Component)dnotes, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        this.panel.add((Component)this.tsnotes, gbc);
        gbc.gridy = 1;
        this.panel.add((Component)this.tdnotes, gbc);
        this.getContentPane().add((Component)this.panel, "North");
        JButton okb = new JButton("Ok");
        this.addokbListener(okb, this);
        this.getContentPane().add((Component)okb, "South");
        this.pack();
        this.centerWindow();
    }

    public void setNotes() {
        ImagePlus imp = WindowManager.getCurrentImage();
        Reader reader = ServiceMediator.getReader();
        reader.updateMetadata(imp);
        if (imp == null) {
            return;
        }
        if (imp.getOriginalFileInfo() instanceof LSMFileInfo) {
            LSMFileInfo lsm = (LSMFileInfo)imp.getOriginalFileInfo();
            ArrayList imageDirectories = lsm.imageDirectories;
            ImageDirectory imDir = (ImageDirectory)imageDirectories.get(0);
            if (imDir == null) {
                return;
            }
            CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)imDir.TIF_CZ_LSMINFO);
            Recording r = cz.scanInfo.recordings.get(0);
            if (r == null) {
                return;
            }
            String shortNotes = (String)r.records.get("ENTRY_DESCRIPTION");
            String detailedNotes = (String)r.records.get("ENTRY_NOTES");
            this.tsnotes.setText(shortNotes);
            this.tdnotes.setText(detailedNotes);
        }
    }

    private void addokbListener(JButton button, JDialog parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesDialog.this.setVisible(false);
            }
        });
    }

    public void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }
}

