/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.awt;

import edu.mines.jtk.awt.ModeManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class Mode
extends AbstractAction {
    private ModeManager _manager;
    private boolean _active = false;
    private Cursor _cursor = null;

    public void setActive(boolean active) {
        if (this.isEnabled() && this._active != active) {
            this._manager.setActive(this, active);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isExclusive() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setActive(!this._active);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled && this.isActive()) {
            this.setActive(false);
        }
        super.setEnabled(enabled);
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setMnemonicKey(int mk) {
        this.putValue("MnemonicKey", new Integer(mk));
    }

    public void setAcceleratorKey(KeyStroke ak) {
        this.putValue("AcceleratorKey", ak);
    }

    public void setShortDescription(String sd) {
        this.putValue("ShortDescription", sd);
    }

    public void setLongDescription(String ld) {
        this.putValue("LongDescription", ld);
    }

    public void setCursor(Cursor cursor) {
        this._cursor = cursor;
    }

    public Cursor getCursor() {
        return this._cursor;
    }

    protected Mode(ModeManager manager) {
        manager.add(this);
        this._manager = manager;
    }

    protected static Icon loadIcon(Class<?> cls, String res) {
        URL url = cls.getResource(res);
        return url != null ? new ImageIcon(url) : null;
    }

    protected static Cursor loadCursor(Class<?> cls, String res, int x, int y) {
        URL url = cls.getResource(res);
        if (url == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(url);
        if (image == null) {
            return null;
        }
        image = Mode.resizeCursorImage(image);
        Point point = new Point(x, y);
        return toolkit.createCustomCursor(image, point, res);
    }

    protected abstract void setActive(Component var1, boolean var2);

    void setActiveInternal(boolean active) {
        this.firePropertyChange("active", this._active, active);
        this._active = active;
    }

    private static Image resizeCursorImage(Image image) {
        BufferedImage bimage;
        Dimension size;
        image = new ImageIcon(image).getImage();
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        try {
            size = Toolkit.getDefaultToolkit().getBestCursorSize(w, h);
        }
        catch (HeadlessException e) {
            return image;
        }
        if (w == size.width && h == size.height) {
            return image;
        }
        w = size.width;
        h = size.height;
        boolean hasAlpha = Mode.hasAlpha(image);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = hasAlpha ? 2 : 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(w, h, transparency);
        }
        catch (HeadlessException e) {
            int type = hasAlpha ? 2 : 1;
            bimage = new BufferedImage(w, h, type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return true;
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }
}

