/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import ij.ImagePlus;
import mpicbg.models.Model;
import mpicbg.models.Tile;
import mpicbg.models.TranslationModel2D;
import mpicbg.stitching.ImageCollectionElement;

public class ImagePlusTimePoint
extends Tile
implements Comparable<ImagePlusTimePoint> {
    final ImagePlus imp;
    final int impId;
    final int timePoint;
    final int dimensionality;
    final ImageCollectionElement element;

    public ImagePlusTimePoint(ImagePlus imp, int impId, int timepoint, Model model, ImageCollectionElement element) {
        super(model);
        this.imp = imp;
        this.impId = impId;
        this.timePoint = timepoint;
        this.element = element;
        this.dimensionality = TranslationModel2D.class.isInstance(model) ? 2 : 3;
    }

    public int getImpId() {
        return this.impId;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public int getTimePoint() {
        return this.timePoint;
    }

    public ImageCollectionElement getElement() {
        return this.element;
    }

    @Override
    public int compareTo(ImagePlusTimePoint o) {
        if (this.timePoint < o.timePoint) {
            return -1;
        }
        if (this.timePoint > o.timePoint) {
            return 1;
        }
        if (this.impId < o.impId) {
            return -1;
        }
        if (this.impId > o.impId) {
            return 1;
        }
        return 0;
    }
}

