/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RealInterval;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Meshes;
import net.imglib2.mesh.alg.MeshCursor;

public class MeshIterable<T>
implements IterableInterval<T> {
    private final double[] calibration;
    private final RandomAccessible<T> ra;
    private final Mesh mesh;
    private final RealInterval boundingBox;

    public MeshIterable(RandomAccessible<T> ra, Mesh mesh, double[] calibration) {
        this(ra, mesh, calibration, Meshes.boundingBox(mesh));
    }

    public MeshIterable(RandomAccessible<T> ra, Mesh mesh, double[] calibration, RealInterval boundingBox) {
        this.ra = ra;
        this.mesh = mesh;
        this.calibration = calibration;
        this.boundingBox = boundingBox;
    }

    public int numDimensions() {
        return 3;
    }

    public long size() {
        long size = 0L;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            ++size;
        }
        return size;
    }

    public T firstElement() {
        return (T)this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return Math.round(this.boundingBox.realMin(d) / this.calibration[d]);
    }

    public long max(int d) {
        return Math.round(this.boundingBox.realMax(d) / this.calibration[d]);
    }

    public Cursor<T> cursor() {
        return new MeshCursor(this.ra.randomAccess(), this.mesh, this.calibration, this.boundingBox);
    }

    public Cursor<T> localizingCursor() {
        return this.cursor();
    }
}

