/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.impl.naive;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import net.imglib2.mesh.Mesh;

public class NaiveFloatMesh
implements Mesh {
    private final Vertices vertices = new Vertices();
    private final Triangles triangles = new Triangles();

    @Override
    public Vertices vertices() {
        return this.vertices;
    }

    @Override
    public Triangles triangles() {
        return this.triangles;
    }

    public class Triangles
    implements net.imglib2.mesh.Triangles {
        private final TIntArrayList v0s = new TIntArrayList();
        private final TIntArrayList v1s = new TIntArrayList();
        private final TIntArrayList v2s = new TIntArrayList();
        private final TFloatArrayList nxs = new TFloatArrayList();
        private final TFloatArrayList nys = new TFloatArrayList();
        private final TFloatArrayList nzs = new TFloatArrayList();

        @Override
        public Mesh mesh() {
            return NaiveFloatMesh.this;
        }

        @Override
        public long sizel() {
            return this.v1s.size();
        }

        @Override
        public long vertex0(long tIndex) {
            return this.v0s.get(this.safeIndex(tIndex));
        }

        @Override
        public long vertex1(long tIndex) {
            return this.v1s.get(this.safeIndex(tIndex));
        }

        @Override
        public long vertex2(long tIndex) {
            return this.v2s.get(this.safeIndex(tIndex));
        }

        @Override
        public float nxf(long tIndex) {
            return this.nxs.get(this.safeIndex(tIndex));
        }

        @Override
        public float nyf(long tIndex) {
            return this.nys.get(this.safeIndex(tIndex));
        }

        @Override
        public float nzf(long tIndex) {
            return this.nzs.get(this.safeIndex(tIndex));
        }

        @Override
        public long addf(long v0, long v1, long v2, float nx, float ny, float nz) {
            int index = this.v0s.size();
            this.v0s.add(this.safeIndex(v0));
            this.v1s.add(this.safeIndex(v1));
            this.v2s.add(this.safeIndex(v2));
            this.nxs.add(nx);
            this.nys.add(ny);
            this.nzs.add(nz);
            return index;
        }

        private int safeIndex(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Index too large: " + index);
            }
            return (int)index;
        }
    }

    public class Vertices
    implements net.imglib2.mesh.Vertices {
        private final TFloatArrayList xs = new TFloatArrayList();
        private final TFloatArrayList ys = new TFloatArrayList();
        private final TFloatArrayList zs = new TFloatArrayList();
        private final TFloatArrayList nxs = new TFloatArrayList();
        private final TFloatArrayList nys = new TFloatArrayList();
        private final TFloatArrayList nzs = new TFloatArrayList();
        private final TFloatArrayList us = new TFloatArrayList();
        private final TFloatArrayList vs = new TFloatArrayList();

        @Override
        public Mesh mesh() {
            return NaiveFloatMesh.this;
        }

        @Override
        public long sizel() {
            return this.xs.size();
        }

        @Override
        public float xf(long vIndex) {
            return this.xs.get(this.safeIndex(vIndex));
        }

        @Override
        public float yf(long vIndex) {
            return this.ys.get(this.safeIndex(vIndex));
        }

        @Override
        public float zf(long vIndex) {
            return this.zs.get(this.safeIndex(vIndex));
        }

        @Override
        public float nxf(long vIndex) {
            return this.nxs.get(this.safeIndex(vIndex));
        }

        @Override
        public float nyf(long vIndex) {
            return this.nys.get(this.safeIndex(vIndex));
        }

        @Override
        public float nzf(long vIndex) {
            return this.nzs.get(this.safeIndex(vIndex));
        }

        @Override
        public float uf(long vIndex) {
            return this.us.get(this.safeIndex(vIndex));
        }

        @Override
        public float vf(long vIndex) {
            return this.vs.get(this.safeIndex(vIndex));
        }

        @Override
        public long addf(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            int index = this.xs.size();
            this.xs.add(x);
            this.ys.add(y);
            this.zs.add(z);
            this.nxs.add(nx);
            this.nys.add(ny);
            this.nzs.add(nz);
            this.us.add(u);
            this.vs.add(v);
            return index;
        }

        @Override
        public void setf(long vIndex, float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            int index = this.safeIndex(vIndex);
            this.xs.set(index, x);
            this.ys.set(index, y);
            this.zs.set(index, z);
            this.nxs.set(index, nx);
            this.nys.set(index, ny);
            this.nzs.set(index, nz);
            this.us.set(index, u);
            this.vs.set(index, v);
        }

        @Override
        public void setPositionf(long vIndex, float x, float y, float z) {
            int index = this.safeIndex(vIndex);
            this.xs.set(index, x);
            this.ys.set(index, y);
            this.zs.set(index, z);
        }

        @Override
        public void setNormalf(long vIndex, float nx, float ny, float nz) {
            int index = this.safeIndex(vIndex);
            this.nxs.set(index, nx);
            this.nys.set(index, ny);
            this.nzs.set(index, nz);
        }

        @Override
        public void setTexturef(long vIndex, float u, float v) {
            int index = this.safeIndex(vIndex);
            this.us.set(index, u);
            this.vs.set(index, v);
        }

        private int safeIndex(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Index too large: " + index);
            }
            return (int)index;
        }
    }
}

