/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.io.ply;

import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.Vertex;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.impl.nio.BufferMesh;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.PlyReader;
import org.smurn.jply.PlyReaderFile;
import org.smurn.jply.util.NormalMode;
import org.smurn.jply.util.NormalizingPlyReader;
import org.smurn.jply.util.TesselationMode;
import org.smurn.jply.util.TextureMode;

public final class PLYMeshIO {
    private PLYMeshIO() {
    }

    public static final BufferMesh open(String source) throws IOException {
        File file = new File(source);
        int[] nels = PLYMeshIO.getNVerticesFaces(source);
        int nVertices = nels[0];
        int nTriangles = nels[1];
        BufferMesh mesh = new BufferMesh(nVertices, nTriangles);
        PLYMeshIO.read(file, (Mesh)mesh);
        return mesh;
    }

    public static final void save(Mesh data, String destination) throws IOException {
        byte[] bytes = PLYMeshIO.writeBinary(data);
        try (FileOutputStream fos = new FileOutputStream(destination);){
            fos.write(bytes);
        }
    }

    public static final void read(File plyFile, Mesh mesh) throws IOException {
        try (FileInputStream is = new FileInputStream(plyFile);){
            PLYMeshIO.read(is, mesh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void read(InputStream plyIS, Mesh mesh) throws IOException {
        PlyReaderFile pr = new PlyReaderFile(plyIS);
        try (NormalizingPlyReader plyReader = new NormalizingPlyReader((PlyReader)pr, TesselationMode.TRIANGLES, NormalMode.ADD_NORMALS_CCW, TextureMode.PASS_THROUGH);){
            PLYMeshIO.read((PlyReader)plyReader, mesh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final BufferMesh open(InputStream plyIS) throws IOException {
        PlyReaderFile pr = new PlyReaderFile(plyIS);
        try (NormalizingPlyReader plyReader = new NormalizingPlyReader((PlyReader)pr, TesselationMode.TRIANGLES, NormalMode.ADD_NORMALS_CCW, TextureMode.PASS_THROUGH);){
            int nVertices = plyReader.getElementCount("vertex");
            int nTriangles = plyReader.getElementCount("face");
            BufferMesh mesh = new BufferMesh(nVertices, nTriangles);
            PLYMeshIO.read((PlyReader)plyReader, (Mesh)mesh);
            BufferMesh bufferMesh = mesh;
            return bufferMesh;
        }
    }

    private static final List<int[]> readTriangles(ElementReader reader) throws IOException {
        ArrayList<int[]> triangles = new ArrayList<int[]>(reader.getCount());
        Element triangle = reader.readElement();
        while (triangle != null) {
            int[] indices = triangle.getIntList("vertex_index");
            triangles.add(indices);
            triangle = reader.readElement();
        }
        return triangles;
    }

    private static final void read(PlyReader plyReader, Mesh mesh) throws IOException {
        ElementReader reader;
        TIntLongHashMap vertexRowMap = null;
        List<int[]> triangles = null;
        while ((reader = plyReader.nextElementReader()) != null) {
            String elementName = reader.getElementType().getName();
            if (elementName.equals("vertex")) {
                vertexRowMap = PLYMeshIO.readVertices(reader, mesh.vertices());
            } else if (elementName.equals("face")) {
                triangles = PLYMeshIO.readTriangles(reader);
            }
            reader.close();
        }
        if (vertexRowMap == null) {
            throw new IOException("Could not find the 'vertex' element in file.");
        }
        if (triangles == null) {
            throw new IOException("Could not find the 'face' element in file.");
        }
        for (int[] triangle : triangles) {
            long v1 = vertexRowMap.get(triangle[0]);
            long v2 = vertexRowMap.get(triangle[1]);
            long v3 = vertexRowMap.get(triangle[2]);
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            mesh.triangles().add(v1, v2, v3, 0.0, 0.0, 0.0);
        }
    }

    private static final TIntLongHashMap readVertices(ElementReader reader, Vertices vertices) throws IOException {
        TIntLongHashMap rowToVertIndex = new TIntLongHashMap();
        int vertCount = 0;
        Element vertex = reader.readElement();
        while (vertex != null) {
            float x = (float)vertex.getDouble("x");
            float z = (float)vertex.getDouble("z");
            float y = (float)vertex.getDouble("y");
            float nx = (float)vertex.getDouble("nx");
            float ny = (float)vertex.getDouble("ny");
            float nz = (float)vertex.getDouble("nz");
            float u = 0.0f;
            float v = 0.0f;
            long vIndex = vertices.addf(x, y, z, nx, ny, nz, 0.0f, 0.0f);
            rowToVertIndex.put(vertCount++, vIndex);
            vertex = reader.readElement();
        }
        return rowToVertIndex;
    }

    public static final byte[] writeBinary(Mesh mesh) {
        int vertexBytes = 36;
        int triangleBytes = 13;
        String header = "ply\nformat binary_little_endian 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n";
        String vertexHeader = "element vertex " + mesh.vertices().sizel() + "\nproperty float x\nproperty float y\nproperty float z\nproperty float nx\nproperty float ny\nproperty float nz\nproperty float u\nproperty float v\n";
        String triangleHeader = "element face " + mesh.triangles().sizel() + "\nproperty list uchar int vertex_index\n";
        String endHeader = "end_header\n";
        long bytes = (long)("ply\nformat binary_little_endian 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n".getBytes().length + vertexHeader.getBytes().length + triangleHeader.getBytes().length + "end_header\n".getBytes().length) + mesh.vertices().sizel() * 36L + mesh.triangles().sizel() * 13L;
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Mesh data too large: " + bytes);
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)bytes).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put("ply\nformat binary_little_endian 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n".getBytes());
        buffer.put(vertexHeader.getBytes());
        buffer.put(triangleHeader.getBytes());
        buffer.put("end_header\n".getBytes());
        if (mesh.vertices().sizel() == 0L) {
            return buffer.array();
        }
        TLongIntHashMap refToVertId = new TLongIntHashMap(mesh.vertices().size());
        int vertId = 0;
        for (Vertex v : mesh.vertices()) {
            buffer.putFloat(v.xf());
            buffer.putFloat(v.yf());
            buffer.putFloat(v.zf());
            buffer.putFloat(v.nxf());
            buffer.putFloat(v.nyf());
            buffer.putFloat(v.nzf());
            buffer.putFloat(v.uf());
            buffer.putFloat(v.vf());
            refToVertId.put(v.index(), vertId);
            ++vertId;
        }
        for (Triangle t : mesh.triangles()) {
            buffer.put((byte)3);
            buffer.putInt(refToVertId.get(t.vertex0()));
            buffer.putInt(refToVertId.get(t.vertex1()));
            buffer.putInt(refToVertId.get(t.vertex2()));
        }
        return buffer.array();
    }

    public static final byte[] writeAscii(Mesh mesh) throws IOException {
        String header = "ply\nformat ascii 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n";
        String vertexHeader = "element vertex " + mesh.vertices().sizel() + "\nproperty float x\nproperty float y\nproperty float z\nproperty float nx\nproperty float ny\nproperty float nz\nproperty float u\n property float v\n";
        String triangleHeader = "element face " + mesh.triangles().sizel() + "\nproperty list uchar int vertex_index\n";
        String endHeader = "end_header\n";
        if (mesh.vertices().sizel() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many vertices: " + mesh.vertices().sizel());
        }
        if (mesh.triangles().sizel() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many triangles: " + mesh.triangles().sizel());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
        writer.write("ply\nformat ascii 1.0\ncomment This binary PLY mesh was created with imagej-mesh.\n");
        writer.write(vertexHeader);
        writer.write(triangleHeader);
        writer.write("end_header\n");
        if (mesh.vertices().sizel() == 0L) {
            ((Writer)writer).flush();
            return os.toByteArray();
        }
        TLongIntHashMap refToVertId = new TLongIntHashMap(mesh.vertices().size());
        int vertId = 0;
        for (Vertex v : mesh.vertices()) {
            writer.write(Float.toString(v.xf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.yf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.zf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.nxf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.nyf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.nzf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.uf()));
            ((Writer)writer).write(32);
            writer.write(Float.toString(v.vf()));
            ((Writer)writer).write(10);
            refToVertId.put(v.index(), vertId);
            ++vertId;
        }
        for (Triangle t : mesh.triangles()) {
            writer.write("3 ");
            writer.write(Integer.toString(refToVertId.get(t.vertex0())));
            ((Writer)writer).write(32);
            writer.write(Integer.toString(refToVertId.get(t.vertex1())));
            ((Writer)writer).write(32);
            writer.write(Integer.toString(refToVertId.get(t.vertex2())));
            ((Writer)writer).write(10);
        }
        ((Writer)writer).flush();
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int[] getNVerticesFaces(String source) throws IOException {
        File file = new File(source);
        try (PlyReaderFile reader = new PlyReaderFile(file);){
            int nVertices = reader.getElementCount("vertex");
            int nTriangles = reader.getElementCount("face");
            int[] nArray = new int[]{nVertices, nTriangles};
            return nArray;
        }
    }
}

