/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.util;

import java.util.Random;
import net.imglib2.mesh.util.SortArray;

public class SortBy {
    public static void sortBy(int[] index, double[] arr, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = SortBy.partition(index, arr, left, right);
        SortBy.sortBy(index, arr, left, i - 1);
        SortBy.sortBy(index, arr, i + 1, right);
    }

    private static int partition(int[] index, double[] arr, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (SortBy.less(arr[index[++i]], arr[index[right]])) {
                continue;
            }
            while (SortBy.less(arr[index[right]], arr[index[--j]]) && j != left) {
            }
            if (i >= j) break;
            SortBy.exch(index, arr, i, j);
        }
        SortBy.exch(index, arr, i, right);
        return i;
    }

    private static final boolean less(double x, double y) {
        return x < y;
    }

    private static void exch(int[] index, double[] arr, int i, int j) {
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static int binarySearch(int[] indices, double[] a, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = a[indices[mid]];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static void main(String[] args) {
        int i;
        int i2;
        int i3;
        int i4;
        Random ran = new Random(1L);
        int n = 10;
        double[] arr = new double[10];
        for (i4 = 0; i4 < 10; ++i4) {
            arr[i4] = ran.nextDouble();
        }
        System.out.print(String.format("Before sorting: %4.2f", arr[0]));
        for (i4 = 1; i4 < arr.length; ++i4) {
            System.out.print(String.format(", %4.2f", arr[i4]));
        }
        System.out.println();
        int[] index = SortArray.quicksort(arr);
        System.out.print(String.format("After sorting:  %4.2f", arr[0]));
        for (i3 = 1; i3 < arr.length; ++i3) {
            System.out.print(String.format(", %4.2f", arr[i3]));
        }
        System.out.println();
        System.out.print(String.format("Index:          %4d", index[0]));
        for (i3 = 1; i3 < arr.length; ++i3) {
            System.out.print(String.format(", %4d", index[i3]));
        }
        System.out.println();
        System.out.println();
        double[] arr2 = new double[10];
        for (i2 = 0; i2 < 10; ++i2) {
            arr2[i2] = ran.nextDouble();
        }
        System.out.print(String.format("New array:      %4.2f", arr2[0]));
        for (i2 = 1; i2 < arr2.length; ++i2) {
            System.out.print(String.format(", %4.2f", arr2[i2]));
        }
        System.out.println();
        int jmax = 7;
        System.out.print(String.format("Before sorting:                    %4d", index[0]));
        for (i = 1; i < 7; ++i) {
            System.out.print(String.format(", %4d", index[i]));
        }
        System.out.println();
        System.out.print(String.format("Values in array for these indices: %4.2f", arr2[index[0]]));
        for (i = 1; i < 7; ++i) {
            System.out.print(String.format(", %4.2f", arr2[index[i]]));
        }
        System.out.println();
        System.out.println("Sort first 7 elements index by new array:");
        SortBy.sortBy(index, arr2, 0, 6);
        System.out.print(String.format("After sorting:                     %4d", index[0]));
        for (i = 1; i < 7; ++i) {
            System.out.print(String.format(", %4d", index[i]));
        }
        System.out.println();
        System.out.print(String.format("Sorted array                       %4.2f", arr2[index[0]]));
        for (i = 1; i < 7; ++i) {
            System.out.print(String.format(", %4.2f", arr2[index[i]]));
        }
        System.out.println();
        System.out.println();
        double key = 0.0;
        for (int i5 = 0; i5 < 11; ++i5) {
            System.out.print(String.format("Let's search for: %.2f", key));
            int k = SortBy.binarySearch(index, arr2, 0, 7, key);
            if (k < 0) {
                k = -(k + 1);
            }
            System.out.println(" -> " + k);
            key += 0.1;
        }
    }
}

