/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.indexer;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.scijava.ops.indexer.OpImplData;
import org.scijava.ops.indexer.OpParameter;
import org.scijava.ops.indexer.ProcessingUtils;

class OpFieldImplData
extends OpImplData {
    private static final Pattern SJF_PATTERN = Pattern.compile("^org\\.scijava\\.function\\.(Computers|Functions|Inplaces|Producer).*");
    private static final Pattern JAVA_PATTERN = Pattern.compile("^java\\.util\\.function\\.(Function|BiFunction).*");

    public OpFieldImplData(Element source, String doc, ProcessingEnvironment env) {
        super(source, doc, env);
    }

    @Override
    void parseAdditionalTags(Element source, List<String[]> additionalTags) {
        Iterator<String> itr = this.getParamTypes(source, additionalTags).iterator();
        for (String[] tag : additionalTags) {
            String pType = itr.hasNext() ? itr.next() : "UNKNOWN";
            switch (tag[0]) {
                case "@input": {
                    String[] inData = ProcessingUtils.tagElementSeparator.split(tag[1], 2);
                    this.params.add(new OpParameter(inData[0], pType, OpParameter.IO_TYPE.INPUT, inData[1], ProcessingUtils.isNullable(inData[1])));
                    break;
                }
                case "@output": {
                    this.params.add(new OpParameter("output", pType, OpParameter.IO_TYPE.OUTPUT, tag[1], false));
                    break;
                }
                case "@container": {
                    String[] containerData = ProcessingUtils.tagElementSeparator.split(tag[1], 2);
                    this.params.add(new OpParameter(containerData[0], pType, OpParameter.IO_TYPE.CONTAINER, containerData[1], false));
                    break;
                }
                case "@mutable": {
                    String[] mutableData = ProcessingUtils.tagElementSeparator.split(tag[1], 2);
                    this.params.add(new OpParameter(mutableData[0], pType, OpParameter.IO_TYPE.MUTABLE, mutableData[1], false));
                }
            }
        }
        Element fieldType = this.env.getTypeUtils().asElement(source.asType());
        if (fieldType instanceof TypeElement) {
            int expNumParams;
            int numParams;
            int expNumReturns;
            ExecutableElement fMethod = ProcessingUtils.findFunctionalMethod(this.env, (TypeElement)fieldType);
            int numReturns = 0;
            for (OpParameter p : this.params) {
                if (p.ioType != OpParameter.IO_TYPE.OUTPUT) continue;
                ++numReturns;
            }
            int n = expNumReturns = fMethod.getReturnType() instanceof NoType ? 0 : 1;
            if (expNumReturns != numReturns) {
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, this.source + " has " + numReturns + " @output tag(s) when it should have " + expNumReturns);
            }
            if ((numParams = this.params.size() - numReturns) != (expNumParams = fMethod.getParameters().size())) {
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, this.source + " has " + numParams + " @input/@container/@mutable tag(s) when it should have " + expNumParams);
            }
        }
    }

    private List<String> getParamTypes(Element source, List<String[]> additionalTags) {
        String fieldStr = source.asType().toString();
        if (!SJF_PATTERN.matcher(fieldStr).find() && !JAVA_PATTERN.matcher(fieldStr).find()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Op Field " + source + " has type" + fieldStr + " - we cannot infer parameter types from this type!");
            return Collections.emptyList();
        }
        Element enclosing = source.getEnclosingElement();
        while (enclosing.getKind() != ElementKind.CLASS) {
            enclosing = enclosing.getEnclosingElement();
        }
        for (TypeParameterElement typeParameterElement : ((TypeElement)enclosing).getTypeParameters()) {
            StringBuilder tpString = new StringBuilder(typeParameterElement.toString()).append(" extends ");
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            for (int i = 0; i < bounds.size(); ++i) {
                tpString.append(bounds.get(i).toString());
                if (i >= bounds.size() - 1) continue;
                tpString.append(" & ");
            }
            String regex = "(?<![a-zA-Z])" + typeParameterElement + "(?![a-zA-Z])";
            fieldStr = fieldStr.replaceAll(regex, tpString.toString());
        }
        String ParamsStr = fieldStr.substring(fieldStr.indexOf(60) + 1, fieldStr.length() - 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder tmp = new StringBuilder();
        int nestCount = 0;
        for (int i = 0; i < ParamsStr.length(); ++i) {
            if (ParamsStr.charAt(i) == '<') {
                tmp.append(ParamsStr.charAt(i));
                ++nestCount;
                continue;
            }
            if (ParamsStr.charAt(i) == '>') {
                tmp.append(ParamsStr.charAt(i));
                --nestCount;
                continue;
            }
            if (ParamsStr.charAt(i) == ',' && nestCount == 0) {
                arrayList.add(tmp.toString());
                tmp = new StringBuilder();
                continue;
            }
            tmp.append(ParamsStr.charAt(i));
        }
        arrayList.add(tmp.toString());
        if (arrayList.size() != additionalTags.size()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not infer parameter types from Field type.");
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    String formulateSource(Element source) {
        return "javaField:/" + URLEncoder.encode(source.getEnclosingElement() + "$" + source, StandardCharsets.UTF_8);
    }
}

