/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import org.lsmp.djep.xjep.DoNothingVisitor;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;

public class SimplificationVisitor
extends DoNothingVisitor {
    private NodeFactory nf;
    private OperatorSet opSet;
    private TreeUtils tu;

    public Node simplify(Node node, XJep xjep) throws ParseException, IllegalArgumentException {
        this.nf = xjep.getNodeFactory();
        this.opSet = xjep.getOperatorSet();
        this.tu = xjep.getTreeUtils();
        if (node == null) {
            return null;
        }
        Node res = (Node)node.jjtAccept(this, null);
        return res;
    }

    public Node simplifyBuiltOperatorNode(Operator op, Node lhs, Node rhs) throws ParseException {
        ASTFunNode res = this.nf.buildOperatorNode(op, lhs, rhs);
        Node res2 = this.simplifyOp(res, new Node[]{lhs, rhs});
        return res2;
    }

    public Node simplifyTripple(XOperator op, Node lhs, Node rhs) throws ParseException {
        Operator op2;
        XOperator rootOp = op.isComposite() ? (XOperator)op.getRootOp() : op;
        if (op.isCommutative() && this.tu.isConstant(rhs)) {
            return this.simplifyBuiltOperatorNode(op, rhs, lhs);
        }
        if (this.tu.isConstant(lhs) && this.tu.isBinaryOperator(rhs)) {
            Node rhsChild1 = rhs.jjtGetChild(0);
            Node rhsChild2 = rhs.jjtGetChild(1);
            XOperator rhsOp = (XOperator)((ASTFunNode)rhs).getOperator();
            XOperator rhsRoot = rhsOp.isComposite() ? (XOperator)rhsOp.getRootOp() : rhsOp;
            if (this.tu.isConstant(rhsChild1)) {
                op2 = rootOp;
                op2 = op == rhsOp ? rootOp : (XOperator)rootOp.getBinaryInverseOp();
                if (rootOp == rhsRoot && rootOp.isAssociative()) {
                    Node newnode = this.simplifyBuiltOperatorNode(op2, this.nf.buildConstantNode(op, lhs, rhsChild1), rhsChild2);
                    return newnode;
                }
                if (op.isDistributiveOver(rhsRoot)) {
                    Node newnode = this.simplifyBuiltOperatorNode(rhsOp, this.nf.buildConstantNode(op, lhs, rhsChild1), this.simplifyBuiltOperatorNode(op, lhs, rhsChild2));
                    return newnode;
                }
            }
            if (this.tu.isConstant(rhsChild2)) {
                op2 = rootOp;
                op2 = op == rhsOp ? rootOp : rootOp.getBinaryInverseOp();
                if (rootOp == rhsRoot && rootOp.isCommutative() && rootOp.isAssociative()) {
                    Node newnode = this.simplifyBuiltOperatorNode(op, this.nf.buildConstantNode(op2, lhs, rhsChild2), rhsChild1);
                    return newnode;
                }
                if (op.isDistributiveOver(rhsRoot)) {
                    Node newnode = this.simplifyBuiltOperatorNode(rhsOp, this.simplifyBuiltOperatorNode(op, lhs, rhsChild1), this.nf.buildConstantNode(op, lhs, rhsChild2));
                    return newnode;
                }
            }
        }
        if (this.tu.isBinaryOperator(lhs) && this.tu.isConstant(rhs)) {
            Node newnode;
            Node lhsChild1 = lhs.jjtGetChild(0);
            Node lhsChild2 = lhs.jjtGetChild(1);
            XOperator lhsOp = (XOperator)((ASTFunNode)lhs).getOperator();
            XOperator lhsRoot = lhsOp.isComposite() ? (XOperator)lhsOp.getRootOp() : lhsOp;
            if (this.tu.isConstant(lhsChild1)) {
                if (rootOp == lhsRoot && rootOp.isAssociative() && rootOp.isCommutative()) {
                    newnode = this.simplifyBuiltOperatorNode(lhsOp, this.nf.buildConstantNode(op, lhsChild1, rhs), lhsChild2);
                    return newnode;
                }
                if (op.isDistributiveOver(lhsRoot)) {
                    newnode = this.simplifyBuiltOperatorNode(lhsOp, this.nf.buildConstantNode(op, lhsChild1, rhs), this.simplifyBuiltOperatorNode(op, lhsChild2, rhs));
                    return newnode;
                }
            }
            if (this.tu.isConstant(lhsChild2)) {
                if (rootOp == lhsRoot && rootOp.isAssociative()) {
                    op2 = rootOp;
                    op2 = op == lhsOp ? rootOp : rootOp.getBinaryInverseOp();
                    Node newnode2 = this.simplifyBuiltOperatorNode(lhsOp, lhsChild1, this.nf.buildConstantNode(op2, lhsChild2, rhs));
                    return newnode2;
                }
                if (op.isDistributiveOver(lhsRoot)) {
                    newnode = this.simplifyBuiltOperatorNode(lhsOp, this.simplifyBuiltOperatorNode(op, lhsChild1, rhs), this.nf.buildConstantNode(op, lhsChild2, rhs));
                    return newnode;
                }
            }
        }
        return null;
    }

    public Node simplifyAdd(Node lhs, Node rhs) throws ParseException {
        if (this.tu.isInfinity(lhs)) {
            if (this.tu.isInfinity(rhs)) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isInfinity(rhs)) {
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isZero(lhs)) {
            return rhs;
        }
        if (this.tu.isZero(rhs)) {
            return lhs;
        }
        if (this.tu.isNegative(lhs)) {
            ASTFunNode newnode = this.nf.buildOperatorNode(this.opSet.getSubtract(), rhs, this.nf.buildConstantNode(this.opSet.getUMinus(), lhs));
            return newnode;
        }
        if (this.tu.isNegative(rhs)) {
            ASTFunNode newnode = this.nf.buildOperatorNode(this.opSet.getSubtract(), lhs, this.nf.buildConstantNode(this.opSet.getUMinus(), rhs));
            return newnode;
        }
        return null;
    }

    public Node simplifySubtract(Node lhs, Node rhs) throws ParseException {
        if (this.tu.isInfinity(lhs)) {
            if (this.tu.isInfinity(rhs)) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isInfinity(rhs)) {
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isZero(rhs)) {
            return lhs;
        }
        if (this.tu.isNegative(rhs)) {
            Node newnode = this.simplifyBuiltOperatorNode(this.opSet.getAdd(), lhs, this.nf.buildConstantNode(this.opSet.getUMinus(), rhs));
            return newnode;
        }
        if (this.tu.getOperator(rhs) == this.opSet.getUMinus()) {
            Node newnode = this.simplifyBuiltOperatorNode(this.opSet.getAdd(), lhs, rhs.jjtGetChild(0));
            return newnode;
        }
        return null;
    }

    public Node simplifyMultiply(Node child1, Node child2) throws ParseException {
        if (this.tu.isZero(child1)) {
            if (this.tu.isInfinity(child2)) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            return this.nf.buildConstantNode(this.tu.getZERO());
        }
        if (this.tu.isZero(child2)) {
            if (this.tu.isInfinity(child1)) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            return this.nf.buildConstantNode(this.tu.getZERO());
        }
        if (this.tu.isInfinity(child1)) {
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isInfinity(child2)) {
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isOne(child1)) {
            return child2;
        }
        if (this.tu.isOne(child2)) {
            return child1;
        }
        if (this.tu.isMinusOne(child1)) {
            ASTFunNode newnode = this.nf.buildOperatorNode(this.opSet.getUMinus(), child2);
            return newnode;
        }
        if (this.tu.isMinusOne(child2)) {
            ASTFunNode newnode = this.nf.buildOperatorNode(this.opSet.getUMinus(), child1);
            return newnode;
        }
        return null;
    }

    public Node simplifyDivide(Node child1, Node child2) throws ParseException {
        if (this.tu.isZero(child2)) {
            if (this.tu.isZero(child1)) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isZero(child1)) {
            return child1;
        }
        if (this.tu.isOne(child2)) {
            return child1;
        }
        if (this.tu.isInfinity(child1)) {
            return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
        }
        if (this.tu.isInfinity(child2)) {
            return this.nf.buildConstantNode(this.tu.getZERO());
        }
        return null;
    }

    public Node simplifyPower(Node child1, Node child2) throws ParseException {
        if (this.tu.isZero(child1)) {
            if (this.tu.isZero(child2)) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            return this.nf.buildConstantNode(this.tu.getZERO());
        }
        if (this.tu.isZero(child2)) {
            return this.nf.buildConstantNode(this.tu.getONE());
        }
        if (this.tu.isOne(child1)) {
            return this.nf.buildConstantNode(this.tu.getONE());
        }
        if (this.tu.isOne(child2)) {
            return child1;
        }
        if (this.tu.isConstant(child2) && this.tu.getOperator(child1) == this.opSet.getPower() && this.tu.isConstant(child1.jjtGetChild(1))) {
            return this.nf.buildOperatorNode(this.opSet.getPower(), child1.jjtGetChild(0), this.nf.buildConstantNode(this.opSet.getMultiply(), child1.jjtGetChild(1), child2));
        }
        return null;
    }

    public Node simplifyOp(ASTFunNode node, Node[] children) throws ParseException {
        boolean allConst = true;
        XOperator op = (XOperator)node.getOperator();
        if (op.getPFMC() instanceof List) {
            return node;
        }
        int nchild = children.length;
        for (int i = 0; i < nchild; ++i) {
            if (!this.tu.isConstant(children[i])) {
                allConst = false;
            }
            if (!this.tu.isNaN(children[i])) continue;
            return this.nf.buildConstantNode(this.tu.getNAN());
        }
        if (allConst) {
            return this.nf.buildConstantNode((Operator)op, children);
        }
        if (nchild == 1 && this.tu.isUnaryOperator(children[0]) && op == this.tu.getOperator(children[0]) && op.isSelfInverse()) {
            return children[0].jjtGetChild(0);
        }
        if (nchild == 2) {
            Node res = null;
            if (this.opSet.getAdd() == op) {
                res = this.simplifyAdd(children[0], children[1]);
            }
            if (this.opSet.getSubtract() == op) {
                res = this.simplifySubtract(children[0], children[1]);
            }
            if (this.opSet.getMultiply() == op) {
                res = this.simplifyMultiply(children[0], children[1]);
            }
            if (this.opSet.getDivide() == op) {
                res = this.simplifyDivide(children[0], children[1]);
            }
            if (this.opSet.getPower() == op) {
                res = this.simplifyPower(children[0], children[1]);
            }
            if (res != null) {
                if (this.tu.isConstant(res)) {
                    return res;
                }
                if (this.tu.isOperator(res)) {
                    Node res2 = this.simplifyOp((ASTFunNode)res, TreeUtils.getChildrenAsArray(res));
                    return res2;
                }
                return res;
            }
            res = this.simplifyTripple(op, children[0], children[1]);
            if (res != null) {
                if (this.tu.isConstant(res)) {
                    return res;
                }
                if (this.tu.isOperator(res)) {
                    Node res2 = this.simplifyOp((ASTFunNode)res, TreeUtils.getChildrenAsArray(res));
                    return res2;
                }
                return res;
            }
        }
        return node;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) throws ParseException {
        int nchild = node.jjtGetNumChildren();
        if (node.isOperator()) {
            XOperator op = (XOperator)node.getOperator();
            if (op.isBinary() && nchild != 2 || op.isUnary() && nchild != 1) {
                throw new ParseException("Wrong number of children for " + nchild + " for operator " + op.getName());
            }
            Node[] children = this.acceptChildrenAsArray(node, data);
            TreeUtils.copyChildrenIfNeeded(node, children);
            Node res = this.simplifyOp(node, children);
            if (res == null) {
                throw new ParseException("null res from simp op");
            }
            return res;
        }
        Node[] children = this.acceptChildrenAsArray(node, data);
        boolean allConst = true;
        for (int i = 0; i < nchild; ++i) {
            if (!this.tu.isConstant(children[i])) {
                allConst = false;
            }
            if (!this.tu.isNaN(children[i])) continue;
            return this.nf.buildConstantNode(this.tu.getNAN());
        }
        if (allConst) {
            return this.nf.buildConstantNode(node.getPFMC(), children);
        }
        return TreeUtils.copyChildrenIfNeeded(node, children);
    }
}

