/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.real.FloatType;
import sc.fiji.labkit.pixel_classification.gpu.GpuFeatureInput;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class FeatureJoiner {
    private final GlobalSettings settings;
    private final List<FeatureOp> features;
    private final int count;

    public FeatureJoiner(List<FeatureOp> features) {
        this.settings = this.checkGlobalSettings(features);
        this.features = features;
        this.count = this.features.stream().mapToInt(FeatureOp::count).sum();
    }

    private GlobalSettings checkGlobalSettings(List<FeatureOp> features) {
        if (features.isEmpty()) {
            return null;
        }
        GlobalSettings settings = features.get(0).globalSettings();
        boolean allEqual = features.stream().allMatch(f -> settings.equals(f.globalSettings()));
        if (!allEqual) {
            throw new IllegalArgumentException("All features in a feature group must use the same global settings");
        }
        return settings;
    }

    public GlobalSettings globalSettings() {
        return this.settings;
    }

    public int count() {
        return this.count;
    }

    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        this.genericApply(output, (featureOp, o) -> featureOp.apply(input, (List<RandomAccessibleInterval<FloatType>>)o));
    }

    public void prefetch(GpuFeatureInput input) {
        for (FeatureOp feature : this.features) {
            feature.prefetch(input);
        }
    }

    public void apply(GpuFeatureInput input, List<GpuView> output) {
        this.genericApply(output, (featureOp, o) -> featureOp.apply(input, (List<GpuView>)o));
    }

    public <T> void genericApply(List<T> output, BiConsumer<FeatureOp, List<T>> applyFeature) {
        if (output.size() != this.count) {
            throw new IllegalArgumentException();
        }
        int startIndex = 0;
        for (FeatureOp feature : this.features) {
            int count = feature.count();
            applyFeature.accept(feature, output.subList(startIndex, startIndex + count));
            startIndex += count;
        }
    }

    public List<String> attributeLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        this.features.stream().map(FeatureOp::attributeLabels).forEach(labels::addAll);
        return labels;
    }

    public List<FeatureOp> features() {
        return Collections.unmodifiableList(this.features);
    }
}

