/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.AbstractBlockSupplier;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.type.NativeType;

class ConcatenatedBlockSupplier<S extends NativeType<S>, T extends NativeType<T>>
extends AbstractBlockSupplier<T> {
    private final BlockSupplier<S> src;
    private final UnaryBlockOperator<S, T> operator;
    private final int numDimensions;

    ConcatenatedBlockSupplier(BlockSupplier<S> srcSupplier, UnaryBlockOperator<S, T> operator) {
        this.src = srcSupplier;
        this.operator = operator;
        if (operator.numSourceDimensions() > 0) {
            if (srcSupplier.numDimensions() != operator.numSourceDimensions()) {
                throw new IllegalArgumentException("UnaryBlockOperator cannot be concatenated: number of dimensions mismatch.");
            }
            this.numDimensions = operator.numTargetDimensions();
        } else {
            this.numDimensions = srcSupplier.numDimensions();
        }
    }

    private ConcatenatedBlockSupplier(ConcatenatedBlockSupplier<S, T> s) {
        this.src = s.src.independentCopy();
        this.operator = s.operator.independentCopy();
        this.numDimensions = s.numDimensions;
    }

    public T getType() {
        return this.operator.getTargetType();
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public void copy(Interval interval, Object dest) {
        this.operator.compute(this.src, interval, dest);
    }

    @Override
    public BlockSupplier<T> independentCopy() {
        return new ConcatenatedBlockSupplier<S, T>(this);
    }
}

