/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gradient;

import java.util.function.ToDoubleFunction;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.AbstractConvertedRandomAccess;
import net.imglib2.converter.AbstractConvertedRandomAccessible;
import net.imglib2.type.Type;
import net.imglib2.type.operators.MulFloatingPoint;

public class ScaleAsFunctionOfPosition<T extends Type<T> & MulFloatingPoint>
extends AbstractConvertedRandomAccessible<T, T> {
    private final ToDoubleFunction<Localizable> scalingFunction;

    public ScaleAsFunctionOfPosition(RandomAccessibleInterval<T> source, ToDoubleFunction<Localizable> scalingFunction) {
        super(source);
        this.scalingFunction = scalingFunction;
    }

    public ScaledRandomAccess<T> randomAccess() {
        return new ScaledRandomAccess(this.source.randomAccess(), this.scalingFunction);
    }

    public AbstractConvertedRandomAccess<T, T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public T getType() {
        return (T)((Type)this.source.getType());
    }

    public static class ScaledRandomAccess<T extends Type<T> & MulFloatingPoint>
    extends AbstractConvertedRandomAccess<T, T> {
        private final T t;
        private final ToDoubleFunction<Localizable> scalingFunction;

        public ScaledRandomAccess(RandomAccess<T> source, ToDoubleFunction<Localizable> scalingFunction) {
            super(source);
            this.t = ((Type)source.get()).createVariable();
            this.scalingFunction = scalingFunction;
        }

        public T get() {
            this.t.set((Type)this.source.get());
            ((MulFloatingPoint)this.t).mul(this.scalingFunction.applyAsDouble((Localizable)this.source));
            return this.t;
        }

        public T getType() {
            return this.t;
        }

        public ScaledRandomAccess<T> copy() {
            return new ScaledRandomAccess<T>(this.source.copy(), this.scalingFunction);
        }
    }
}

