/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.eigen;

import java.util.Optional;
import net.imglib2.algorithm.linalg.eigen.EigenValues;
import net.imglib2.algorithm.linalg.matrix.RealCompositeSymmetricMatrix;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;
import org.ojalgo.matrix.decomposition.Eigenvalue;

public class EigenValuesSymmetric<T extends RealType<T>, U extends ComplexType<U>>
implements EigenValues<T, U> {
    private final int nDim;
    private final double[] evs;
    private final RealCompositeSymmetricMatrix<T> m;
    private final Eigenvalue<Double> ed;
    private final Optional<double[]> emptyOptional = Optional.empty();

    public EigenValuesSymmetric(int nDim) {
        this.nDim = nDim;
        this.evs = new double[nDim];
        this.m = new RealCompositeSymmetricMatrix(null, nDim);
        this.ed = Eigenvalue.PRIMITIVE.make(this.m, true);
    }

    @Override
    public void compute(Composite<T> tensor, Composite<U> evs) {
        this.m.setData(tensor);
        this.ed.computeValuesOnly(this.m);
        this.ed.getEigenvalues(this.evs, this.emptyOptional);
        for (int d = 0; d < this.evs.length; ++d) {
            ((ComplexType)evs.get((long)d)).setReal(this.evs[d]);
        }
    }

    @Override
    public EigenValuesSymmetric<T, U> copy() {
        return new EigenValuesSymmetric<T, U>(this.nDim);
    }
}

