/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.type.numeric.RealType;

public class Minimum<O extends RealType<O>>
implements OFunction<O> {
    private final OFunction<O> a;
    private final OFunction<O> b;

    public Minimum(OFunction<O> a, OFunction<O> b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public final O eval() {
        O y;
        O x = this.a.eval();
        return x.compareTo(y = this.b.eval()) < 0 ? x : y;
    }

    @Override
    public final O eval(Localizable loc) {
        O y;
        O x = this.a.eval(loc);
        return x.compareTo(y = this.b.eval(loc)) < 0 ? x : y;
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(this.a, this.b);
    }

    @Override
    public final double evalDouble() {
        return Math.min(this.a.evalDouble(), this.b.evalDouble());
    }

    @Override
    public final double evalDouble(Localizable loc) {
        return Math.min(this.a.evalDouble(loc), this.b.evalDouble(loc));
    }
}

