/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.HypersphereNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.util.IntervalIndexer;

public final class HyperSphereNeighborhoodCursor<T>
extends HypersphereNeighborhoodLocalizableSampler<T>
implements Cursor<Neighborhood<T>> {
    private final long[] dimensions;
    private final long[] min;
    private final long[] max;
    private long index;
    private final long maxIndex;
    private long maxIndexOnLine;

    public HyperSphereNeighborhoodCursor(RandomAccessibleInterval<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
        super(source, radius, factory, (Interval)source);
        this.dimensions = new long[this.n];
        this.min = new long[this.n];
        this.max = new long[this.n];
        source.dimensions(this.dimensions);
        source.min(this.min);
        source.max(this.max);
        long size = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            size *= this.dimensions[d];
        }
        this.maxIndex = size - 1L;
        this.reset();
    }

    private HyperSphereNeighborhoodCursor(HyperSphereNeighborhoodCursor<T> c) {
        super(c);
        this.dimensions = (long[])c.dimensions.clone();
        this.min = (long[])c.min.clone();
        this.max = (long[])c.max.clone();
        this.maxIndex = c.maxIndex;
        this.index = c.index;
        this.maxIndexOnLine = c.maxIndexOnLine;
    }

    public void fwd() {
        this.currentPos[0] = this.currentPos[0] + 1L;
        if (++this.index > this.maxIndexOnLine) {
            this.nextLine();
        }
    }

    private void nextLine() {
        this.currentPos[0] = this.min[0];
        this.maxIndexOnLine += this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + 1L;
            if (this.currentPos[d] <= this.max[d]) break;
            this.currentPos[d] = this.min[d];
        }
    }

    public void reset() {
        this.index = -1L;
        this.maxIndexOnLine = -1L;
        System.arraycopy(this.max, 0, this.currentPos, 0, this.n);
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public void jumpFwd(long steps) {
        this.index += steps;
        if (this.index < 0L) {
            this.maxIndexOnLine = (1L + this.index) / this.dimensions[0] * this.dimensions[0] - 1L;
            long size = this.maxIndex + 1L;
            IntervalIndexer.indexToPositionWithOffset((long)(size - -this.index % size), (long[])this.dimensions, (long[])this.min, (long[])this.currentPos);
        } else {
            this.maxIndexOnLine = (1L + this.index / this.dimensions[0]) * this.dimensions[0] - 1L;
            IntervalIndexer.indexToPositionWithOffset((long)this.index, (long[])this.dimensions, (long[])this.min, (long[])this.currentPos);
        }
    }

    public Neighborhood<T> next() {
        this.fwd();
        return this.get();
    }

    public void remove() {
    }

    public HyperSphereNeighborhoodCursor<T> copy() {
        return new HyperSphereNeighborhoodCursor<T>(this);
    }
}

