/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhoodFactory;

public abstract class PairOfPointsNeighborhoodLocalizableSampler<T>
extends AbstractEuclideanSpace
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessible<T> source;
    protected final Interval sourceInterval;
    protected final long[] offset;
    protected final long[] currentPos;
    protected final PairOfPointsNeighborhoodFactory<T> neighborhoodFactory;
    protected final Neighborhood<T> currentNeighborhood;

    public PairOfPointsNeighborhoodLocalizableSampler(RandomAccessible<T> source, long[] offset, PairOfPointsNeighborhoodFactory<T> factory, Interval accessInterval) {
        super(source.numDimensions());
        this.source = source;
        this.offset = offset;
        this.currentPos = new long[this.n];
        this.neighborhoodFactory = factory;
        if (accessInterval == null && source instanceof Interval) {
            accessInterval = (Interval)source;
        }
        if (accessInterval == null) {
            this.sourceInterval = null;
        } else {
            long[] accessMin = new long[this.n];
            long[] accessMax = new long[this.n];
            accessInterval.min(accessMin);
            accessInterval.max(accessMax);
            for (int d = 0; d < this.n; ++d) {
                accessMin[d] = Math.min(this.currentPos[d], this.currentPos[d] + offset[d]);
                accessMax[d] = Math.max(this.currentPos[d], this.currentPos[d] + offset[d]);
            }
            this.sourceInterval = new FinalInterval(accessMin, accessMax);
        }
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, offset, this.sourceInterval == null ? source.randomAccess() : source.randomAccess(this.sourceInterval));
    }

    protected PairOfPointsNeighborhoodLocalizableSampler(PairOfPointsNeighborhoodLocalizableSampler<T> c) {
        super(c.n);
        this.source = c.source;
        this.sourceInterval = c.sourceInterval;
        this.offset = (long[])c.offset.clone();
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.offset, this.source.randomAccess());
    }

    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    public Neighborhood<T> getType() {
        return this.currentNeighborhood;
    }

    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

