/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;

public class RectangleNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final long[] currentMin;
    private final long[] currentMax;
    private final long[] dimensions;
    private final RandomAccess<T> sourceRandomAccess;
    private final Interval structuringElementBoundingBox;
    private final long maxIndex;

    public static <T> RectangleNeighborhoodFactory<T> factory() {
        return new RectangleNeighborhoodFactory<T>(){

            @Override
            public Neighborhood<T> create(long[] position, long[] currentMin, long[] currentMax, Interval span, RandomAccess<T> sourceRandomAccess) {
                return new RectangleNeighborhood(position, currentMin, currentMax, span, sourceRandomAccess);
            }
        };
    }

    RectangleNeighborhood(long[] position, long[] currentMin, long[] currentMax, Interval span, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.currentMin = currentMin;
        this.currentMax = currentMax;
        this.dimensions = new long[this.n];
        span.dimensions(this.dimensions);
        long mi = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            mi *= this.dimensions[d];
        }
        this.maxIndex = mi;
        this.sourceRandomAccess = sourceRandomAccess;
        this.structuringElementBoundingBox = span;
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    public RandomAccess<T> getSourceRandomAccess() {
        return this.sourceRandomAccess;
    }

    public long size() {
        return this.maxIndex;
    }

    public T firstElement() {
        return this.cursor().next();
    }

    public T getType() {
        return (T)this.sourceRandomAccess.getType();
    }

    public Object iterationOrder() {
        return this;
    }

    public double realMin(int d) {
        return this.currentMin[d];
    }

    public void realMin(double[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentMin[d];
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentMin[d], d);
        }
    }

    public double realMax(int d) {
        return this.currentMax[d];
    }

    public void realMax(double[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentMax[d];
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentMax[d], d);
        }
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return this.currentMin[d];
    }

    public void min(long[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentMin[d];
        }
    }

    public void min(Positionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentMin[d], d);
        }
    }

    public long max(int d) {
        return this.currentMax[d];
    }

    public void max(long[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentMax[d];
        }
    }

    public void max(Positionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentMax[d], d);
        }
    }

    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.dimensions[d];
        }
    }

    public long dimension(int d) {
        return this.dimensions[d];
    }

    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copy());
    }

    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    public final class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private final RandomAccess<T> source;
        private long index;
        private long maxIndexOnLine;

        public LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.reset();
        }

        protected LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copy();
            this.index = c.index;
        }

        public T get() {
            return this.source.get();
        }

        public T getType() {
            return this.source.getType();
        }

        public void fwd() {
            this.source.fwd(0);
            if (++this.index > this.maxIndexOnLine) {
                this.nextLine();
            }
        }

        private void nextLine() {
            this.source.setPosition(RectangleNeighborhood.this.currentMin[0], 0);
            this.maxIndexOnLine += RectangleNeighborhood.this.dimensions[0];
            for (int d = 1; d < this.n; ++d) {
                this.source.fwd(d);
                if (this.source.getLongPosition(d) <= RectangleNeighborhood.this.currentMax[d]) break;
                this.source.setPosition(RectangleNeighborhood.this.currentMin[d], d);
            }
        }

        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        public T next() {
            this.fwd();
            return this.get();
        }

        public void remove() {
        }

        public void reset() {
            this.source.setPosition(RectangleNeighborhood.this.currentMin);
            this.source.bck(0);
            this.index = 0L;
            this.maxIndexOnLine = RectangleNeighborhood.this.dimensions[0];
        }

        public boolean hasNext() {
            return this.index < RectangleNeighborhood.this.maxIndex;
        }

        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        public void localize(long[] position) {
            this.source.localize(position);
        }

        public void localize(float[] position) {
            this.source.localize(position);
        }

        public void localize(double[] position) {
            this.source.localize(position);
        }

        public void localize(int[] position) {
            this.source.localize(position);
        }

        public LocalCursor copy() {
            return new LocalCursor(this);
        }
    }
}

