/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pcx;

import com.sun.media.imageioimpl.plugins.pcx.PCXConstants;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PCXMetadata
extends IIOMetadata
implements Cloneable,
PCXConstants {
    short version;
    byte bitsPerPixel;
    boolean gotxmin;
    boolean gotymin;
    short xmin;
    short ymin;
    int vdpi;
    int hdpi;
    int hsize;
    int vsize;

    PCXMetadata() {
        super(true, null, null, null, null);
        this.reset();
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeStandardTree(root);
    }

    @Override
    public void reset() {
        this.version = (short)5;
        this.bitsPerPixel = 0;
        this.gotxmin = false;
        this.gotymin = false;
        this.xmin = 0;
        this.ymin = 0;
        this.vdpi = 72;
        this.hdpi = 72;
        this.hsize = 0;
        this.vsize = 0;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        String versionString;
        switch (this.version) {
            case 0: {
                versionString = "2.5";
                break;
            }
            case 2: {
                versionString = "2.8 with palette";
                break;
            }
            case 3: {
                versionString = "2.8 without palette";
                break;
            }
            case 4: {
                versionString = "PC Paintbrush for Windows";
                break;
            }
            case 5: {
                versionString = "3.0";
                break;
            }
            default: {
                versionString = null;
            }
        }
        IIOMetadataNode documentNode = null;
        if (versionString != null) {
            documentNode = new IIOMetadataNode("Document");
            IIOMetadataNode node = new IIOMetadataNode("FormatVersion");
            node.setAttribute("value", versionString);
            documentNode.appendChild(node);
        }
        return documentNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimensionNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("HorizontalPixelOffset");
        node.setAttribute("value", String.valueOf(this.xmin));
        dimensionNode.appendChild(node);
        node = new IIOMetadataNode("VerticalPixelOffset");
        node.setAttribute("value", String.valueOf(this.ymin));
        dimensionNode.appendChild(node);
        node = new IIOMetadataNode("HorizontalPixelSize");
        node.setAttribute("value", String.valueOf(254.0 / (double)this.hdpi));
        dimensionNode.appendChild(node);
        node = new IIOMetadataNode("VerticalPixelSize");
        node.setAttribute("value", String.valueOf(254.0 / (double)this.vdpi));
        dimensionNode.appendChild(node);
        if (this.hsize != 0) {
            node = new IIOMetadataNode("HorizontalScreenSize");
            node.setAttribute("value", String.valueOf(this.hsize));
            dimensionNode.appendChild(node);
        }
        if (this.vsize != 0) {
            node = new IIOMetadataNode("VerticalScreenSize");
            node.setAttribute("value", String.valueOf(this.vsize));
            dimensionNode.appendChild(node);
        }
        return dimensionNode;
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            throw new IIOInvalidTreeException("Root must be javax_imageio_1.0", node);
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String name = node.getNodeName();
            if (!name.equals("Dimension")) continue;
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                String childName = child.getNodeName();
                if (childName.equals("HorizontalPixelOffset")) {
                    String hpo = PCXMetadata.getAttribute(child, "value");
                    this.xmin = Short.valueOf(hpo);
                    this.gotxmin = true;
                    continue;
                }
                if (childName.equals("VerticalPixelOffset")) {
                    String vpo = PCXMetadata.getAttribute(child, "value");
                    this.ymin = Short.valueOf(vpo);
                    this.gotymin = true;
                    continue;
                }
                if (childName.equals("HorizontalPixelSize")) {
                    String hps = PCXMetadata.getAttribute(child, "value");
                    this.hdpi = (int)(254.0f / Float.parseFloat(hps) + 0.5f);
                    continue;
                }
                if (childName.equals("VerticalPixelSize")) {
                    String vps = PCXMetadata.getAttribute(child, "value");
                    this.vdpi = (int)(254.0f / Float.parseFloat(vps) + 0.5f);
                    continue;
                }
                if (childName.equals("HorizontalScreenSize")) {
                    String hss = PCXMetadata.getAttribute(child, "value");
                    this.hsize = Integer.valueOf(hss);
                    continue;
                }
                if (!childName.equals("VerticalScreenSize")) continue;
                String vss = PCXMetadata.getAttribute(child, "value");
                this.vsize = Integer.valueOf(vss);
            }
        }
    }

    private static String getAttribute(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        Node attr = attrs.getNamedItem(attrName);
        return attr != null ? attr.getNodeValue() : null;
    }
}

