/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.util.Iterator;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;

class ComparableLabelMultisetEntryList
extends LabelMultisetEntryList
implements Comparable<LabelMultisetEntryList> {
    private final LabelMultisetEntry ref;

    ComparableLabelMultisetEntryList() {
        this(new LabelMultisetEntry());
    }

    ComparableLabelMultisetEntryList(LabelMultisetEntry ref) {
        this.ref = ref;
    }

    ComparableLabelMultisetEntryList(LabelMultisetEntryList list) {
        this(list, new LabelMultisetEntry());
    }

    ComparableLabelMultisetEntryList(LabelMultisetEntryList list, LabelMultisetEntry ref) {
        this.ref = ref;
        this.referToDataAt(list.data, list.getBaseOffset());
    }

    @Override
    public LabelMultisetEntry createRef() {
        return this.ref;
    }

    @Override
    public int compareTo(LabelMultisetEntryList o) {
        int size = this.size();
        int sizeCompare = Integer.compare(size, o.size());
        if (sizeCompare != 0 || size == 0) {
            return sizeCompare;
        }
        Iterator thisIter = this.iterator();
        Iterator otherIter = o.iterator();
        for (int i = 0; i < size; ++i) {
            LabelMultisetEntry thisNext = (LabelMultisetEntry)thisIter.next();
            LabelMultisetEntry otherNext = (LabelMultisetEntry)otherIter.next();
            int idCompare = Long.compare(thisNext.getId(), otherNext.getId());
            if (idCompare != 0) {
                return idCompare;
            }
            int countCompare = Integer.compare(thisNext.getCount(), otherNext.getCount());
            if (countCompare == 0) continue;
            return countCompare;
        }
        return 0;
    }
}

