/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.View;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class Billboard
extends Behavior {
    public static final int ROTATE_ABOUT_AXIS = 0;
    public static final int ROTATE_ABOUT_POINT = 1;
    WakeupOnElapsedFrames wakeupFrame = new WakeupOnElapsedFrames(0, true);
    int mode = 0;
    Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    Point3f rotationPoint = new Point3f(0.0f, 0.0f, 1.0f);
    private Vector3d nAxis = new Vector3d(0.0, 1.0, 0.0);
    TransformGroup tg = null;
    private Point3d viewPosition = new Point3d();
    private Point3d yUpPoint = new Point3d();
    private Vector3d eyeVec = new Vector3d();
    private Vector3d yUp = new Vector3d();
    private Vector3d zAxis = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d vector = new Vector3d();
    private AxisAngle4d aa = new AxisAngle4d();
    static final double EPSILON = 1.0E-6;

    public Billboard() {
        this.nAxis.x = 0.0;
        this.nAxis.y = 1.0;
        this.nAxis.z = 0.0;
    }

    public Billboard(TransformGroup tg) {
        this.tg = tg;
        this.nAxis.x = 0.0;
        this.nAxis.y = 1.0;
        this.nAxis.z = 0.0;
    }

    public Billboard(TransformGroup tg, int mode, Vector3f axis) {
        this.tg = tg;
        this.mode = mode;
        this.axis.set(axis);
        double invMag = 1.0 / Math.sqrt(axis.x * axis.x + axis.y * axis.y + axis.z * axis.z);
        this.nAxis.x = (double)axis.x * invMag;
        this.nAxis.y = (double)axis.y * invMag;
        this.nAxis.z = (double)axis.z * invMag;
    }

    public Billboard(TransformGroup tg, int mode, Point3f point) {
        this.tg = tg;
        this.mode = mode;
        this.rotationPoint.set(point);
    }

    public void setAlignmentMode(int mode) {
        this.mode = mode;
    }

    public int getAlignmentMode() {
        return this.mode;
    }

    public void setAlignmentAxis(Vector3f axis) {
        this.axis.set(axis);
        double invMag = 1.0 / Math.sqrt(axis.x * axis.x + axis.y * axis.y + axis.z * axis.z);
        this.nAxis.x = (double)axis.x * invMag;
        this.nAxis.y = (double)axis.y * invMag;
        this.nAxis.z = (double)axis.z * invMag;
    }

    public void setAlignmentAxis(float x, float y, float z) {
        this.axis.set(x, y, z);
        this.axis.set(this.axis);
        double invMag = 1.0 / Math.sqrt(this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z);
        this.nAxis.x = (double)this.axis.x * invMag;
        this.nAxis.y = (double)this.axis.y * invMag;
        this.nAxis.z = (double)this.axis.z * invMag;
    }

    public void getAlignmentAxis(Vector3f axis) {
        axis.set(this.axis);
    }

    public void setRotationPoint(Point3f point) {
        this.rotationPoint.set(point);
    }

    public void setRotationPoint(float x, float y, float z) {
        this.rotationPoint.set(x, y, z);
    }

    public void getRotationPoint(Point3f point) {
        point.set(this.rotationPoint);
    }

    public void setTarget(TransformGroup tg) {
        this.tg = tg;
    }

    public TransformGroup getTarget() {
        return this.tg;
    }

    @Override
    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    @Override
    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        double angle = 0.0;
        if (this.tg == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        View v = this.getView();
        if (v == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        Canvas3D canvas = v.getCanvas3D(0);
        Transform3D xform = new Transform3D();
        Transform3D bbXform = new Transform3D();
        Transform3D prevTransform = new Transform3D();
        ((TransformGroupRetained)this.tg.retained).getTransform(prevTransform);
        if (this.mode == 0) {
            canvas.getCenterEyeInImagePlate(this.viewPosition);
            canvas.getImagePlateToVworld(xform);
            xform.transform(this.viewPosition);
            ((NodeRetained)this.tg.retained).getLocalToVworld(xform);
            xform.invert();
            xform.transform(this.viewPosition);
            this.eyeVec.set(this.viewPosition);
            this.eyeVec.normalize();
            boolean status = this.projectToPlane(this.eyeVec, this.nAxis);
            if (status) {
                this.zAxis.x = 0.0;
                this.zAxis.y = 0.0;
                this.zAxis.z = 1.0;
                status = this.projectToPlane(this.zAxis, this.nAxis);
            }
            ((TransformGroupRetained)this.tg.retained).getTransform(xform);
            if (status) {
                this.vector.cross(this.eyeVec, this.zAxis);
                double sign = this.vector.dot(this.nAxis) > 0.0 ? 1.0 : -1.0;
                double dot = this.eyeVec.dot(this.zAxis);
                if (dot > 1.0) {
                    dot = 1.0;
                } else if (dot < -1.0) {
                    dot = -1.0;
                }
                angle = sign * Math.acos(dot);
                this.aa.x = this.nAxis.x;
                this.aa.y = this.nAxis.y;
                this.aa.z = this.nAxis.z;
                this.aa.angle = -angle;
                bbXform.set(this.aa);
                if (!prevTransform.epsilonEquals(bbXform, 1.0E-6)) {
                    this.tg.setTransform(bbXform);
                }
            } else {
                bbXform.setIdentity();
                if (!prevTransform.epsilonEquals(bbXform, 1.0E-6)) {
                    this.tg.setTransform(bbXform);
                }
            }
        } else {
            double dot;
            Transform3D zRotate = new Transform3D();
            canvas.getCenterEyeInImagePlate(this.viewPosition);
            this.yUpPoint.set(this.viewPosition);
            this.yUpPoint.y += 0.01;
            canvas.getImagePlateToVworld(xform);
            xform.transform(this.viewPosition);
            xform.transform(this.yUpPoint);
            ((NodeRetained)this.tg.retained).getLocalToVworld(xform);
            xform.invert();
            xform.transform(this.viewPosition);
            xform.transform(this.yUpPoint);
            this.eyeVec.set(this.viewPosition);
            this.eyeVec.normalize();
            this.yUp.set(this.yUpPoint);
            this.yUp.sub(this.viewPosition);
            this.yUp.normalize();
            this.zAxis.x = 0.0;
            this.zAxis.y = 0.0;
            this.zAxis.z = 1.0;
            this.vector.cross(this.eyeVec, this.zAxis);
            double length = this.vector.length();
            if (length > 1.0E-4) {
                dot = this.eyeVec.dot(this.zAxis);
                if (dot > 1.0) {
                    dot = 1.0;
                } else if (dot < -1.0) {
                    dot = -1.0;
                }
                angle = Math.acos(dot);
                this.aa.x = this.vector.x;
                this.aa.y = this.vector.y;
                this.aa.z = this.vector.z;
                this.aa.angle = -angle;
                zRotate.set(this.aa);
            } else {
                zRotate.set(1.0);
            }
            this.yAxis.x = 0.0;
            this.yAxis.y = 1.0;
            this.yAxis.z = 0.0;
            zRotate.transform(this.yAxis);
            boolean status = this.projectToPlane(this.yAxis, this.eyeVec);
            if (status) {
                status = this.projectToPlane(this.yUp, this.eyeVec);
            }
            ((TransformGroupRetained)this.tg.retained).getTransform(xform);
            if (status) {
                dot = this.yUp.dot(this.yAxis);
                if (dot > 1.0) {
                    dot = 1.0;
                } else if (dot < -1.0) {
                    dot = -1.0;
                }
                angle = Math.acos(dot);
                this.vector.cross(this.yUp, this.yAxis);
                if (this.eyeVec.dot(this.vector) < 0.0) {
                    angle *= -1.0;
                }
                this.aa.x = this.eyeVec.x;
                this.aa.y = this.eyeVec.y;
                this.aa.z = this.eyeVec.z;
                this.aa.angle = -angle;
                xform.set(this.aa);
                this.vector.x = this.rotationPoint.x;
                this.vector.y = this.rotationPoint.y;
                this.vector.z = this.rotationPoint.z;
                bbXform.set(this.vector);
                bbXform.mul(xform);
                bbXform.mul(zRotate);
                this.vector.scale(-1.0);
                xform.set(this.vector);
                bbXform.mul(xform);
                if (!prevTransform.epsilonEquals(bbXform, 1.0E-6)) {
                    this.tg.setTransform(bbXform);
                }
            } else {
                bbXform.setIdentity();
                if (!prevTransform.epsilonEquals(bbXform, 1.0E-6)) {
                    this.tg.setTransform(bbXform);
                }
            }
        }
        this.wakeupOn(this.wakeupFrame);
    }

    private boolean projectToPlane(Vector3d projVec, Vector3d planeVec) {
        double dis = planeVec.dot(projVec);
        projVec.x -= planeVec.x * dis;
        projVec.y -= planeVec.y * dis;
        projVec.z -= planeVec.z * dis;
        double length = projVec.length();
        if (length < 1.0E-6) {
            return false;
        }
        projVec.scale(1.0 / length);
        return true;
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Billboard b = new Billboard();
        b.duplicateNode(this, forceDuplicate);
        return b;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        Billboard bb = (Billboard)originalNode;
        this.setAlignmentMode(bb.getAlignmentMode());
        Vector3f v = new Vector3f();
        bb.getAlignmentAxis(v);
        this.setAlignmentAxis(v);
        Point3f p = new Point3f();
        bb.getRotationPoint(p);
        this.setRotationPoint(p);
        this.setTarget(bb.getTarget());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        TransformGroup g = this.getTarget();
        if (g != null) {
            this.setTarget((TransformGroup)referenceTable.getNewObjectReference(g));
        }
    }
}

