/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.ZProjector;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.TypeConverter;
import java.awt.Frame;
import sc.fiji.i5d.Image5D;

public class Z_Project
implements PlugIn {
    private int startSlice = 1;
    private int stopSlice = 1;
    private static int method = 1;
    private static boolean bDisplayedChannelsOnly = false;
    private static boolean bAllTimeFrames = false;
    private static boolean bOutputImage5D = false;
    private static boolean bDoScaling = true;
    private ImagePlus imp;
    private Image5D i5d;

    public Z_Project() {
    }

    public Z_Project(Image5D i5d) {
        this.setImage(i5d);
    }

    public void run(String arg) {
        IJ.register(Z_Project.class);
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (!(this.imp instanceof Image5D)) {
            IJ.error((String)"Z Projection", (String)"Image5D required");
            return;
        }
        this.setImage((Image5D)this.imp);
        GenericDialog gd = new GenericDialog("ZProjection", (Frame)IJ.getInstance());
        gd.addNumericField("Start slice:", (double)this.startSlice, 0);
        gd.addNumericField("Stop slice:", (double)this.stopSlice, 0);
        gd.addChoice("Projection Type", ZProjector.METHODS, ZProjector.METHODS[method]);
        gd.addCheckbox("Displayed Channels only", bDisplayedChannelsOnly);
        gd.addCheckbox("All Time Frames", bAllTimeFrames);
        gd.addCheckbox("Output as Image5D", bOutputImage5D);
        gd.addCheckbox("Copy Contrast and Brightness", bDoScaling);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.setStartSlice((int)gd.getNextNumber());
        this.setStopSlice((int)gd.getNextNumber());
        this.setMethod(gd.getNextChoiceIndex());
        this.setDisplayedChannelsOnly(gd.getNextBoolean());
        this.setAllTimeFrames(gd.getNextBoolean());
        this.setOutputImage5D(gd.getNextBoolean());
        this.setDoScaling(gd.getNextBoolean());
        if (this.stopSlice < this.startSlice) {
            return;
        }
        long tstart = System.currentTimeMillis();
        if (bOutputImage5D) {
            Image5D resultI5D = this.doI5DProjection();
            if (resultI5D != null) {
                resultI5D.show();
            }
        } else {
            ImagePlus resultImage = this.doProjection();
            if (resultImage != null) {
                resultImage.show();
            }
        }
        long tstop = System.currentTimeMillis();
        IJ.showStatus((String)("ZProject: " + IJ.d2s((double)((double)(tstop - tstart) / 1000.0), (int)2) + " seconds"));
    }

    public void setImage(Image5D i5d) {
        this.i5d = i5d;
        this.imp = i5d;
        this.startSlice = 1;
        this.stopSlice = this.imp.getStackSize();
    }

    public void setStartSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = slice;
    }

    public void setStopSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = slice;
    }

    public void setMethod(int projMethod) {
        method = projMethod;
    }

    public void setDisplayedChannelsOnly(boolean displayedChannelsOnly) {
        bDisplayedChannelsOnly = displayedChannelsOnly;
    }

    public void setAllTimeFrames(boolean allTimeFrames) {
        bAllTimeFrames = allTimeFrames;
    }

    public void setOutputImage5D(boolean outputImage5D) {
        bOutputImage5D = outputImage5D;
    }

    public void setDoScaling(boolean doScaling) {
        bDoScaling = doScaling;
    }

    ImagePlus doProjection() {
        if (!this.imp.lock()) {
            return null;
        }
        int currentChannel = this.i5d.getCurrentChannel();
        int currentSlice = this.i5d.getCurrentSlice();
        int currentFrame = this.i5d.getCurrentFrame();
        int nProjectedChannels = 0;
        int[] projectedChannels = new int[this.i5d.getNChannels()];
        for (int c = 1; c <= this.i5d.getNChannels(); ++c) {
            this.i5d.storeChannelProperties(c);
            if (bDisplayedChannelsOnly && (this.i5d.getDisplayMode() == 2 && !this.i5d.getChannelDisplayProperties(c).isDisplayedInOverlay() || this.i5d.getDisplayMode() != 2 && c != currentChannel)) continue;
            projectedChannels[nProjectedChannels] = c;
            ++nProjectedChannels;
        }
        if (bDisplayedChannelsOnly && nProjectedChannels == 0) {
            return null;
        }
        int startFrame = this.i5d.getCurrentFrame();
        int nFrames = 1;
        if (bAllTimeFrames) {
            startFrame = 1;
            nFrames = this.i5d.getNFrames();
        }
        byte[] reds = new byte[this.i5d.getWidth() * this.i5d.getHeight()];
        byte[] greens = new byte[this.i5d.getWidth() * this.i5d.getHeight()];
        byte[] blues = new byte[this.i5d.getWidth() * this.i5d.getHeight()];
        String newTitle = WindowManager.makeUniqueName((String)(this.imp.getTitle() + " Projection"));
        ImagePlus resultImp = IJ.createImage((String)newTitle, (String)"rgb black", (int)this.i5d.getWidth(), (int)this.i5d.getHeight(), (int)nFrames);
        resultImp.setCalibration(this.imp.getCalibration().copy());
        for (int frame = startFrame; frame < startFrame + nFrames; ++frame) {
            for (int destChannel = 1; destChannel <= nProjectedChannels; ++destChannel) {
                int srcChannel = projectedChannels[destChannel - 1];
                this.i5d.setCurrentPosition(0, 0, srcChannel - 1, currentSlice - 1, frame - 1);
                ImagePlus tempImg = new ImagePlus(this.imp.getTitle() + " Projection", this.i5d.getStack());
                ZProjector zp = new ZProjector(tempImg);
                zp.setStartSlice(this.startSlice);
                zp.setStopSlice(this.stopSlice);
                zp.setMethod(method);
                zp.doProjection();
                ImagePlus proj = zp.getProjection();
                if (bDoScaling) {
                    proj.getProcessor().setMinAndMax(this.i5d.getChannelDisplayProperties(srcChannel).getMinValue(), this.i5d.getChannelDisplayProperties(srcChannel).getMaxValue());
                } else {
                    proj.getProcessor().resetMinAndMax();
                }
                ColorProcessor proc = (ColorProcessor)new TypeConverter(proj.getProcessor(), bDoScaling).convertToRGB();
                int[] rgb = new int[3];
                for (int x = 0; x < this.imp.getWidth(); ++x) {
                    for (int y = 0; y < this.imp.getHeight(); ++y) {
                        int pos = x + this.imp.getWidth() * y;
                        proc.getPixel(x, y, rgb);
                        int newval = rgb[0] + (0xFF & reds[pos]);
                        reds[pos] = newval < 256 ? (int)newval : -1;
                        newval = rgb[1] + (0xFF & greens[pos]);
                        greens[pos] = newval < 256 ? (int)newval : -1;
                        newval = rgb[2] + (0xFF & blues[pos]);
                        blues[pos] = newval < 256 ? (int)newval : -1;
                    }
                }
            }
            ColorProcessor cp = new ColorProcessor(this.imp.getWidth(), this.imp.getHeight());
            cp.setRGB(reds, greens, blues);
            resultImp.setSlice(frame - startFrame + 1);
            resultImp.setProcessor(null, (ImageProcessor)cp);
            for (int i = 0; i < this.imp.getWidth() * this.imp.getHeight(); ++i) {
                reds[i] = 0;
                greens[i] = 0;
                blues[i] = 0;
            }
        }
        this.i5d.setCurrentPosition(0, 0, currentChannel - 1, currentSlice - 1, currentFrame - 1);
        this.imp.unlock();
        return resultImp;
    }

    Image5D doI5DProjection() {
        int currentChannel = this.i5d.getCurrentChannel();
        int currentSlice = this.i5d.getCurrentSlice();
        int currentFrame = this.i5d.getCurrentFrame();
        int nProjectedChannels = 0;
        int[] projectedChannels = new int[this.i5d.getNChannels()];
        for (int c = 1; c <= this.i5d.getNChannels(); ++c) {
            this.i5d.storeChannelProperties(c);
            if (bDisplayedChannelsOnly && (this.i5d.getDisplayMode() == 2 && !this.i5d.getChannelDisplayProperties(c).isDisplayedInOverlay() || this.i5d.getDisplayMode() != 2 && c != currentChannel)) continue;
            projectedChannels[nProjectedChannels] = c;
            ++nProjectedChannels;
        }
        if (bDisplayedChannelsOnly && nProjectedChannels == 0) {
            return null;
        }
        int startFrame = this.i5d.getCurrentFrame();
        int nFrames = 1;
        if (bAllTimeFrames) {
            startFrame = 1;
            nFrames = this.i5d.getNFrames();
        }
        String newTitle = WindowManager.makeUniqueName((String)(this.imp.getTitle() + " Projection"));
        Image5D resultI5D = new Image5D(newTitle, this.i5d.getType(), this.i5d.getWidth(), this.i5d.getHeight(), nProjectedChannels, 1, nFrames, false);
        resultI5D.setCalibration(this.i5d.getCalibration().copy());
        for (int frame = startFrame; frame < startFrame + nFrames; ++frame) {
            for (int destChannel = 1; destChannel <= nProjectedChannels; ++destChannel) {
                int srcChannel = projectedChannels[destChannel - 1];
                this.i5d.setCurrentPosition(0, 0, srcChannel - 1, currentSlice - 1, frame - 1);
                ImagePlus tempImg = new ImagePlus(this.imp.getTitle() + " Projection", this.i5d.getStack());
                ZProjector zp = new ZProjector(tempImg);
                zp.setStartSlice(this.startSlice);
                zp.setStopSlice(this.stopSlice);
                zp.setMethod(method);
                zp.doProjection();
                ImagePlus proj = zp.getProjection();
                resultI5D.setPixels(proj.getProcessor().getPixels(), destChannel, 1, frame - startFrame + 1);
                if (frame != startFrame) continue;
                if (destChannel == resultI5D.getCurrentChannel()) {
                    resultI5D.setChannelCalibration(destChannel, this.i5d.getChannelCalibration(srcChannel).copy());
                    resultI5D.setChannelDisplayProperties(destChannel, this.i5d.getChannelDisplayProperties(srcChannel).copy());
                    resultI5D.restoreCurrentChannelProperties();
                } else {
                    resultI5D.setChannelCalibration(destChannel, this.i5d.getChannelCalibration(srcChannel).copy());
                    resultI5D.setChannelDisplayProperties(destChannel, this.i5d.getChannelDisplayProperties(srcChannel).copy());
                    resultI5D.restoreChannelProperties(destChannel);
                }
                if (bDoScaling) continue;
                resultI5D.getProcessor(destChannel).resetMinAndMax();
            }
        }
        this.i5d.setCurrentPosition(0, 0, currentChannel - 1, currentSlice - 1, currentFrame - 1);
        this.imp.unlock();
        return resultI5D;
    }
}

