/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ColorChooser;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.ColorPicker;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.plugin.tool.ArrowTool;
import ij.plugin.tool.BrushTool;
import ij.plugin.tool.MacroToolRunner;
import ij.plugin.tool.OverlayBrushTool;
import ij.plugin.tool.PixelInspectionTool;
import ij.plugin.tool.PlugInTool;
import ij.plugin.tool.RoiRotationTool;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;

public class Toolbar
extends Canvas
implements MouseListener,
MouseMotionListener,
ItemListener,
ActionListener {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int LINE = 4;
    public static final int POLYLINE = 5;
    public static final int FREELINE = 6;
    public static final int POINT = 7;
    public static final int CROSSHAIR = 7;
    public static final int WAND = 8;
    public static final int TEXT = 9;
    public static final int UNUSED = 10;
    public static final int MAGNIFIER = 11;
    public static final int HAND = 12;
    public static final int DROPPER = 13;
    public static final int ANGLE = 14;
    public static final int CUSTOM1 = 15;
    public static final int CUSTOM2 = 16;
    public static final int CUSTOM3 = 17;
    public static final int CUSTOM4 = 18;
    public static final int CUSTOM5 = 19;
    public static final int CUSTOM6 = 20;
    public static final int CUSTOM7 = 21;
    public static final int DOUBLE_CLICK_THRESHOLD = 650;
    public static final int RECT_ROI = 0;
    public static final int ROUNDED_RECT_ROI = 1;
    public static final int ROTATED_RECT_ROI = 2;
    public static final int OVAL_ROI = 0;
    public static final int ELLIPSE_ROI = 1;
    public static final int BRUSH_ROI = 2;
    public static final String[] builtInTools = new String[]{"Arrow", "Brush", "Command Finder", "Developer Menu", "Flood Filler", "Label Maker", "LUT Menu", "Overlay Brush", "Pencil", "Pixel Inspector", "Selection Rotator", "Spray Can", "Stacks Menu", "ROI Menu"};
    private static final String[] builtInTools2 = new String[]{"Pixel Inspection Tool", "Paintbrush Tool", "Flood Fill Tool"};
    private static final int NUM_TOOLS = 23;
    private static final int MAX_EXTRA_TOOLS = 8;
    private static final int MAX_TOOLS = 31;
    private static final int NUM_BUTTONS = 21;
    private static final int BUTTON_WIDTH = 30;
    private static final int BUTTON_HEIGHT = 31;
    private static final int SIZE = 28;
    private static final int GAP_SIZE = 9;
    private static final int OFFSET = 7;
    private static final String BRUSH_SIZE = "toolbar.brush.size";
    public static final String CORNER_DIAMETER = "toolbar.arc.size";
    public static String TOOL_KEY = "toolbar.tool";
    private Dimension ps;
    private boolean[] down;
    private static int current;
    private int previousTool;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String[] names = new String[31];
    private String[] icons = new String[31];
    private PlugInTool[] tools = new PlugInTool[31];
    private PopupMenu[] menus = new PopupMenu[31];
    private int nExtraTools;
    private MacroInstaller macroInstaller;
    private boolean addingSingleTool;
    private boolean installingStartupTool;
    private boolean doNotSavePrefs;
    private int pc;
    private String icon;
    private int startupTime;
    private PopupMenu rectPopup;
    private PopupMenu ovalPopup;
    private PopupMenu pointPopup;
    private PopupMenu linePopup;
    private PopupMenu zoomPopup;
    private PopupMenu pickerPopup;
    private PopupMenu switchPopup;
    private CheckboxMenuItem rectItem;
    private CheckboxMenuItem roundRectItem;
    private CheckboxMenuItem rotatedRectItem;
    private CheckboxMenuItem ovalItem;
    private CheckboxMenuItem ellipseItem;
    private CheckboxMenuItem brushItem;
    private CheckboxMenuItem pointItem;
    private CheckboxMenuItem multiPointItem;
    private CheckboxMenuItem straightLineItem;
    private CheckboxMenuItem polyLineItem;
    private CheckboxMenuItem freeLineItem;
    private CheckboxMenuItem arrowItem;
    private String currentSet = "Startup Macros";
    private Timer pressTimer;
    private static int longClickDelay;
    private boolean disableRecording;
    private static Color foregroundColor;
    private static Color backgroundColor;
    private static double foregroundValue;
    private static double backgroundValue;
    private static int ovalType;
    private static int rectType;
    private static boolean multiPointMode;
    private static boolean arrowMode;
    private static int brushSize;
    private static int arcSize;
    private int lineType = 4;
    private static boolean legacyMode;
    private static double dscale;
    private static int scale;
    private static int buttonWidth;
    private static int buttonHeight;
    private static int gapSize;
    private static int offset;
    private Color gray = new Color(228, 228, 228);
    private Color brighter = this.gray.brighter();
    private Color darker = new Color(180, 180, 180);
    private Color evenDarker = new Color(110, 110, 110);
    private Color triangleColor = new Color(150, 0, 0);
    private Color toolColor = new Color(0, 25, 45);
    public static final int SPARE1 = 10;
    public static final int SPARE2 = 15;
    public static final int SPARE3 = 16;
    public static final int SPARE4 = 17;
    public static final int SPARE5 = 18;
    public static final int SPARE6 = 19;
    public static final int SPARE7 = 20;
    public static final int SPARE8 = 21;
    public static final int SPARE9 = 22;

    public Toolbar() {
        this.init();
        this.down = new boolean[31];
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(Color.black);
        this.setBackground(ImageJ.backgroundColor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
        this.names[this.getNumTools() - 1] = "\"More Tools\" menu (switch toolsets or add tools)";
        this.icons[this.getNumTools() - 1] = "C900T0d18>T6d18>";
        this.addPopupMenus();
    }

    public void init() {
        dscale = Prefs.getGuiScale();
        scale = (int)Math.round(dscale);
        if (dscale >= 1.5 && dscale < 2.0 || dscale >= 2.5 && dscale < 3.0) {
            dscale = scale;
        }
        if (dscale > 1.0) {
            buttonWidth = (int)(28.0 * dscale);
            buttonHeight = (int)(29.0 * dscale);
            offset = (int)Math.round(6.0 * dscale);
        } else {
            buttonWidth = 30;
            buttonHeight = 31;
            offset = 7;
        }
        gapSize = 9;
        this.ps = new Dimension(buttonWidth * 21 - (buttonWidth - gapSize), buttonHeight);
    }

    void addPopupMenus() {
        this.rectPopup = this.newPopupMenu();
        this.rectItem = new CheckboxMenuItem("Rectangle", rectType == 0);
        this.rectItem.addItemListener(this);
        this.rectPopup.add(this.rectItem);
        this.roundRectItem = new CheckboxMenuItem("Rounded Rectangle", rectType == 1);
        this.roundRectItem.addItemListener(this);
        this.rectPopup.add(this.roundRectItem);
        this.rotatedRectItem = new CheckboxMenuItem("Rotated Rectangle", rectType == 2);
        this.rotatedRectItem.addItemListener(this);
        this.rectPopup.add(this.rotatedRectItem);
        this.add(this.rectPopup);
        this.ovalPopup = this.newPopupMenu();
        this.ovalItem = new CheckboxMenuItem("Oval selections", ovalType == 0);
        this.ovalItem.addItemListener(this);
        this.ovalPopup.add(this.ovalItem);
        this.ellipseItem = new CheckboxMenuItem("Elliptical selections", ovalType == 1);
        this.ellipseItem.addItemListener(this);
        this.ovalPopup.add(this.ellipseItem);
        this.brushItem = new CheckboxMenuItem("Selection Brush Tool", ovalType == 2);
        this.brushItem.addItemListener(this);
        this.ovalPopup.add(this.brushItem);
        this.add(this.ovalPopup);
        this.pointPopup = this.newPopupMenu();
        this.pointItem = new CheckboxMenuItem("Point Tool", !multiPointMode);
        this.pointItem.addItemListener(this);
        this.pointPopup.add(this.pointItem);
        this.multiPointItem = new CheckboxMenuItem("Multi-point Tool", multiPointMode);
        this.multiPointItem.addItemListener(this);
        this.pointPopup.add(this.multiPointItem);
        this.add(this.pointPopup);
        this.linePopup = this.newPopupMenu();
        this.straightLineItem = new CheckboxMenuItem("Straight Line", this.lineType == 4 && !arrowMode);
        this.straightLineItem.addItemListener(this);
        this.linePopup.add(this.straightLineItem);
        this.polyLineItem = new CheckboxMenuItem("Segmented Line", this.lineType == 5);
        this.polyLineItem.addItemListener(this);
        this.linePopup.add(this.polyLineItem);
        this.freeLineItem = new CheckboxMenuItem("Freehand Line", this.lineType == 6);
        this.freeLineItem.addItemListener(this);
        this.linePopup.add(this.freeLineItem);
        this.arrowItem = new CheckboxMenuItem("Arrow tool", this.lineType == 4 && !arrowMode);
        this.arrowItem.addItemListener(this);
        this.linePopup.add(this.arrowItem);
        this.add(this.linePopup);
        this.zoomPopup = this.newPopupMenu();
        this.addMenuItem(this.zoomPopup, "Reset Zoom");
        this.addMenuItem(this.zoomPopup, "Zoom In");
        this.addMenuItem(this.zoomPopup, "Zoom Out");
        this.addMenuItem(this.zoomPopup, "View 100%");
        this.addMenuItem(this.zoomPopup, "Zoom To Selection");
        this.addMenuItem(this.zoomPopup, "Scale to Fit");
        this.addMenuItem(this.zoomPopup, "Set...");
        this.addMenuItem(this.zoomPopup, "Maximize");
        this.add(this.zoomPopup);
        this.pickerPopup = this.newPopupMenu();
        this.addMenuItem(this.pickerPopup, "White/Black");
        this.addMenuItem(this.pickerPopup, "Black/White");
        this.addMenuItem(this.pickerPopup, "Red");
        this.addMenuItem(this.pickerPopup, "Green");
        this.addMenuItem(this.pickerPopup, "Blue");
        this.addMenuItem(this.pickerPopup, "Yellow");
        this.addMenuItem(this.pickerPopup, "Cyan");
        this.addMenuItem(this.pickerPopup, "Magenta");
        this.pickerPopup.addSeparator();
        this.addMenuItem(this.pickerPopup, "Foreground...");
        this.addMenuItem(this.pickerPopup, "Background...");
        this.addMenuItem(this.pickerPopup, "Colors...");
        this.addMenuItem(this.pickerPopup, "Color Picker...");
        this.add(this.pickerPopup);
        this.switchPopup = this.newPopupMenu();
        this.add(this.switchPopup);
    }

    private PopupMenu newPopupMenu() {
        PopupMenu popup = new PopupMenu();
        GUI.scalePopupMenu(popup);
        return popup;
    }

    private void addMenuItem(PopupMenu menu, String command) {
        MenuItem item = new MenuItem(command);
        item.addActionListener(this);
        menu.add(item);
    }

    public static int getToolId() {
        int id = current;
        if (legacyMode) {
            if (id == 15) {
                id = 10;
            } else if (id >= 16) {
                --id;
            }
        }
        return id;
    }

    public int getToolId(String name) {
        int tool = -1;
        for (int i = 0; i < this.getNumTools(); ++i) {
            if (this.names[i] == null || !this.names[i].startsWith(name)) continue;
            tool = i;
            break;
        }
        return tool;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics g) {
        int i;
        if (g == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.setStrokeWidth(g2d);
        for (i = 0; i < 4; ++i) {
            this.drawButton(g, i);
        }
        this.drawButton(g, this.lineType);
        for (i = 7; i < this.getNumTools(); ++i) {
            this.drawButton(g, i);
        }
    }

    private void setStrokeWidth(Graphics2D g2d) {
        if (scale == 1) {
            if (dscale > 1.0) {
                g2d.setStroke(new BasicStroke(IJ.isMacOSX() ? 1.4f : 1.25f));
            }
        } else {
            g2d.setStroke(new BasicStroke(scale));
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (null == g) {
            return;
        }
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(raised ? this.brighter : this.evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void drawButton(Graphics g, int tool) {
        if (g == null) {
            return;
        }
        if (legacyMode) {
            if (tool == 10) {
                tool = 15;
            } else if (tool >= 15) {
                ++tool;
            }
            if (tool == 5 && this.lineType != 5 || tool == 6 && this.lineType != 6) {
                return;
            }
        }
        int index = this.toolIndex(tool);
        int x = index * buttonWidth + 1 * scale;
        if (tool >= 15) {
            x -= buttonWidth - gapSize;
        }
        if (tool != 10) {
            this.fill3DRect(g, x, 1, buttonWidth, buttonHeight - 1, !this.down[tool]);
        }
        g.setColor(this.toolColor);
        x = index * buttonWidth + offset;
        if (tool >= 15) {
            x -= buttonWidth - gapSize;
        }
        int y = offset;
        if (dscale == 1.3) {
            ++x;
            ++y;
        }
        if (dscale == 1.4) {
            x += 2;
            y += 2;
        }
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        if (tool >= 15 && tool <= this.getNumTools() && this.icons[tool] != null) {
            this.drawIcon(g, tool, x + 1 * scale, y + 1 * scale);
            return;
        }
        switch (tool) {
            case 0: {
                this.xOffset = x;
                this.yOffset = y;
                if (rectType == 1) {
                    g.drawRoundRect(x - 1 * scale, y + 1 * scale, 17 * scale, 13 * scale, 8 * scale, 8 * scale);
                } else if (rectType == 2) {
                    this.polyline(0, 10, 7, 0, 15, 6, 8, 16, 0, 10);
                } else {
                    g.drawRect(x - 1 * scale, y + 1 * scale, 17 * scale, 13 * scale);
                }
                this.drawTriangle(16, 16);
                return;
            }
            case 1: {
                this.xOffset = x;
                this.yOffset = y;
                if (ovalType == 2) {
                    this.yOffset = y - 1;
                    this.polyline(6, 4, 8, 2, 12, 1, 15, 2, 16, 4, 15, 7, 12, 8, 9, 11, 9, 14, 6, 16, 2, 16, 0, 13, 1, 10, 4, 9, 6, 7, 6, 4);
                } else if (ovalType == 1) {
                    this.xOffset = x - 1;
                    this.yOffset = y + 1;
                    this.polyline(11, 0, 13, 0, 14, 1, 15, 1, 16, 2, 17, 3, 17, 7, 12, 12, 11, 12, 10, 13, 8, 13, 7, 14, 4, 14, 3, 13, 2, 13, 1, 12, 1, 11, 0, 10, 0, 9, 1, 8, 1, 7, 6, 2, 7, 2, 8, 1, 10, 1, 11, 0);
                } else {
                    g.drawOval(x, y + 1 * scale, 17 * scale, 13 * scale);
                }
                this.drawTriangle(16, 16);
                return;
            }
            case 2: {
                this.xOffset = x + 1;
                this.yOffset = y + 2;
                this.polyline(4, 0, 15, 0, 15, 1, 11, 5, 11, 6, 14, 11, 14, 12, 0, 12, 0, 4, 4, 0);
                return;
            }
            case 3: {
                this.xOffset = x;
                this.yOffset = y + 3;
                this.polyline(2, 0, 5, 0, 7, 3, 10, 3, 12, 0, 15, 0, 17, 2, 17, 5, 16, 8, 13, 10, 11, 11, 6, 11, 4, 10, 1, 8, 0, 6, 0, 2, 2, 0);
                return;
            }
            case 4: {
                if (arrowMode) {
                    this.xOffset = x;
                    this.yOffset = y;
                    this.m(1, 14);
                    this.d(14, 1);
                    this.m(6, 5);
                    this.d(14, 1);
                    this.m(10, 9);
                    this.d(14, 1);
                    this.m(6, 5);
                    this.d(10, 9);
                } else {
                    this.xOffset = x - 1;
                    this.yOffset = y - 1;
                    this.m(1, 17);
                    this.d(18, 0);
                    this.drawDot(0, 16);
                    this.drawDot(17, 0);
                }
                this.drawTriangle(16, 16);
                return;
            }
            case 5: {
                this.xOffset = x;
                this.yOffset = y;
                this.polyline(15, 6, 11, 2, 1, 2, 1, 3, 7, 9, 2, 14);
                this.drawTriangle(14, 16);
                return;
            }
            case 6: {
                this.xOffset = x;
                this.yOffset = y;
                this.polyline(16, 4, 14, 6, 12, 6, 9, 3, 8, 3, 6, 7, 2, 11, 1, 11);
                this.drawTriangle(14, 16);
                return;
            }
            case 7: {
                this.xOffset = x;
                this.yOffset = y;
                if (multiPointMode) {
                    this.drawPoint(1, 3);
                    this.drawPoint(9, 0);
                    this.drawPoint(15, 5);
                    this.drawPoint(10, 11);
                    this.drawPoint(2, 13);
                } else {
                    this.m(1, 8);
                    this.d(6, 8);
                    this.d(6, 6);
                    this.d(10, 6);
                    this.d(10, 10);
                    this.d(6, 10);
                    this.d(6, 9);
                    this.m(8, 1);
                    this.d(8, 5);
                    this.m(11, 8);
                    this.d(15, 8);
                    this.m(8, 11);
                    this.d(8, 15);
                    this.m(8, 8);
                    this.d(8, 8);
                    g.setColor(Roi.getColor());
                    this.m(7, 7);
                    this.d(9, 7);
                    this.m(7, 8);
                    this.d(9, 8);
                    this.m(7, 9);
                    this.d(9, 9);
                }
                this.drawTriangle(16, 16);
                return;
            }
            case 8: {
                this.xOffset = x + 2;
                this.yOffset = y + 1;
                this.dot(4, 0);
                this.m(2, 0);
                this.d(3, 1);
                this.d(4, 2);
                this.m(0, 0);
                this.d(1, 1);
                this.m(0, 2);
                this.d(1, 3);
                this.d(2, 4);
                this.dot(0, 4);
                this.m(3, 3);
                this.d(15, 15);
                g.setColor(Roi.getColor());
                this.m(1, 2);
                this.d(3, 2);
                this.m(2, 1);
                this.d(2, 3);
                return;
            }
            case 9: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(1, 16);
                this.d(9, 0);
                this.d(16, 16);
                this.m(0, 16);
                this.d(2, 16);
                this.m(15, 16);
                this.d(17, 16);
                this.m(4, 10);
                this.d(13, 10);
                return;
            }
            case 11: {
                this.xOffset = x;
                this.yOffset = y;
                g.drawOval(x + 3, y, 13 * scale, 13 * scale);
                this.m(5, 12);
                this.d(-1, 18);
                this.drawTriangle(15, 17);
                return;
            }
            case 12: {
                this.xOffset = x;
                this.yOffset = y;
                this.polyline(5, 17, 5, 16, 0, 11, 0, 8, 1, 8, 5, 11, 5, 2, 8, 2, 8, 8, 8, 0, 11, 0, 11, 8, 11, 1, 14, 1, 14, 9, 14, 3, 17, 3, 17, 12, 16, 13, 16, 17);
                return;
            }
            case 13: {
                g.setColor(backgroundColor);
                g.fillRect(x + 2 * scale, y + 3 * scale, 15 * scale, 16 * scale);
                g.drawRect(x, y + 2 * scale, 13 * scale, 13 * scale);
                g.setColor(foregroundColor);
                g.fillRect(x, y + 2 * scale, 13 * scale, 13 * scale);
                this.xOffset = x + 3;
                this.yOffset = y - 4;
                g.setColor(this.toolColor);
                this.m(12, 2);
                this.d(14, 2);
                this.m(11, 3);
                this.d(15, 3);
                this.m(11, 4);
                this.d(15, 4);
                this.m(8, 5);
                this.d(15, 5);
                this.m(9, 6);
                this.d(14, 6);
                this.polyline(10, 7, 12, 7, 12, 9);
                this.polyline(9, 6, 2, 13, 2, 15, 4, 15, 11, 8);
                g.setColor(this.gray);
                this.polygon(9, 6, 2, 13, 2, 15, 4, 15, 11, 8);
                this.drawTriangle(12, 21);
                return;
            }
            case 14: {
                this.xOffset = x;
                this.yOffset = y + 3;
                this.m(0, 11);
                this.d(13, -1);
                this.m(0, 11);
                this.d(16, 11);
                this.m(10, 11);
                this.d(10, 8);
                this.m(9, 7);
                this.d(9, 6);
                this.dot(8, 5);
                this.drawDot(13, -2);
                this.drawDot(16, 10);
                return;
            }
        }
    }

    void drawTriangle(int x, int y) {
        this.g.setColor(this.triangleColor);
        this.xOffset += x * scale;
        this.yOffset += y * scale;
        this.m(0, 0);
        this.d(4, 0);
        this.m(1, 1);
        this.d(3, 1);
        this.m(2, 2);
        this.d(2, 2);
    }

    void drawDot(int x, int y) {
        this.g.fillRect(this.xOffset + x * scale, this.yOffset + y * scale, 2 * scale, 2 * scale);
    }

    void drawPoint(int x, int y) {
        this.g.setColor(this.toolColor);
        this.m(x - 3, y);
        this.d(x + 3, y);
        this.m(x, y - 3);
        this.d(x, y + 3);
        this.g.setColor(Roi.getColor());
        this.dot(x, y);
        this.dot(x - 1, y - 1);
    }

    void drawIcon(Graphics g, int tool, int x, int y) {
        block29: {
            if (null == g) {
                return;
            }
            this.icon = this.icons[tool];
            if (this.icon == null) {
                return;
            }
            this.pc = 0;
            if (this.icon.trim().startsWith("icon:")) {
                String path = IJ.getDir("macros") + "toolsets/icons/" + this.icon.substring(this.icon.indexOf(":") + 1);
                try {
                    BufferedImage bi = ImageIO.read(new File(path));
                    if (scale == 1) {
                        g.drawImage(bi, x - 5, y - 5, null);
                        break block29;
                    }
                    int size = Math.max(bi.getWidth(), bi.getHeight());
                    g.drawImage(bi, x - 5 * scale, y - 5 * scale, size * scale, size * scale, null);
                }
                catch (Exception e) {
                    IJ.error("Toolbar", "Error reading tool icon:\n" + path);
                }
            } else {
                do {
                    char command = this.icon.charAt(this.pc++);
                    if (this.pc >= this.icon.length()) break;
                    switch (command) {
                        case 'B': {
                            x += this.v();
                            y += this.v();
                            break;
                        }
                        case 'N': {
                            x -= this.v();
                            y -= this.v();
                            break;
                        }
                        case 'R': {
                            g.drawRect(x + this.v(), y + this.v(), this.v(), this.v());
                            break;
                        }
                        case 'F': {
                            g.fillRect(x + this.v(), y + this.v(), this.v(), this.v());
                            break;
                        }
                        case 'O': {
                            g.drawOval(x + this.v(), y + this.v(), this.v(), this.v());
                            break;
                        }
                        case 'V': 
                        case 'o': {
                            g.fillOval(x + this.v(), y + this.v(), this.v(), this.v());
                            break;
                        }
                        case 'C': {
                            int saveScale = scale;
                            scale = 1;
                            int v1 = this.v();
                            int v2 = this.v();
                            int v3 = this.v();
                            int red = v1 * 16;
                            int green = v2 * 16;
                            int blue = v3 * 16;
                            if (red > 255) {
                                red = 255;
                            }
                            if (green > 255) {
                                green = 255;
                            }
                            if (blue > 255) {
                                blue = 255;
                            }
                            Color color = v1 == 1 && v2 == 2 && v3 == 3 ? foregroundColor : new Color(red, green, blue);
                            g.setColor(color);
                            scale = saveScale;
                            break;
                        }
                        case 'L': {
                            g.drawLine(x + this.v(), y + this.v(), x + this.v(), y + this.v());
                            break;
                        }
                        case 'D': {
                            g.fillRect(x + this.v(), y + this.v(), scale, scale);
                            break;
                        }
                        case 'P': {
                            int y2;
                            int x2;
                            Polygon p = new Polygon();
                            p.addPoint(x + this.v(), y + this.v());
                            while ((x2 = this.v()) != 0 && (y2 = this.v()) != 0) {
                                p.addPoint(x + x2, y + y2);
                            }
                            g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
                            break;
                        }
                        case 'G': 
                        case 'H': {
                            int y2;
                            int x2;
                            Polygon p = new Polygon();
                            p.addPoint(x + this.v(), y + this.v());
                            while (true) {
                                x2 = this.v();
                                y2 = this.v();
                                if (x2 == 0 && y2 == 0 && p.npoints > 2) break;
                                p.addPoint(x + x2, y + y2);
                            }
                            if (command == 'G') {
                                g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
                                break;
                            }
                            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
                            break;
                        }
                        case 'T': {
                            int x2 = x + this.v() - 2;
                            int y2 = y + this.v();
                            int size = this.v() * 10 + this.v() + 1;
                            char[] c = new char[]{this.pc < this.icon.length() ? (char)this.icon.charAt(this.pc++) : (char)'e'};
                            g.setFont(new Font("SansSerif", 0, size));
                            g.drawString(new String(c), x2, y2);
                            break;
                        }
                    }
                } while (this.pc < this.icon.length());
            }
        }
        if (this.menus[tool] != null && this.menus[tool].getItemCount() > 0) {
            this.xOffset = x;
            this.yOffset = y;
            this.drawTriangle(15, 16);
        }
    }

    int v() {
        if (this.pc >= this.icon.length()) {
            return 0;
        }
        char c = this.icon.charAt(this.pc++);
        switch (c) {
            case '0': {
                return 0 * scale;
            }
            case '1': {
                return 1 * scale;
            }
            case '2': {
                return 2 * scale;
            }
            case '3': {
                return 3 * scale;
            }
            case '4': {
                return 4 * scale;
            }
            case '5': {
                return 5 * scale;
            }
            case '6': {
                return 6 * scale;
            }
            case '7': {
                return 7 * scale;
            }
            case '8': {
                return 8 * scale;
            }
            case '9': {
                return 9 * scale;
            }
            case 'a': {
                return 10 * scale;
            }
            case 'b': {
                return 11 * scale;
            }
            case 'c': {
                return 12 * scale;
            }
            case 'd': {
                return 13 * scale;
            }
            case 'e': {
                return 14 * scale;
            }
            case 'f': {
                return 15 * scale;
            }
            case 'g': {
                return 16 * scale;
            }
            case 'h': {
                return 17 * scale;
            }
            case 'i': {
                return 18 * scale;
            }
            case 'j': {
                return 19 * scale;
            }
            case 'k': {
                return 20 * scale;
            }
            case 'l': {
                return 21 * scale;
            }
            case 'm': {
                return 22 * scale;
            }
            case 'n': {
                return 23 * scale;
            }
        }
        return 0;
    }

    private void showMessage(int tool) {
        if (IJ.statusBarProtected()) {
            return;
        }
        if (tool >= 10 && tool < this.getNumTools() && this.names[tool] != null) {
            String name = this.names[tool];
            int index = name.indexOf("Action Tool");
            if (index != -1) {
                name = name.replace("Action Tool", "Tool");
            } else {
                index = name.indexOf("Menu Tool");
                if (index != -1) {
                    name = name.substring(0, index + 4);
                }
            }
            IJ.showStatus(name);
            return;
        }
        String hint = " (alt or long click to switch)";
        String hint2 = " (alt or long click to switch; double click to configure)";
        switch (tool) {
            case 0: {
                if (rectType == 1) {
                    IJ.showStatus("Rectangle, *rounded rect* or rotated rect" + hint);
                } else if (rectType == 2) {
                    IJ.showStatus("Rectangle, rounded rect or *rotated rect*" + hint);
                } else {
                    IJ.showStatus("*Rectangle*, rounded rect or rotated rect" + hint);
                }
                return;
            }
            case 1: {
                if (ovalType == 2) {
                    IJ.showStatus("Oval, elliptical or *brush* selections" + hint);
                } else if (ovalType == 1) {
                    IJ.showStatus("Oval, *elliptical* or brush selections" + hint);
                } else {
                    IJ.showStatus("*Oval*, elliptical or brush selections" + hint);
                }
                return;
            }
            case 2: {
                IJ.showStatus("Polygon selections");
                return;
            }
            case 3: {
                IJ.showStatus("Freehand selections");
                return;
            }
            case 4: {
                if (arrowMode) {
                    IJ.showStatus("Straight, segmented or freehand lines, or *arrows*" + hint);
                } else {
                    IJ.showStatus("*Straight*, segmented or freehand lines, or arrows" + hint);
                }
                return;
            }
            case 5: {
                IJ.showStatus("Straight, *segmented* or freehand lines, or arrows" + hint);
                return;
            }
            case 6: {
                IJ.showStatus("Straight, segmented or *freehand* lines, or arrows" + hint);
                return;
            }
            case 7: {
                if (multiPointMode) {
                    IJ.showStatus("*Multi-point* or point" + hint2);
                } else {
                    IJ.showStatus("*Point* or multi-point" + hint2);
                }
                return;
            }
            case 8: {
                IJ.showStatus("Wand (tracing) tool");
                return;
            }
            case 9: {
                IJ.showStatus("Text tool (double-click to configure)");
                return;
            }
            case 11: {
                IJ.showStatus("Magnifying glass (or \"+\" and \"-\" keys; alt or long click for menu)");
                return;
            }
            case 12: {
                IJ.showStatus("Scrolling tool (or press space bar and drag)");
                return;
            }
            case 13: {
                String fg = foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue();
                String bg = backgroundColor.getRed() + "," + backgroundColor.getGreen() + "," + backgroundColor.getBlue();
                IJ.showStatus("Color picker " + fg + "/" + bg + " (alt or long click for menu)");
                return;
            }
            case 14: {
                IJ.showStatus("Angle tool");
                return;
            }
        }
        IJ.showStatus("ImageJ " + IJ.getVersion() + " / Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " (64-bit)" : " (32-bit)"));
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x * scale;
        this.y = this.yOffset + y * scale;
    }

    private void d(int x, int y) {
        x *= scale;
        y *= scale;
        this.g.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void dot(int x, int y) {
        this.g.fillRect(this.xOffset + x * scale, this.yOffset + y * scale, 1 * scale, 1 * scale);
    }

    private void polyline(int ... values) {
        Polygon p = new Polygon();
        int n = values.length / 2;
        for (int i = 0; i < n; ++i) {
            p.addPoint(values[i * 2] * scale + this.xOffset, values[i * 2 + 1] * scale + this.yOffset);
        }
        this.g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
    }

    private void polygon(int ... values) {
        Polygon p = new Polygon();
        int n = values.length / 2;
        for (int i = 0; i < n; ++i) {
            p.addPoint(values[i * 2] * scale + this.xOffset, values[i * 2 + 1] * scale + this.yOffset);
        }
        this.g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    private void resetButtons() {
        for (int i = 0; i < this.getNumTools(); ++i) {
            this.down[i] = false;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.drawButtons(g);
    }

    public boolean setTool(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(" Tool") != -1) {
            for (int i = 10; i < this.getNumTools(); ++i) {
                if (!name.equals(this.names[i])) continue;
                this.setTool(i);
                return true;
            }
        }
        name = name.toLowerCase(Locale.US);
        boolean ok = true;
        if (name.indexOf("round") != -1) {
            rectType = 1;
            this.setTool(0);
        } else if (name.indexOf("rot") != -1) {
            rectType = 2;
            this.setTool(0);
        } else if (name.indexOf("rect") != -1) {
            rectType = 0;
            this.setTool(0);
        } else if (name.indexOf("oval") != -1) {
            ovalType = 0;
            this.setTool(1);
        } else if (name.indexOf("ellip") != -1) {
            ovalType = 1;
            this.setTool(1);
        } else if (name.indexOf("brush") != -1) {
            ovalType = 2;
            this.setTool(1);
        } else if (name.indexOf("polygon") != -1) {
            this.setTool(2);
        } else if (name.indexOf("polyline") != -1) {
            this.setTool(5);
        } else if (name.indexOf("freeline") != -1) {
            this.setTool(6);
        } else if (name.indexOf("line") != -1) {
            arrowMode = false;
            this.setTool(4);
        } else if (name.indexOf("arrow") != -1) {
            arrowMode = true;
            this.setTool(4);
        } else if (name.indexOf("free") != -1) {
            this.setTool(3);
        } else if (name.indexOf("multi") != -1) {
            multiPointMode = true;
            Prefs.multiPointMode = true;
            this.setTool(7);
        } else if (name.indexOf("point") != -1) {
            multiPointMode = false;
            Prefs.multiPointMode = false;
            this.setTool(7);
        } else if (name.indexOf("wand") != -1) {
            this.setTool(8);
        } else if (name.indexOf("text") != -1) {
            this.setTool(9);
        } else if (name.indexOf("hand") != -1) {
            this.setTool(12);
        } else if (name.indexOf("zoom") != -1) {
            this.setTool(11);
        } else if (name.indexOf("dropper") != -1 || name.indexOf("color") != -1) {
            this.setTool(13);
        } else if (name.indexOf("angle") != -1) {
            this.setTool(14);
        } else {
            ok = false;
        }
        return ok;
    }

    public static String getToolName() {
        String name = instance.getName(current);
        if (current >= 10 && current < instance.getNumTools() && Toolbar.instance.names[current] != null) {
            name = Toolbar.instance.names[current];
        }
        return name != null ? name : "";
    }

    String getName(int id) {
        switch (id) {
            case 0: {
                switch (rectType) {
                    case 0: {
                        return "rectangle";
                    }
                    case 1: {
                        return "roundrect";
                    }
                    case 2: {
                        return "rotrect";
                    }
                }
            }
            case 1: {
                switch (ovalType) {
                    case 0: {
                        return "oval";
                    }
                    case 1: {
                        return "ellipse";
                    }
                    case 2: {
                        return "brush";
                    }
                }
            }
            case 2: {
                return "polygon";
            }
            case 3: {
                return "freehand";
            }
            case 4: {
                return arrowMode ? "arrow" : "line";
            }
            case 5: {
                return "polyline";
            }
            case 6: {
                return "freeline";
            }
            case 14: {
                return "angle";
            }
            case 7: {
                return Prefs.multiPointMode ? "multipoint" : "point";
            }
            case 8: {
                return "wand";
            }
            case 9: {
                return "text";
            }
            case 12: {
                return "hand";
            }
            case 11: {
                return "zoom";
            }
            case 13: {
                return "dropper";
            }
        }
        return null;
    }

    public void setTool(int tool) {
        if (tool == 10) {
            tool = 15;
        } else if (legacyMode && tool >= 15) {
            ++tool;
        }
        if (IJ.debugMode) {
            IJ.log("Toolbar.setTool: " + tool);
        }
        if (tool == current && tool != 0 && tool != 1 && tool != 7 || tool < 0 || tool >= this.getNumTools() - 1) {
            return;
        }
        if (tool >= 15 && tool <= this.getNumTools() - 2) {
            if (this.names[tool] == null) {
                this.names[tool] = "Spare tool";
            }
            if (this.names[tool].indexOf("Action Tool") != -1) {
                return;
            }
        }
        if (this.isLine(tool)) {
            this.lineType = tool;
        }
        this.setTool2(tool);
    }

    private void setTool2(int tool) {
        if (!this.isValidTool(tool)) {
            return;
        }
        String previousName = Toolbar.getToolName();
        this.previousTool = current;
        current = tool;
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        this.down[Toolbar.current] = true;
        if (current != this.previousTool) {
            this.down[this.previousTool] = false;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setStrokeWidth(g2d);
        this.drawButton(g, this.previousTool);
        this.drawButton(g, current);
        if (null == g) {
            return;
        }
        g.dispose();
        this.showMessage(current);
        if (IJ.recording()) {
            String name = this.getName(current);
            if (name != null && name.equals("dropper")) {
                this.disableRecording = true;
            }
            if (name != null && !this.disableRecording) {
                IJ.wait(100);
                Recorder.record("setTool", name);
            }
            if (name != null && !name.equals("dropper")) {
                this.disableRecording = false;
            }
        }
        if (legacyMode) {
            this.repaint();
        }
        if (!previousName.equals(Toolbar.getToolName())) {
            IJ.notifyEventListeners(4);
            this.repaint();
        }
    }

    boolean isValidTool(int tool) {
        if (tool < 0 || tool >= this.getNumTools()) {
            return false;
        }
        return tool < 15 || tool >= this.getNumTools() || this.names[tool] != null;
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color c) {
        if (c != null) {
            foregroundColor = c;
            this.drawButton(this.getGraphics(), 13);
        }
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color c) {
        ImagePlus imp;
        if (c == null) {
            return;
        }
        foregroundColor = c;
        foregroundValue = Double.NaN;
        IJ.notifyEventListeners(0);
        if (instance == null) {
            return;
        }
        Toolbar.repaintTool(13);
        for (int i = 15; i <= instance.getNumTools() - 2; ++i) {
            if (Toolbar.instance.icons[i] == null || !Toolbar.instance.icons[i].contains("C123")) continue;
            Toolbar.repaintTool(i);
        }
        ColorPicker.update();
        if (!IJ.isMacro()) {
            Toolbar.setRoiColor(c);
        }
        if ((imp = WindowManager.getCurrentImage()) != null) {
            imp.getProcessor().fillColorSet(false);
        }
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color c) {
        if (c != null) {
            backgroundColor = c;
            backgroundValue = Double.NaN;
            Toolbar.repaintTool(13);
            ColorPicker.update();
            IJ.notifyEventListeners(1);
        }
    }

    public static double getForegroundValue() {
        return foregroundValue;
    }

    public static void setForegroundValue(double value) {
        if (value >= 0.0) {
            int v = (int)value;
            if (v > 255) {
                v = 255;
            }
            Toolbar.setForegroundColor(new Color(v, v, v));
        }
        foregroundValue = value;
    }

    public static double getBackgroundValue() {
        return backgroundValue;
    }

    public static void setBackgroundValue(double value) {
        if (value >= 0.0) {
            int v = (int)value;
            if (v > 255) {
                v = 255;
            }
            Toolbar.setBackgroundColor(new Color(v, v, v));
        }
        backgroundValue = value;
    }

    private static void setRoiColor(Color c) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi != null && roi.isDrawingTool()) {
            roi.setStrokeColor(c);
            imp.draw();
        }
    }

    public static int getBrushSize() {
        if (ovalType == 2) {
            return brushSize;
        }
        return 0;
    }

    public static void setBrushSize(int size) {
        brushSize = size;
        if (brushSize < 1) {
            brushSize = 1;
        }
        Prefs.set(BRUSH_SIZE, brushSize);
    }

    public static int getRoundRectArcSize() {
        if (rectType == 1) {
            return arcSize;
        }
        return 0;
    }

    public static void setRoundRectArcSize(int size) {
        Roi roi;
        if (size <= 0) {
            rectType = 0;
        } else {
            arcSize = size;
            Prefs.set(CORNER_DIAMETER, arcSize);
        }
        Toolbar.repaintTool(0);
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi2 = roi = imp != null ? imp.getRoi() : null;
        if (roi != null && roi.getType() == 0) {
            roi.setCornerDiameter(rectType == 1 ? arcSize : 0);
        }
    }

    public static boolean getMultiPointMode() {
        return multiPointMode;
    }

    public static int getRectToolType() {
        return rectType;
    }

    public static int getOvalToolType() {
        return ovalType;
    }

    public static int getButtonSize() {
        return buttonWidth;
    }

    public static void repaintTool(int tool) {
        Toolbar tb = Toolbar.getInstance();
        if (tb != null) {
            Graphics g = tb.getGraphics();
            if (IJ.debugMode) {
                IJ.log("Toolbar.repaintTool: " + tool + " " + g);
            }
            if (g == null) {
                return;
            }
            if (dscale > 1.0) {
                tb.setStrokeWidth((Graphics2D)g);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            tb.drawButton(g, tool);
            if (g != null) {
                g.dispose();
            }
        }
    }

    int toolIndex(int tool) {
        switch (tool) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 5;
            }
            case 10: {
                return 12;
            }
        }
        return tool - 2;
    }

    private int toolID(int x) {
        if (x > buttonWidth * 12 + gapSize) {
            x -= gapSize;
        }
        int index = x / buttonWidth;
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return this.lineType;
            }
            case 5: {
                return 14;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 11;
            }
            case 10: {
                return 12;
            }
            case 11: {
                return 13;
            }
        }
        return index + 3;
    }

    private boolean inGap(int x) {
        return x >= buttonWidth * 12 && x < buttonWidth * 12 + gapSize;
    }

    public void triggerPopupMenu(int newTool, MouseEvent e, boolean isRightClick, boolean isLongPress) {
        this.mpPrevious = current;
        if (this.isMacroTool(newTool)) {
            String name = this.names[newTool];
            if (newTool == 10 || name.contains("Unused Tool")) {
                return;
            }
            if (name.indexOf("Action Tool") != -1) {
                if (e.isPopupTrigger() || e.isMetaDown()) {
                    name = name.endsWith(" ") ? name : name + " ";
                    this.tools[newTool].runMacroTool(name + "Options");
                } else {
                    this.drawTool(newTool, false);
                    this.runMacroTool(newTool);
                }
                return;
            }
            name = name.endsWith(" ") ? name : name + " ";
            this.tools[newTool].runMacroTool(name + "Selected");
        }
        if (!isLongPress) {
            this.setTool2(newTool);
        }
        int x = e.getX();
        int y = e.getY();
        if (current == 0 && isRightClick) {
            this.rectItem.setState(rectType == 0);
            this.roundRectItem.setState(rectType == 1);
            this.rotatedRectItem.setState(rectType == 2);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            this.rectPopup.show(e.getComponent(), x, y);
            this.mouseDownTime = 0L;
        }
        if (current == 1 && isRightClick) {
            this.ovalItem.setState(ovalType == 0);
            this.ellipseItem.setState(ovalType == 1);
            this.brushItem.setState(ovalType == 2);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            this.ovalPopup.show(e.getComponent(), x, y);
            this.mouseDownTime = 0L;
        }
        if (current == 7 && isRightClick) {
            this.pointItem.setState(!multiPointMode);
            this.multiPointItem.setState(multiPointMode);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            this.pointPopup.show(e.getComponent(), x, y);
            this.mouseDownTime = 0L;
        }
        if (this.isLine(current) && isRightClick) {
            this.straightLineItem.setState(this.lineType == 4 && !arrowMode);
            this.polyLineItem.setState(this.lineType == 5);
            this.freeLineItem.setState(this.lineType == 6);
            this.arrowItem.setState(this.lineType == 4 && arrowMode);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            this.linePopup.show(e.getComponent(), x, y);
            this.mouseDownTime = 0L;
        }
        if (current == 11 && isRightClick) {
            this.zoomPopup.show(e.getComponent(), x, y);
            this.mouseDownTime = 0L;
        }
        if (current == 13 && isRightClick) {
            this.pickerPopup.show(e.getComponent(), x, y);
            this.mouseDownTime = 0L;
        }
        if (this.isMacroTool(current) && isRightClick) {
            String name = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
            this.tools[current].runMacroTool(name + "Options");
        }
        if (this.isPlugInTool(current) && isRightClick) {
            this.tools[current].showPopupMenu(e, this);
        }
    }

    @Override
    public void mousePressed(final MouseEvent e) {
        boolean disablePopup = false;
        int x = e.getX();
        if (this.inGap(x)) {
            return;
        }
        final int newTool = this.toolID(x);
        if (newTool == this.getNumTools() - 1) {
            this.showSwitchPopupMenu(e);
            return;
        }
        if (!this.isValidTool(newTool)) {
            return;
        }
        if (this.menus[newTool] != null && this.menus[newTool].getItemCount() > 0) {
            this.menus[newTool].show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        int flags = e.getModifiers();
        boolean isRightClick = e.isPopupTrigger() || !IJ.isMacintosh() && (flags & 4) != 0;
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick || isRightClick) {
            this.triggerPopupMenu(newTool, e, isRightClick, false);
            if (isRightClick) {
                this.mouseDownTime = 0L;
            }
        } else if (!isRightClick) {
            if (this.isMacroTool(current)) {
                String name = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.tools[current].runMacroTool(name + "Options");
                return;
            }
            if (this.isPlugInTool(current)) {
                this.tools[current].showOptionsDialog();
                return;
            }
            ImagePlus imp = WindowManager.getCurrentImage();
            switch (current) {
                case 0: {
                    if (rectType == 1) {
                        IJ.doCommand("Rounded Rect Tool...");
                        break;
                    }
                    disablePopup = true;
                    IJ.doCommand("Roi Defaults...");
                    break;
                }
                case 1: {
                    this.showBrushDialog();
                    break;
                }
                case 11: {
                    ImageCanvas ic;
                    if (imp == null || (ic = imp.getCanvas()) == null) break;
                    ic.unzoom();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (current == 4 && arrowMode) {
                        IJ.doCommand("Arrow Tool...");
                        break;
                    }
                    IJ.runPlugIn("ij.plugin.frame.LineWidthAdjuster", "");
                    break;
                }
                case 14: {
                    this.showAngleDialog();
                    break;
                }
                case 7: {
                    IJ.doCommand("Point Tool...");
                    break;
                }
                case 8: {
                    IJ.doCommand("Wand Tool...");
                    break;
                }
                case 9: {
                    IJ.run("Fonts...");
                    break;
                }
                case 13: {
                    IJ.doCommand("Color Picker...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
            }
        }
        if (!isRightClick && longClickDelay > 0 && !disablePopup) {
            if (this.pressTimer == null) {
                this.pressTimer = new Timer();
            }
            this.pressTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Toolbar.this.pressTimer != null) {
                        Toolbar.this.pressTimer.cancel();
                        Toolbar.this.pressTimer = null;
                    }
                    Toolbar.this.triggerPopupMenu(newTool, e, true, true);
                }
            }, longClickDelay);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pressTimer != null) {
            this.pressTimer.cancel();
            this.pressTimer = null;
        }
    }

    void showSwitchPopupMenu(MouseEvent e) {
        Object[] list;
        String path = IJ.getDir("macros") + "toolsets/";
        if (path == null) {
            return;
        }
        boolean applet = IJ.getApplet() != null;
        File f = new File(path);
        if (!applet && f.exists() && f.isDirectory()) {
            list = f.list();
            if (list == null) {
                return;
            }
            Arrays.sort(list);
        } else {
            list = new String[]{};
        }
        this.switchPopup.removeAll();
        path = IJ.getDir("macros") + "StartupMacros.txt";
        f = new File(path);
        if (!f.exists()) {
            path = IJ.getDir("macros") + "StartupMacros.ijm";
            f = new File(path);
        }
        if (!applet && f.exists()) {
            this.addItem("Startup Macros");
        } else {
            this.addItem("StartupMacros*");
        }
        for (int i = 0; i < list.length; ++i) {
            Object name = list[i];
            if (((String)name).startsWith(".") || ((String)name).endsWith(" Tool")) continue;
            if (((String)name).endsWith(".txt")) {
                name = ((String)name).substring(0, ((String)name).length() - 4);
                this.addItem((String)name);
                continue;
            }
            if (!((String)name).endsWith(".ijm")) continue;
            name = ((String)name).substring(0, ((String)name).length() - 4) + " ";
            this.addItem((String)name);
        }
        this.addItem("Overlay Editing Tools*");
        this.addPluginTools();
        this.addItem("Restore Startup Tools");
        this.addItem("Remove Custom Tools");
        this.addItem("Help...");
        this.add(this.ovalPopup);
        if (IJ.isMacOSX()) {
            IJ.wait(10);
        }
        this.switchPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void addPluginTools() {
        this.switchPopup.addSeparator();
        for (int i = 0; i < builtInTools.length; ++i) {
            this.addBuiltInTool(builtInTools[i]);
        }
        MenuBar menuBar = Menus.getMenuBar();
        if (menuBar == null) {
            return;
        }
        int n = menuBar.getMenuCount();
        Menu pluginsMenu = null;
        if (menuBar.getMenuCount() >= 5) {
            pluginsMenu = menuBar.getMenu(5);
        }
        if (pluginsMenu == null || !"Plugins".equals(pluginsMenu.getLabel())) {
            return;
        }
        n = pluginsMenu.getItemCount();
        Menu toolsMenu = null;
        for (int i = 0; i < n; ++i) {
            MenuItem m = pluginsMenu.getItem(i);
            if (!"Tools".equals(m.getLabel()) || !(m instanceof Menu)) continue;
            toolsMenu = (Menu)m;
            break;
        }
        if (toolsMenu == null) {
            this.switchPopup.addSeparator();
            return;
        }
        n = toolsMenu.getItemCount();
        boolean separatorAdded = false;
        for (int i = 0; i < n; ++i) {
            MenuItem m = toolsMenu.getItem(i);
            String label = m.getLabel();
            if (label == null || !label.endsWith(" Tool") && !label.endsWith(" Menu")) continue;
            if (!separatorAdded) {
                this.switchPopup.addSeparator();
                separatorAdded = true;
            }
            this.addPluginTool(label);
        }
        this.switchPopup.addSeparator();
    }

    private void addBuiltInTool(String name) {
        CheckboxMenuItem item = new CheckboxMenuItem(name, name.equals(this.currentSet));
        item.addItemListener(this);
        item.setActionCommand("Tool");
        this.switchPopup.add(item);
    }

    private void addPluginTool(String name) {
        CheckboxMenuItem item = new CheckboxMenuItem(name, name.equals(this.currentSet));
        item.addItemListener(this);
        item.setActionCommand("Plugin Tool");
        this.switchPopup.add(item);
    }

    private void addItem(String name) {
        CheckboxMenuItem item = new CheckboxMenuItem(name, name.equals(this.currentSet));
        item.addItemListener(this);
        this.switchPopup.add(item);
    }

    void drawTool(int tool, boolean drawDown) {
        this.down[tool] = drawDown;
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        if (!drawDown) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(g, tool);
        if (null != g) {
            g.dispose();
        }
    }

    boolean isLine(int tool) {
        return tool == 4 || tool == 5 || tool == 6;
    }

    public void restorePreviousTool() {
        this.setTool2(this.mpPrevious);
    }

    boolean isMacroTool(int tool) {
        return tool >= 15 && tool < this.getNumTools() && this.names[tool] != null && this.tools[tool] instanceof MacroToolRunner;
    }

    boolean isPlugInTool(int tool) {
        return tool >= 15 && tool < this.getNumTools() && this.tools[tool] != null;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        String previousName = Toolbar.getToolName();
        if (item == this.rectItem || item == this.roundRectItem || item == this.rotatedRectItem) {
            Roi roi;
            rectType = item == this.roundRectItem ? 1 : (item == this.rotatedRectItem ? 2 : 0);
            Toolbar.repaintTool(0);
            this.showMessage(0);
            ImagePlus imp = WindowManager.getCurrentImage();
            Roi roi2 = roi = imp != null ? imp.getRoi() : null;
            if (roi != null && roi.getType() == 0) {
                roi.setCornerDiameter(rectType == 1 ? arcSize : 0);
            }
            if (!previousName.equals(Toolbar.getToolName())) {
                IJ.notifyEventListeners(4);
            }
        } else if (item == this.ovalItem || item == this.ellipseItem || item == this.brushItem) {
            ovalType = item == this.brushItem ? 2 : (item == this.ellipseItem ? 1 : 0);
            Toolbar.repaintTool(1);
            this.showMessage(1);
            if (!previousName.equals(Toolbar.getToolName())) {
                IJ.notifyEventListeners(4);
            }
        } else if (item == this.pointItem || item == this.multiPointItem) {
            Prefs.multiPointMode = multiPointMode = item == this.multiPointItem;
            Toolbar.repaintTool(7);
            this.showMessage(7);
            if (!previousName.equals(Toolbar.getToolName())) {
                IJ.notifyEventListeners(4);
            }
        } else if (item == this.straightLineItem) {
            this.lineType = 4;
            arrowMode = false;
            this.setTool2(4);
            this.showMessage(4);
        } else if (item == this.polyLineItem) {
            this.lineType = 5;
            this.setTool2(5);
            this.showMessage(5);
        } else if (item == this.freeLineItem) {
            this.lineType = 6;
            this.setTool2(6);
            this.showMessage(6);
        } else if (item == this.arrowItem) {
            this.lineType = 4;
            arrowMode = true;
            this.setTool2(4);
            this.showMessage(4);
        } else {
            boolean isTool;
            String label = item.getLabel();
            String cmd = item.getActionCommand();
            boolean bl = isTool = cmd.equals("Tool") || cmd.equals("Plugin Tool");
            if (!(label.equals("Help...") || label.equals("Remove Custom Tools") || isTool || label.endsWith("Tool") || label.endsWith("Tool "))) {
                this.currentSet = label;
            }
            if (isTool) {
                if (cmd.equals("Tool")) {
                    this.installBuiltinTool(label);
                } else {
                    IJ.run(label);
                }
                return;
            }
            if (label.equals("Remove Custom Tools")) {
                this.removeTools();
            } else if (label.equals("Restore Startup Tools")) {
                this.removeTools();
                this.installStartupMacros();
            } else {
                if (label.equals("Help...")) {
                    IJ.showMessage("Tool Switcher and Loader", "Use this drop down menu to switch to alternative\nmacro toolsets or to load additional plugin tools.\nThe toolsets listed in the menu are located\nin the ImageJ/macros/toolsets folder and the\nplugin tools are the ones installed in the\nPlugins>Tools submenu.\n \nHold the shift key down while selecting a\ntoolset to view its source code.\n \nMore macro toolsets are available at\n  <http://imagej.net/ij/macros/toolsets/>\n \nPlugin tools can be downloaded from\nthe Tools section of the Plugins page at\n  <http://imagej.net/ij/plugins/>\n");
                    return;
                }
                if (label.endsWith("*")) {
                    MacroInstaller mi = new MacroInstaller();
                    label = label.substring(0, label.length() - 1) + ".txt";
                    String path = "/macros/" + label;
                    if (IJ.shiftKeyDown()) {
                        Toolbar.showCode(label, mi.openFromIJJar(path));
                    } else {
                        this.resetTools();
                        mi.installFromIJJar(path);
                    }
                } else {
                    if (label.equals("Startup Macros")) {
                        this.installStartupMacros();
                        return;
                    }
                    String path = label.endsWith(" ") ? IJ.getDir("macros") + "toolsets" + File.separator + label.substring(0, label.length() - 1) + ".ijm" : IJ.getDir("macros") + "toolsets" + File.separator + label + ".txt";
                    try {
                        if (IJ.shiftKeyDown()) {
                            IJ.open(path);
                            IJ.setKeyUp(16);
                        } else {
                            new MacroInstaller().run(path);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void removeTools() {
        Toolbar.removeMacroTools();
        this.setTool(0);
        this.currentSet = "Startup Macros";
        this.resetPrefs();
        if (this.nExtraTools > 0) {
            String name = this.names[this.getNumTools() - 1];
            String icon = this.icons[this.getNumTools() - 1];
            this.nExtraTools = 0;
            this.names[this.getNumTools() - 1] = name;
            this.icons[this.getNumTools() - 1] = icon;
            this.ps = new Dimension(buttonWidth * 21 - (30 - gapSize) + this.nExtraTools * 30, buttonHeight);
            IJ.getInstance().pack();
        }
    }

    private void resetPrefs() {
        for (int i = 0; i < 7; ++i) {
            String key = TOOL_KEY + i / 10 % 10 + i % 10;
            if (Prefs.get(key, "").equals("")) continue;
            Prefs.set(key, "");
        }
    }

    public static void restoreTools() {
        Toolbar tb = Toolbar.getInstance();
        if (tb != null) {
            if (tb.getToolId() >= 10) {
                tb.setTool(0);
            }
            tb.installStartupMacros();
        }
    }

    private void installStartupMacros() {
        this.resetTools();
        String path = IJ.getDir("macros") + "StartupMacros.txt";
        File f = new File(path);
        if (!f.exists()) {
            path = IJ.getDir("macros") + "StartupMacros.ijm";
            f = new File(path);
        }
        if (!f.exists()) {
            path = IJ.getDir("macros") + "StartupMacros.fiji.ijm";
            f = new File(path);
        }
        if (!f.exists()) {
            IJ.error("StartupMacros not found in\n \n" + IJ.getDir("macros"));
            return;
        }
        if (IJ.shiftKeyDown()) {
            IJ.open(path);
            IJ.setKeyUp(16);
        } else {
            try {
                MacroInstaller mi = new MacroInstaller();
                mi.installFile(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        String cmd = e.getActionCommand();
        PopupMenu popup = (PopupMenu)item.getParent();
        if (this.zoomPopup == popup) {
            if ("Zoom In".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "in");
            } else if ("Zoom Out".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "out");
            } else if ("Reset Zoom".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "orig");
            } else if ("View 100%".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "100%");
            } else if ("Zoom To Selection".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "to");
            } else if ("Scale to Fit".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "scale");
            } else if ("Set...".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "set");
            } else if ("Maximize".equals(cmd)) {
                IJ.runPlugIn("ij.plugin.Zoom", "max");
            }
            this.disableRecording = true;
            this.setTool(this.previousTool);
            this.disableRecording = false;
            return;
        }
        if (this.pickerPopup == popup) {
            if ("White/Black".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.white);
                this.setAndRecordBackgroundColor(Color.black);
            } else if ("Black/White".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.black);
                this.setAndRecordBackgroundColor(Color.white);
            } else if ("Red".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.red);
            } else if ("Green".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.green);
            } else if ("Blue".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.blue);
            } else if ("Yellow".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.yellow);
            } else if ("Cyan".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.cyan);
            } else if ("Magenta".equals(cmd)) {
                this.setAndRecordForgroundColor(Color.magenta);
            } else if ("Foreground...".equals(cmd)) {
                this.setAndRecordForgroundColor(new ColorChooser("Select Foreground Color", foregroundColor, false).getColor());
            } else if ("Background...".equals(cmd)) {
                this.setAndRecordBackgroundColor(new ColorChooser("Select Background Color", backgroundColor, false).getColor());
            } else if ("Colors...".equals(cmd)) {
                IJ.run("Colors...", "");
                Recorder.setForegroundColor(Toolbar.getForegroundColor());
                Recorder.setBackgroundColor(Toolbar.getBackgroundColor());
            } else {
                IJ.run("Color Picker...", "");
            }
            if (!"Color Picker".equals(cmd)) {
                ColorPicker.update();
            }
            this.setTool(this.previousTool);
            return;
        }
        int tool = -1;
        for (int i = 15; i < this.getNumTools(); ++i) {
            if (popup != this.menus[i]) continue;
            tool = i;
            break;
        }
        if (tool == -1) {
            return;
        }
        if (this.tools[tool] != null) {
            this.tools[tool].runMenuTool(this.names[tool], cmd);
        }
    }

    private void setAndRecordForgroundColor(Color color) {
        if (color != null) {
            Toolbar.setForegroundColor(color);
            Recorder.setForegroundColor(color);
        }
    }

    private void setAndRecordBackgroundColor(Color color) {
        if (color != null) {
            Toolbar.setBackgroundColor(color);
            Recorder.setBackgroundColor(color);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.ps;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.ps;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        if (this.inGap(x)) {
            IJ.showStatus("");
        } else {
            this.showMessage(this.toolID(x));
        }
    }

    public int addTool(String toolTip) {
        int index = toolTip.indexOf(45);
        boolean hasIcon = index >= 0 && toolTip.length() - index > 4;
        int tool = -1;
        for (int i = 15; i <= this.getNumTools() - 2; ++i) {
            if (this.names[i] != null && !toolTip.startsWith(this.names[i])) continue;
            tool = i;
            break;
        }
        if (tool == 15) {
            legacyMode = toolTip.startsWith("Select and Transform Tool");
        }
        if (tool == -1 && this.nExtraTools < 8) {
            ++this.nExtraTools;
            this.names[this.getNumTools() - 1] = this.names[this.getNumTools() - 2];
            this.icons[this.getNumTools() - 1] = this.icons[this.getNumTools() - 2];
            this.names[this.getNumTools() - 2] = null;
            this.icons[this.getNumTools() - 2] = null;
            this.ps = new Dimension(buttonWidth * 21 - (buttonWidth - gapSize) + this.nExtraTools * buttonWidth, buttonHeight);
            IJ.getInstance().pack();
            tool = this.getNumTools() - 2;
        }
        if (tool == -1) {
            if (this.addingSingleTool) {
                tool = this.getNumTools() - 2;
            } else {
                return -1;
            }
        }
        if (hasIcon) {
            this.icons[tool] = toolTip.substring(index + 1);
            this.names[tool] = index > 0 && toolTip.charAt(index - 1) == ' ' ? toolTip.substring(0, index - 1) : toolTip.substring(0, index);
        } else {
            if (toolTip.endsWith("-")) {
                toolTip = toolTip.substring(0, toolTip.length() - 1);
            } else if (toolTip.endsWith("- ")) {
                toolTip = toolTip.substring(0, toolTip.length() - 2);
            }
            this.names[tool] = toolTip;
        }
        if (tool == current && (this.names[tool].indexOf("Action Tool") != -1 || this.names[tool].indexOf("Unused Tool") != -1)) {
            this.setTool(0);
        }
        if (this.names[tool].endsWith(" Menu Tool")) {
            this.installMenu(tool);
        }
        if (IJ.debugMode) {
            IJ.log("Toolbar.addTool: " + tool + " " + toolTip);
        }
        return tool;
    }

    void installMenu(int tool) {
        Program pgm = this.macroInstaller.getProgram();
        Hashtable h = pgm.getMenus();
        if (h == null) {
            return;
        }
        String[] commands = (String[])h.get(this.names[tool]);
        if (commands == null) {
            return;
        }
        if (this.menus[tool] == null) {
            this.menus[tool] = new PopupMenu("");
            GUI.scalePopupMenu(this.menus[tool]);
            this.add(this.menus[tool]);
        } else {
            this.menus[tool].removeAll();
        }
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].equals("-")) {
                this.menus[tool].addSeparator();
                continue;
            }
            if (commands[i].startsWith("-")) {
                this.menus[tool].addSeparator();
                continue;
            }
            boolean disable = commands[i].startsWith("*");
            String command = commands[i];
            if (disable) {
                command = command.substring(1);
            }
            MenuItem mi = new MenuItem(command);
            if (disable) {
                mi.setEnabled(false);
            }
            mi.addActionListener(this);
            this.menus[tool].add(mi);
        }
        if (tool == current) {
            this.setTool(0);
        }
    }

    public void addMacroTool(String name, MacroInstaller macroInstaller, int id) {
        if (id == 0) {
            this.resetTools();
            if (name.startsWith("Unused")) {
                return;
            }
        }
        if (name.endsWith(" Built-in Tool")) {
            Hashtable commands;
            name = name.substring(0, name.length() - 14);
            this.doNotSavePrefs = true;
            boolean ok = this.installBuiltinTool(name);
            if (!ok && (commands = Menus.getCommands()) != null && commands.get(name) != null) {
                IJ.run(name);
            }
            this.doNotSavePrefs = false;
            return;
        }
        this.macroInstaller = macroInstaller;
        int tool = this.addTool(name);
        this.macroInstaller = null;
        if (tool != -1) {
            this.tools[tool] = new MacroToolRunner(macroInstaller);
        }
    }

    private void resetTools() {
        for (int i = 15; i < this.getNumTools() - 1; ++i) {
            this.names[i] = null;
            this.tools[i] = null;
            this.icons[i] = null;
            if (this.menus[i] == null) continue;
            this.menus[i].removeAll();
        }
    }

    public void addMacroTool(String name, MacroInstaller macroInstaller) {
        String custom1Name = this.names[15];
        this.macroInstaller = macroInstaller;
        this.addingSingleTool = true;
        int tool = this.addTool(name);
        this.addingSingleTool = false;
        this.macroInstaller = null;
        if (tool != -1) {
            this.tools[tool] = new MacroToolRunner(macroInstaller);
            if (!name.contains(" Menu Tool")) {
                if (this.menus[tool] != null) {
                    this.menus[tool].removeAll();
                }
                if (!this.installingStartupTool) {
                    this.setTool(tool);
                } else {
                    this.installingStartupTool = false;
                }
            }
            if (tool - 15 > 0 || custom1Name == null) {
                this.setPrefs(tool);
            }
        }
    }

    private void setPrefs(int id) {
        String name;
        int i;
        if (this.doNotSavePrefs) {
            return;
        }
        boolean ok = this.isBuiltInTool(this.names[id]);
        String prefsName = Toolbar.instance.names[id];
        if (!ok && (i = (name = this.names[id]).indexOf(" (")) > 0) {
            prefsName = name = name.substring(0, i);
        }
        int index = id - 15;
        String key = TOOL_KEY + index / 10 % 10 + index % 10;
        Prefs.set(key, prefsName);
    }

    private boolean isBuiltInTool(String name) {
        int i;
        for (i = 0; i < builtInTools2.length; ++i) {
            if (!name.equals(builtInTools2[i])) continue;
            return true;
        }
        for (i = 0; i < builtInTools.length; ++i) {
            if (!name.startsWith(builtInTools[i])) continue;
            return true;
        }
        return false;
    }

    public static void removeMacroTools() {
        if (instance != null) {
            if (instance.getToolId() >= 15) {
                instance.setTool(0);
            }
            instance.resetTools();
            instance.repaint();
        }
    }

    public static void addPlugInTool(PlugInTool tool) {
        if (instance == null) {
            return;
        }
        String nameAndIcon = tool.getToolName() + " - " + tool.getToolIcon();
        Toolbar.instance.addingSingleTool = true;
        int id = instance.addTool(nameAndIcon);
        Toolbar.instance.addingSingleTool = false;
        if (id != -1) {
            Toolbar.instance.tools[id] = tool;
            if (Toolbar.instance.menus[id] != null) {
                Toolbar.instance.menus[id].removeAll();
            }
            Toolbar.repaintTool(id);
            if (!Toolbar.instance.installingStartupTool) {
                instance.setTool(id);
            } else {
                Toolbar.instance.installingStartupTool = false;
            }
            instance.setPrefs(id);
        }
    }

    public static PlugInTool getPlugInTool() {
        PlugInTool tool = null;
        if (instance == null) {
            return null;
        }
        if (current < Toolbar.instance.tools.length) {
            tool = Toolbar.instance.tools[current];
        }
        if (tool != null && tool instanceof MacroToolRunner) {
            tool = null;
        }
        return tool;
    }

    void runMacroTool(int id) {
        if (id < this.getNumTools() && this.tools[id] != null) {
            this.tools[id].runMacroTool(this.names[id]);
        }
    }

    void showBrushDialog() {
        Roi roi;
        GenericDialog gd = new GenericDialog("Selection Brush");
        gd.addCheckbox("Enable selection brush", ovalType == 2);
        gd.addNumericField("           Size:", brushSize, 0, 4, "pixels");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.getNextBoolean()) {
            ovalType = 2;
        }
        if ((brushSize = (int)gd.getNextNumber()) < 1) {
            brushSize = 1;
        }
        Toolbar.repaintTool(1);
        ImagePlus img = WindowManager.getCurrentImage();
        Roi roi2 = roi = img != null ? img.getRoi() : null;
        if (roi != null && roi.getType() == 1 && ovalType == 2) {
            img.deleteRoi();
        }
        Prefs.set(BRUSH_SIZE, brushSize);
    }

    void showAngleDialog() {
        GenericDialog gd = new GenericDialog("Angle Tool");
        gd.addCheckbox("Measure reflex angle", Prefs.reflexAngle);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            Prefs.reflexAngle = gd.getNextBoolean();
        }
    }

    public void installStartupTools() {
        if (IJ.debugMode) {
            IJ.log("Toolbar.installStartupTools");
        }
        for (int i = 0; i <= 6; ++i) {
            String name = Prefs.get(TOOL_KEY + i / 10 % 10 + i % 10, "");
            if (IJ.debugMode) {
                IJ.log("  " + i + " " + name);
            }
            if (name.equals("")) continue;
            this.installingStartupTool = true;
            boolean ok = this.installBuiltinTool(name);
            if (!ok && !(ok = this.installToolsetTool(name))) {
                Hashtable commands;
                if (name.endsWith("Menu Tool")) {
                    name = name.substring(0, name.length() - 5);
                }
                if ((commands = Menus.getCommands()) != null && commands.get(name) != null) {
                    IJ.run(name);
                }
            }
            this.installingStartupTool = false;
        }
    }

    private boolean installToolsetTool(String name) {
        String text;
        String path = IJ.getDir("macros") + "toolsets" + File.separator + name + ".ijm";
        if (!new File(path).exists()) {
            name = name.replaceAll(" ", "_");
            path = IJ.getDir("macros") + "toolsets" + File.separator + name + ".ijm";
        }
        if ((text = IJ.openAsString(path)) == null || text.startsWith("Error")) {
            return false;
        }
        new MacroInstaller().installSingleTool(text);
        return true;
    }

    private boolean installBuiltinTool(String label) {
        if (IJ.debugMode) {
            IJ.log("Toolbar.installBuiltinTool: " + label);
        }
        boolean ok = true;
        PlugInTool tool = null;
        if (label.startsWith("Arrow")) {
            tool = new ArrowTool();
            if (tool != null) {
                tool.run("");
            }
            this.showSource("Arrow");
        } else if (label.startsWith("Overlay Brush")) {
            tool = new OverlayBrushTool();
            if (tool != null) {
                tool.run("");
            }
            this.showSource("OverlayBrush");
        } else if (label.startsWith("Pixel Inspect")) {
            tool = new PixelInspectionTool();
            if (tool != null) {
                tool.run("");
            }
            this.showSource("PixelInspection");
        } else if (label.startsWith("Brush") || label.startsWith("Paintbrush")) {
            tool = new BrushTool();
            if (tool != null) {
                tool.run("");
            }
            this.showSource("Brush");
        } else if (label.startsWith("Pencil")) {
            tool = new BrushTool();
            if (tool != null) {
                tool.run("pencil");
            }
            this.showSource("Brush");
        } else if (label.startsWith("Selection Rotator")) {
            tool = new RoiRotationTool();
            if (tool != null) {
                tool.run("");
            }
            this.showSource("RoiRotation");
        } else if (label.startsWith("Flood Fill")) {
            this.installMacroFromJar("/macros/FloodFillTool.txt");
        } else if (label.startsWith("Spray Can")) {
            this.installMacroFromJar("/macros/SprayCanTool.txt");
        } else if (label.startsWith("Developer Menu")) {
            this.installMacroFromJar("/macros/DeveloperMenuTool.txt");
        } else if (label.startsWith("Stacks Menu")) {
            this.installMacroFromJar("/macros/StacksMenuTool.txt");
        } else if (label.startsWith("LUT Menu")) {
            this.installMacroFromJar("/macros/LUTMenuTool.txt");
        } else if (label.startsWith("Command Finder")) {
            this.installMacroFromJar("/macros/CommandFinderTool.txt");
        } else if (label.startsWith("ROI")) {
            this.installMacroFromJar("/macros/RoiMenuTool.txt");
        } else if (label.startsWith("Label")) {
            this.installMacroFromJar("/macros/Label_Tool.txt");
        } else {
            ok = false;
        }
        return ok;
    }

    private void showSource(String name) {
        if (IJ.shiftKeyDown()) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", "http://imagej.net/ij/source/ij/plugin/tool/" + name + "Tool.java");
            IJ.setKeyUp(16);
        }
    }

    private void installMacroFromJar(String path) {
        if (IJ.shiftKeyDown()) {
            Toolbar.showCode(path, new MacroInstaller().openFromIJJar(path));
        } else {
            new MacroInstaller().installFromIJJar(path);
        }
    }

    public static void showCode(String title, String code) {
        Editor ed = new Editor();
        ed.setSize(550, 450);
        ed.create(title, code);
        IJ.setKeyUp(16);
    }

    private boolean isMacroSet(int id) {
        if (this.tools[id] == null) {
            return false;
        }
        if (!(this.tools[id] instanceof MacroToolRunner)) {
            return false;
        }
        boolean rtn = ((MacroToolRunner)this.tools[id]).getMacroCount() > 2;
        return rtn;
    }

    public static boolean installStartupMacrosTools() {
        String customTool0 = Prefs.get(TOOL_KEY + "00", "");
        return customTool0.equals("") || Character.isDigit(customTool0.charAt(0));
    }

    public int getNumTools() {
        return 23 + this.nExtraTools;
    }

    public static void setLongClickDelay(int delay) {
        longClickDelay = delay;
    }

    public static void setIcon(String toolName, String icon) {
        if (instance == null) {
            return;
        }
        int tool = 0;
        for (int i = 15; i < instance.getNumTools(); ++i) {
            if (Toolbar.instance.names[i] == null || !Toolbar.instance.names[i].equals(toolName)) continue;
            tool = i;
            break;
        }
        if (tool > 0) {
            Toolbar.instance.icons[tool] = icon;
            Graphics2D g = (Graphics2D)instance.getGraphics();
            instance.setStrokeWidth(g);
            instance.drawButton(g, tool);
        }
    }

    static {
        longClickDelay = 600;
        foregroundColor = Prefs.getColor("fcolor", Color.white);
        backgroundColor = Prefs.getColor("bcolor", Color.black);
        foregroundValue = Double.NaN;
        backgroundValue = Double.NaN;
        ovalType = 0;
        rectType = 0;
        multiPointMode = Prefs.multiPointMode;
        brushSize = (int)Prefs.get(BRUSH_SIZE, 15.0);
        arcSize = (int)Prefs.get(CORNER_DIAMETER, 20.0);
        dscale = 1.0;
        scale = 1;
    }
}

