/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.legacy.service;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.scijava.legacy.service.OpEnvironmentService;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.progress.Progress;
import org.scijava.script.ScriptService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.task.Task;
import org.scijava.task.TaskService;

@Plugin(type=Service.class, attrs={@Attr(name="noAlias")})
public class DefaultOpEnvironmentService
extends AbstractService
implements OpEnvironmentService {
    @Parameter(required=false)
    private ScriptService scriptService;
    @Parameter(required=false)
    private TaskService taskService;

    public void initialize() {
        if (this.scriptService != null) {
            this.scriptService.addAlias(OpEnvironment.class);
        }
        if (this.taskService != null) {
            Progress.addGlobalListener((Consumer)new SciJavaTaskConsumer(this.taskService));
        }
    }

    @Override
    public OpEnvironment env() {
        return OpEnvironmentHolder.env;
    }

    private static class OpEnvironmentHolder {
        private static final OpEnvironment env = OpEnvironment.build();

        private OpEnvironmentHolder() {
        }

        static {
            env.setDefaultHints(new Hints(new String[]{"progress.TRACK"}));
        }
    }

    private static class SciJavaTaskConsumer
    implements Consumer<org.scijava.progress.Task> {
        private final Map<org.scijava.progress.Task, Task> taskMap;
        private final TaskService tasks;

        public SciJavaTaskConsumer(TaskService tasks) {
            this.tasks = tasks;
            this.taskMap = new WeakHashMap<org.scijava.progress.Task, Task>();
        }

        @Override
        public void accept(org.scijava.progress.Task task) {
            if (task.isSubTask()) {
                return;
            }
            Task sjTask = this.taskMap.computeIfAbsent(task, t -> {
                Task value = this.tasks.createTask(t.description());
                value.start();
                value.setProgressMaximum(100L);
                return value;
            });
            sjTask.setProgressValue((long)(task.progress() * 100.0));
            if (task.isComplete()) {
                sjTask.finish();
            }
        }
    }
}

