/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.interval.IntervalSamplingMethod;

public interface RealTransform {
    public int numSourceDimensions();

    public int numTargetDimensions();

    public void apply(double[] var1, double[] var2);

    default public void apply(long[] source, double[] target) {
        if (!(1.$assertionsDisabled || source.length >= this.numSourceDimensions() && target.length >= this.numTargetDimensions())) {
            throw new AssertionError((Object)"Input dimensions too small.");
        }
        double[] doubleSource = new double[source.length];
        for (int d = 0; d < this.numSourceDimensions(); ++d) {
            doubleSource[d] = source[d];
        }
        this.apply(doubleSource, target);
    }

    @Deprecated
    default public void apply(float[] source, float[] target) {
        int d;
        if (!(1.$assertionsDisabled || source.length >= this.numSourceDimensions() && target.length >= this.numTargetDimensions())) {
            throw new AssertionError((Object)"Input dimensions too small.");
        }
        double[] doubleSource = new double[source.length];
        double[] doubleTarget = new double[target.length];
        for (d = 0; d < source.length; ++d) {
            doubleSource[d] = source[d];
        }
        this.apply(doubleSource, doubleTarget);
        for (d = 0; d < target.length; ++d) {
            target[d] = (float)doubleTarget[d];
        }
    }

    public void apply(RealLocalizable var1, RealPositionable var2);

    default public double applyDimension(double[] source, int d) {
        if (!(1.$assertionsDisabled || source.length >= this.numSourceDimensions() && d < this.numTargetDimensions())) {
            throw new AssertionError((Object)"Input dimensions too small.");
        }
        double[] target = new double[this.numTargetDimensions()];
        this.apply(source, target);
        return target[d];
    }

    default public double applyDimension(long[] source, int d) {
        if (!(1.$assertionsDisabled || source.length >= this.numSourceDimensions() && d < this.numTargetDimensions())) {
            throw new AssertionError((Object)"Input dimensions too small.");
        }
        double[] target = new double[this.numTargetDimensions()];
        this.apply(source, target);
        return target[d];
    }

    default public double applyDimension(RealLocalizable source, int d) {
        if (!(1.$assertionsDisabled || source.numDimensions() >= this.numSourceDimensions() && d < this.numTargetDimensions())) {
            throw new AssertionError((Object)"Input dimensions too small.");
        }
        RealPoint target = new RealPoint(this.numTargetDimensions());
        this.apply(source, (RealPositionable)target);
        return target.getDoublePosition(d);
    }

    public RealTransform copy();

    default public boolean isIdentity() {
        return false;
    }

    default public RealInterval boundingInterval(RealInterval interval, IntervalSamplingMethod samplingMethod) {
        return samplingMethod.bounds(interval, this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

