/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.interval;

import java.util.Arrays;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.interval.IntervalSamplingMethod;

public class Corners
implements IntervalSamplingMethod {
    @Override
    public RealInterval bounds(RealInterval interval, RealTransform transform) {
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] min = new double[nd];
        double[] max = new double[nd];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        long[] unitInterval = new long[nd];
        Arrays.fill(unitInterval, 2L);
        IntervalIterator it = new IntervalIterator(unitInterval);
        while (it.hasNext()) {
            int d;
            it.fwd();
            for (d = 0; d < nd; ++d) {
                pt[d] = it.getLongPosition(d) == 0L ? interval.realMin(d) : interval.realMax(d);
            }
            transform.apply(pt, pt);
            for (d = 0; d < nd; ++d) {
                if (pt[d] < min[d]) {
                    min[d] = pt[d];
                }
                if (!(pt[d] > max[d])) continue;
                max[d] = pt[d];
            }
        }
        return new FinalRealInterval(min, max, false);
    }
}

