/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.display.ColorTables;
import net.imagej.notebook.NotebookService;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.stats.ComputeMinMax;
import net.imglib2.converter.RealLUTConverter;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import net.imglib2.display.projector.composite.CompositeXYProjector;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public final class Images {
    private Images() {
    }

    public static byte[] encode(RenderedImage image) throws IOException {
        return Images.encode(image, "png");
    }

    public static byte[] encode(RenderedImage image, String format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean success = ImageIO.write(image, format, baos);
        return success ? baos.toByteArray() : null;
    }

    public static BufferedImage decode(byte[] data) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(data));
    }

    public static String base64(RenderedImage image) throws IOException {
        return Base64.getEncoder().encodeToString(Images.encode(image));
    }

    public static String html(RenderedImage image) throws IOException {
        return Images.html(image, null);
    }

    public static String html(RenderedImage image, String title) throws IOException {
        String titleAttributes = title == null ? "" : "alt=\"" + title + "\" title=\"" + title + "\" ";
        return "<img src=\"data:image/png;charset=utf-8;base64," + Images.base64(image) + "\" " + titleAttributes + "/>";
    }

    public static <T extends RealType<T>> BufferedImage bufferedImage(Dataset source) {
        return Images.bufferedImage(source, source.dimensionIndex(Axes.X), source.dimensionIndex(Axes.Y), source.dimensionIndex(Axes.CHANNEL), NotebookService.ValueScaling.AUTO, new long[0]);
    }

    public static <T extends RealType<T>> BufferedImage bufferedImage(RandomAccessibleInterval<T> source) {
        int cAxis = source.numDimensions() > 2 && source.dimension(2) <= 3L ? 2 : -1;
        return Images.bufferedImage(source, 0, 1, cAxis, NotebookService.ValueScaling.AUTO, new long[0]);
    }

    public static <T extends RealType<T>> BufferedImage bufferedImage(RandomAccessibleInterval<T> source, double min, double max) {
        int cAxis = source.numDimensions() > 2 && source.dimension(2) <= 3L ? 2 : -1;
        int channels = cAxis >= 0 ? (int)source.dimension(cAxis) : 1;
        double[] minArray = new double[channels];
        double[] maxArray = new double[channels];
        for (int i = 0; i < minArray.length; ++i) {
            minArray[i] = min;
            maxArray[i] = max;
        }
        return Images.bufferedImage(source, 0, 1, cAxis, minArray, maxArray, new long[0]);
    }

    public static <T extends RealType<T>> Object bufferedImage(RandomAccessibleInterval<T> source, double[] min, double[] max) {
        int cAxis = source.numDimensions() > 2 && source.dimension(2) <= 3L ? 2 : -1;
        return Images.bufferedImage(source, 0, 1, cAxis, min, max, new long[0]);
    }

    public static <T extends RealType<T>> BufferedImage bufferedImage(RandomAccessibleInterval<T> source, int xAxis, int yAxis, int cAxis, NotebookService.ValueScaling scaling, long ... pos) {
        double max;
        double min;
        boolean full = scaling == NotebookService.ValueScaling.FULL || scaling == NotebookService.ValueScaling.AUTO && Images.isNarrowType(source);
        RealType firstElement = (RealType)Views.iterable(source).firstElement();
        if (full) {
            min = firstElement.getMinValue();
            max = firstElement.getMaxValue();
        } else {
            IterableInterval ii = Views.flatIterable(source);
            RealType tMin = (RealType)((RealType)ii.firstElement()).createVariable();
            RealType tMax = (RealType)tMin.createVariable();
            ComputeMinMax.computeMinMax(source, (Comparable)tMin, (Comparable)tMax);
            min = tMin.getRealDouble();
            max = tMax.getRealDouble();
        }
        int arraySize = cAxis >= 0 ? (int)source.dimension(cAxis) : 1;
        double[] minArray = new double[arraySize];
        double[] maxArray = new double[arraySize];
        for (int i = 0; i < minArray.length; ++i) {
            minArray[i] = min;
            maxArray[i] = max;
        }
        return Images.bufferedImage(source, xAxis, yAxis, cAxis, minArray, maxArray, pos);
    }

    public static <T extends RealType<T>> BufferedImage bufferedImage(RandomAccessibleInterval<T> source, int xAxis, int yAxis, int cAxis, double[] min, double[] max, long ... pos) {
        IntervalView image = Views.zeroMin(source);
        int w = xAxis >= 0 ? (int)image.dimension(xAxis) : 1;
        int h = yAxis >= 0 ? (int)image.dimension(yAxis) : 1;
        int c = cAxis >= 0 ? (int)image.dimension(cAxis) : 1;
        ARGBScreenImage target = new ARGBScreenImage(w, h);
        ArrayList<RealLUTConverter> converters = new ArrayList<RealLUTConverter>(c);
        if (min.length != c || max.length != c) {
            throw new IllegalArgumentException("clamping arrays must be of the same length as the number of channels!");
        }
        for (int i = 0; i < c; ++i) {
            ColorTable8 lut = c == 1 ? ColorTables.GRAYS : ColorTables.getDefaultColorTable((int)i);
            converters.add(new RealLUTConverter(min[i], max[i], (ColorTable)lut));
        }
        CompositeXYProjector proj = new CompositeXYProjector((RandomAccessibleInterval)image, (IterableInterval)target, converters, cAxis);
        if (pos != null && pos.length > 0) {
            proj.setPosition(pos);
        }
        proj.setComposite(true);
        proj.map();
        return target.image();
    }

    private static <T extends RealType<T>> boolean isNarrowType(RandomAccessibleInterval<T> source) {
        return ((RealType)Util.getTypeFromInterval(source)).getBitsPerPixel() <= 8;
    }
}

