/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.Scale3D;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5LabelMultisets;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.FinalVoxelDimensions;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;

public class N5SingleScaleMetadataParser
implements N5MetadataParser<N5SingleScaleMetadata>,
N5MetadataWriter<N5SingleScaleMetadata> {
    public static final String DOWNSAMPLING_FACTORS_KEY = "downsamplingFactors";
    public static final String PIXEL_RESOLUTION_KEY = "pixelResolution";
    public static final String AFFINE_TRANSFORM_KEY = "affineTransform";
    public static final Pattern channelPattern = Pattern.compile("^c\\d+$");
    public static final Pattern scaleLevelPattern = Pattern.compile("^s\\d+$");
    public static final Pattern channelScaleLevelPattern = Pattern.compile("^/?c\\d+/s\\d+$");

    public static AffineTransform3D buildTransform(double[] downsamplingFactors, double[] pixelResolution, Optional<AffineTransform3D> extraTransformOpt) {
        AffineTransform3D mipmapTransform = new AffineTransform3D();
        if (downsamplingFactors.length >= 3) {
            mipmapTransform.set(downsamplingFactors[0], 0.0, 0.0, 0.5 * (downsamplingFactors[0] - 1.0), 0.0, downsamplingFactors[1], 0.0, 0.5 * (downsamplingFactors[1] - 1.0), 0.0, 0.0, downsamplingFactors[2], 0.5 * (downsamplingFactors[2] - 1.0));
        } else if (downsamplingFactors.length == 2) {
            mipmapTransform.set(downsamplingFactors[0], 0.0, 0.0, 0.5 * (downsamplingFactors[0] - 1.0), 0.0, downsamplingFactors[1], 0.0, 0.5 * (downsamplingFactors[1] - 1.0), 0.0, 0.0, 1.0, 0.0);
        }
        Scale3D scale = null;
        scale = pixelResolution.length == 2 ? new Scale3D(pixelResolution[0], pixelResolution[1], 1.0) : new Scale3D(pixelResolution[0], pixelResolution[1], pixelResolution[2]);
        AffineTransform3D transform = new AffineTransform3D();
        if (scale != null) {
            transform.preConcatenate(mipmapTransform).preConcatenate((AffineGet)scale);
        }
        extraTransformOpt.ifPresent(x -> transform.preConcatenate(x));
        return transform;
    }

    public static Optional<double[]> inferDownsamplingFactorsFromDataset(String dataset) {
        String datasetNumber = dataset.replaceAll("^s", "");
        try {
            long downscaleFactorPower = Long.parseLong(datasetNumber);
            long f = (long)Math.pow(2.0, downscaleFactorPower);
            return Optional.of(new double[]{f, f, f});
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private double[] ones(int nd) {
        double[] ones = new double[nd];
        Arrays.fill(ones, 1.0);
        return ones;
    }

    @Override
    public Optional<N5SingleScaleMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        try {
            Optional<Object> voxdim;
            DatasetAttributes attributes = n5.getDatasetAttributes(node.getPath());
            if (attributes == null) {
                return Optional.empty();
            }
            int nd = attributes.getNumDimensions();
            double[] downsamplingFactors = Optional.ofNullable(n5.getAttribute(node.getPath(), DOWNSAMPLING_FACTORS_KEY, double[].class)).orElseGet(() -> N5SingleScaleMetadataParser.inferDownsamplingFactorsFromDataset(node.getNodeName()).orElseGet(() -> this.ones(nd)));
            try {
                voxdim = Optional.ofNullable(n5.getAttribute(node.getPath(), PIXEL_RESOLUTION_KEY, FinalVoxelDimensions.class));
            }
            catch (Exception e) {
                voxdim = Optional.empty();
            }
            String unit = "pixel";
            double[] pixelResolution = null;
            if (voxdim.isPresent()) {
                pixelResolution = voxdim.map(x -> {
                    double[] res = new double[x.numDimensions()];
                    x.dimensions(res);
                    return res;
                }).orElseGet(() -> this.ones(nd));
                unit = voxdim.map(x -> x.unit()).orElse("pixel");
            } else {
                Optional<Object> pixelResolutionOpt = Optional.ofNullable(n5.getAttribute(node.getPath(), PIXEL_RESOLUTION_KEY, double[].class));
                if (pixelResolutionOpt.isPresent()) {
                    unit = "pixel";
                    pixelResolution = (double[])pixelResolutionOpt.get();
                }
            }
            Optional<Object> extraTransform = Optional.ofNullable(n5.getAttribute(node.getPath(), AFFINE_TRANSFORM_KEY, AffineTransform3D.class));
            AffineTransform3D transform = N5SingleScaleMetadataParser.buildTransform(downsamplingFactors, pixelResolution, extraTransform);
            double[] offset = new double[nd];
            offset = nd == 2 ? new double[]{transform.get(0, 3), transform.get(1, 3)} : new double[]{transform.get(0, 3), transform.get(1, 3), transform.get(2, 3)};
            boolean isLabelMultiset = N5LabelMultisets.isLabelMultisetType((N5Reader)n5, (String)node.getPath());
            return Optional.of(new N5SingleScaleMetadata(node.getPath(), transform, downsamplingFactors, pixelResolution, offset, unit, attributes, isLabelMultiset));
        }
        catch (N5Exception e) {
            return Optional.empty();
        }
    }

    public Optional<FinalVoxelDimensions> validateAndReturnN5vPixelResoution(N5Reader n5, String group) {
        if (!channelScaleLevelPattern.asPredicate().test(group)) {
            return Optional.empty();
        }
        String baseGroup = group.substring(0, group.lastIndexOf(n5.getGroupSeparator()));
        FinalVoxelDimensions pixelResObj = null;
        try {
            String[] children;
            for (String childPath : children = n5.list(baseGroup)) {
                String path = baseGroup + n5.getGroupSeparator() + childPath;
                FinalVoxelDimensions pro = this.getVoxDimObj(n5, path);
                if (pro != null) {
                    if (pixelResObj == null) {
                        pixelResObj = pro;
                        continue;
                    }
                    if (FinalVoxelDimensions.equals(pro, pixelResObj)) continue;
                    return Optional.empty();
                }
                double[] pra = this.getVoxDimArr(n5, path);
                if (pra == null) continue;
                FinalVoxelDimensions pr = new FinalVoxelDimensions("pixel", pra);
                if (pixelResObj == null) {
                    pixelResObj = pr;
                    continue;
                }
                if (FinalVoxelDimensions.equals(pr, pixelResObj)) continue;
                return Optional.empty();
            }
        }
        catch (N5Exception n5Exception) {
            // empty catch block
        }
        return Optional.of(pixelResObj);
    }

    private static boolean arrayEquals(double[] a, double[] b, double eps) {
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    private FinalVoxelDimensions getVoxDimObj(N5Reader n5, String path) {
        try {
            return (FinalVoxelDimensions)n5.getAttribute(path, PIXEL_RESOLUTION_KEY, FinalVoxelDimensions.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private double[] getVoxDimArr(N5Reader n5, String path) {
        try {
            return (double[])n5.getAttribute(path, PIXEL_RESOLUTION_KEY, double[].class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void writeMetadata(N5SingleScaleMetadata t, N5Writer n5, String group) throws Exception {
        double[] pixelResolution = new double[]{t.spatialTransform3d().get(0, 0), t.spatialTransform3d().get(1, 1), t.spatialTransform3d().get(2, 2)};
        FinalVoxelDimensions voxdims = new FinalVoxelDimensions(t.unit(), pixelResolution);
        n5.setAttribute(group, PIXEL_RESOLUTION_KEY, (Object)voxdims);
        if (t.getDownsamplingFactors() != null) {
            n5.setAttribute(group, DOWNSAMPLING_FACTORS_KEY, (Object)t.getDownsamplingFactors());
        }
    }
}

