/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.scijava.io.location.AbstractRemoteLocation;

public class HTTPLocation
extends AbstractRemoteLocation {
    private final HttpUrl url;

    public HTTPLocation(URI uri, String username, String password) throws URISyntaxException {
        String scheme = uri.getScheme();
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            throw new URISyntaxException(uri.toString(), "URI does not point to an HTTP(S) location.");
        }
        this.url = HttpUrl.get((URI)uri).newBuilder().username(username).password(password).build();
    }

    public HTTPLocation(URI uri) throws URISyntaxException {
        this(uri, "", "");
    }

    public HTTPLocation(HttpUrl url) {
        this.url = url;
    }

    public HTTPLocation(String url, String username, String password) throws URISyntaxException, MalformedURLException {
        this.url = HttpUrl.parse((String)url).newBuilder().username(username).password(password).build();
    }

    public HTTPLocation(String url) throws URISyntaxException, MalformedURLException {
        this(url, "", "");
    }

    public URL getURL() {
        return this.url.url();
    }

    public HttpUrl getHttpUrl() {
        return this.url;
    }

    public URI getURI() {
        return this.url.uri();
    }

    public String getName() {
        List segs = this.url.pathSegments();
        return (String)segs.get(segs.size() - 1);
    }
}

