/*
 * Decompiled with CFR 0.152.
 */
import color.CIELAB;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class RGB_to_CIELAB
implements PlugInFilter {
    protected ImagePlus image;
    protected int w;
    protected int h;

    public void run(ImageProcessor ip) {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        float[] rgb = new float[3];
        float[] lab = new float[3];
        if (this.image.getStack().getSize() == 1) {
            int[] pixels = (int[])this.image.getProcessor().getPixels();
            float[] l = new float[this.w * this.h];
            float[] a = new float[this.w * this.h];
            float[] b = new float[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                int v = pixels[i];
                CIELAB.int2sRGB((int)v, (float[])rgb);
                CIELAB.sRGB2CIELAB((float[])rgb, (float[])lab);
                l[i] = lab[0];
                a[i] = lab[1];
                b[i] = lab[2];
            }
            ImageStack stack = new ImageStack(this.w, this.h);
            stack.addSlice("L", (ImageProcessor)new FloatProcessor(this.w, this.h, l, null));
            stack.addSlice("a", (ImageProcessor)new FloatProcessor(this.w, this.h, a, null));
            stack.addSlice("b", (ImageProcessor)new FloatProcessor(this.w, this.h, b, null));
            new ImagePlus(this.image.getTitle() + " Lab", stack).show();
        } else {
            int[] rgbi = new int[3];
            ImageStack stack = this.image.getStack();
            float[] l = (float[])stack.getProcessor(1).getPixels();
            float[] a = (float[])stack.getProcessor(2).getPixels();
            float[] b = (float[])stack.getProcessor(3).getPixels();
            int[] pixels = new int[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                lab[0] = l[i];
                lab[1] = a[i];
                lab[2] = b[i];
                CIELAB.CIELAB2sRGB((float[])lab, (float[])rgb);
                pixels[i] = CIELAB.sRGB2int((float[])rgb);
            }
            ip = new ColorProcessor(this.w, this.h, pixels);
            new ImagePlus(this.image.getTitle() + " RGB", ip).show();
        }
    }

    public int setup(String args, ImagePlus imp) {
        this.image = imp;
        return 152;
    }
}

