/*
 * Decompiled with CFR 0.152.
 */
import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import vib.segment.CustomStackWindow;
import vib.segment.MaterialList;
import vib.segment.SegmentationEditor;

public class Segmentation_Editor
extends SegmentationEditor {
    private static CustomStackWindow cached = null;

    private static CustomStackWindow getInstance() {
        int[] ids;
        if (cached != null) {
            return cached;
        }
        for (int id : ids = WindowManager.getIDList()) {
            ImageWindow iw = WindowManager.getImage((int)id).getWindow();
            if (!(iw instanceof CustomStackWindow)) continue;
            return (CustomStackWindow)iw;
        }
        Segmentation_Editor.newSegmentationEditor();
        return cached;
    }

    public static final void newSegmentationEditor() {
        final ImagePlus image = WindowManager.getCurrentImage();
        if (image == null) {
            IJ.error((String)"No image?");
            return;
        }
        cached = new CustomStackWindow(image);
        cached.getLabels().show();
        cached.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Ok")) {
                    image.show();
                }
            }
        });
    }

    public static final void setLabels(ImagePlus labels) {
        Segmentation_Editor.getInstance().setLabels(labels);
    }

    public static final void newMaterials() {
        ImagePlus labels = Segmentation_Editor.getInstance().getLabels();
        String materials = "Parameters {\n\tMaterials {\n\t\tExterior {\n\t\t\tColor 0.0 0.0 0.0\n\t\t}\n\t}\n}\n";
        AmiraParameters params = new AmiraParameters(materials);
        params.setParameters(labels);
        Segmentation_Editor.setLabels(labels);
    }

    public static final void addMaterial(String material, int r, int g, int b) {
        if (Segmentation_Editor.hasMaterial(material)) {
            throw new IllegalArgumentException(material + " already exists");
        }
        MaterialList ml = Segmentation_Editor.getInstance().getSidebar().getMaterials();
        ml.addMaterial();
        ml.select(ml.getItemCount() - 1);
        ml.renameMaterial(material);
        ml.setColor(r, g, b);
    }

    public static final boolean hasMaterial(String name) {
        return Segmentation_Editor.getInstance().getSidebar().getMaterials().getIndexOf(name) != -1;
    }
}

