/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import javax.imageio.ImageIO;
import util.BatchOpener;

public class Unpack_To_PNG
implements PlugIn {
    public void run(String pluginArguments) {
        String realArguments = null;
        String macroArguments = Macro.getOptions();
        if (macroArguments == null || macroArguments.equals("")) {
            if (pluginArguments == null || pluginArguments.equals("")) {
                IJ.error((String)"No parameters supplied either as macro options or a plugin argument.");
                return;
            }
            realArguments = pluginArguments;
        } else {
            realArguments = macroArguments;
        }
        String filename = Macro.getValue((String)realArguments, (String)"filename", (String)"");
        if (filename.equals("")) {
            IJ.error((String)"No macro parameter filename supplied");
            return;
        }
        String destinationDirectory = Macro.getValue((String)macroArguments, (String)"directory", (String)"");
        if (destinationDirectory.equals("")) {
            IJ.error((String)"No macro parameter directory supplied");
            return;
        }
        ImagePlus[] imps = BatchOpener.open((String)filename);
        if (imps == null) {
            IJ.error((String)("Couldn't open the file: " + filename));
            return;
        }
        if (AmiraParameters.isAmiraLabelfield((ImagePlus)imps[0])) {
            System.out.println("Looks like an Amira label file...");
            try {
                this.unpackAmiraLabelFieldToPNGs(imps[0], destinationDirectory);
            }
            catch (IOException e) {
                IJ.error((String)("There was an IOException while unpacking the label file: " + e));
            }
            return;
        }
        System.out.println("Decided it doesn't look a label file, but has " + imps.length + " channels.");
        for (int i = 0; i < imps.length; ++i) {
            ImagePlus imp = imps[i];
            int stackDepth = imp.getStackSize();
            for (int z = 0; z < stackDepth; ++z) {
                DecimalFormat f2 = new DecimalFormat("00");
                DecimalFormat f5 = new DecimalFormat("00000");
                String outputFileName = f2.format(i) + "-" + f5.format(z) + ".png";
                outputFileName = destinationDirectory + File.separator + outputFileName;
                try {
                    this.writeImage(imp, z, outputFileName, -1);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Caught an exception: " + e);
                    return;
                }
            }
        }
    }

    ArrayList<Polygon> getPolygonsNonBackground(ByteProcessor bp) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Roi roi = this.getRoiNonBackground(bp);
        if (roi == null) {
            return polygons;
        }
        Roi[] rois = null;
        if (roi.getType() == 9) {
            ShapeRoi shapeRoi = (ShapeRoi)roi;
            rois = shapeRoi.getRois();
        } else if (roi.getType() == 4) {
            PolygonRoi polygonRoi = (PolygonRoi)roi;
            rois = new Roi[]{polygonRoi};
        } else {
            System.out.println("Unhandled Roi type: " + roi.getType() + ", " + roi.getTypeAsString());
        }
        for (int i = 0; i < rois.length; ++i) {
            Polygon p = rois[i].getPolygon();
            polygons.add(p);
        }
        return polygons;
    }

    Roi getRoiNonBackground(ByteProcessor bp) {
        bp.setThreshold(1.0, 255.0, 2);
        ImageStack tempStack = new ImageStack(bp.getWidth(), bp.getHeight());
        tempStack.addSlice(null, (ImageProcessor)bp);
        ImagePlus imp = new ImagePlus("example stack", tempStack);
        ThresholdToSelection tts = new ThresholdToSelection();
        tts.setup("", imp);
        tts.run((ImageProcessor)bp);
        return imp.getRoi();
    }

    public static String polygonToAreaCoords(Polygon polygon) {
        String result = "";
        double first_x = -1.0;
        double first_y = -1.0;
        double[] coordinates = new double[6];
        boolean empty = true;
        boolean first_points_set = false;
        PathIterator pi = polygon.getPathIterator(null);
        while (!pi.isDone()) {
            empty = false;
            int type = pi.currentSegment(coordinates);
            if (type == 0) {
                first_x = coordinates[0];
                first_y = coordinates[1];
                first_points_set = true;
                result = result + (int)coordinates[0] + ", " + (int)coordinates[1] + ", ";
            } else if (type == 1) {
                result = result + (int)coordinates[0] + ", " + (int)coordinates[1] + ", ";
            } else {
                if (type == 4) break;
                IJ.error((String)("Unhandled PathIterator type: " + type));
                return "";
            }
            pi.next();
        }
        if (empty) {
            return "";
        }
        if (first_x == coordinates[0] && first_y == coordinates[1]) {
            if (result.endsWith(", ")) {
                result = result.substring(0, result.length() - 2);
            }
        } else {
            result = result + (int)first_x + ", " + (int)first_y;
        }
        return result;
    }

    void unpackAmiraLabelFieldToPNGs(ImagePlus labelFileImp, String destinationDirectory) throws IOException {
        if (labelFileImp.getType() != 0 && labelFileImp.getType() != 3) {
            IJ.error((String)"The label file appeared not to be 8 bit (!)");
            return;
        }
        AmiraParameters ap = new AmiraParameters(labelFileImp);
        int materialCount = ap.getMaterialCount();
        String[] materialNames = ap.getMaterialList();
        int stackDepth = labelFileImp.getStackSize();
        int width = labelFileImp.getWidth();
        int height = labelFileImp.getHeight();
        String jsIndexFileName = destinationDirectory + File.separator + "material-index.js";
        PrintStream ps = new PrintStream(jsIndexFileName);
        ps.println("var materials = [");
        byte[] reds = new byte[materialCount];
        byte[] greens = new byte[materialCount];
        byte[] blues = new byte[materialCount];
        for (int i = 0; i < materialCount; ++i) {
            double[] color = ap.getMaterialColor(i);
            reds[i] = (byte)(color[0] * 255.0);
            greens[i] = (byte)(color[1] * 255.0);
            blues[i] = (byte)(color[2] * 255.0);
            ps.print("  [ \"" + ap.getMaterialName(i) + "\", [ " + (reds[i] & 0xFF) + ", " + (greens[i] & 0xFF) + ", " + (blues[i] & 0xFF) + " ] ]");
            if (i != materialCount - 1) {
                ps.println(",");
                continue;
            }
            ps.println("");
        }
        ps.println("];");
        ps.close();
        String dimensionsFileName = destinationDirectory + File.separator + "dimensions.js";
        ps = new PrintStream(dimensionsFileName);
        ps.println("var stack_width = " + width + ";");
        ps.println("var stack_height = " + height + ";");
        ps.println("var stack_depth = " + stackDepth + ";");
        ps.close();
        long[] pixelCountsForMaterial = new long[materialCount];
        float[] xSumsForMaterial = new float[materialCount];
        float[] ySumsForMaterial = new float[materialCount];
        float[] zSumsForMaterial = new float[materialCount];
        byte[] alphas = new byte[materialCount];
        IndexColorModel cm = new IndexColorModel(8, materialCount, reds, greens, blues, 0);
        String allMapsFileName = destinationDirectory + File.separator + "all-maps.html";
        PrintStream allps = new PrintStream(allMapsFileName);
        for (int z = 0; z < stackDepth; ++z) {
            DecimalFormat f2 = new DecimalFormat("00");
            DecimalFormat f5 = new DecimalFormat("00000");
            String outputFileNameStem = f2.format(0L) + "-" + f5.format(z) + ".png";
            outputFileNameStem = destinationDirectory + File.separator + outputFileNameStem;
            ImageStack stack = labelFileImp.getStack();
            ImageProcessor imageProcessor = stack.getProcessor(z + 1);
            byte[] pixels = (byte[])imageProcessor.getPixelsCopy();
            HashSet<Integer> materialsInThisSlice = new HashSet<Integer>();
            String mapOpen = "<MAP NAME=\"map-" + f5.format(z) + "\">";
            String mapClose = "</MAP>";
            for (int i = 0; i < pixels.length; ++i) {
                int intValue = pixels[i] & 0xFF;
                Integer value = new Integer(intValue);
                materialsInThisSlice.add(value);
                int n = intValue;
                pixelCountsForMaterial[n] = pixelCountsForMaterial[n] + 1L;
                int x = i % width;
                int y = i / width;
                int n2 = intValue;
                xSumsForMaterial[n2] = xSumsForMaterial[n2] + (float)x;
                int n3 = intValue;
                ySumsForMaterial[n3] = ySumsForMaterial[n3] + (float)y;
                int n4 = intValue;
                zSumsForMaterial[n4] = zSumsForMaterial[n4] + (float)z;
            }
            allps.println(mapOpen);
            BufferedImage bi = new BufferedImage(width, height, 13, cm);
            String outputFileName = outputFileNameStem + "-all.png";
            Graphics2D g = (Graphics2D)bi.getGraphics();
            Image imageToDraw = imageProcessor.createImage();
            g.drawImage(imageToDraw, 0, 0, null);
            File f = new File(outputFileName);
            ImageIO.write((RenderedImage)bi, "png", f);
            byte[] emptySliceData = new byte[pixels.length];
            for (int i = 0; i < pixels.length; ++i) {
                emptySliceData[i] = 0;
            }
            ByteProcessor emptyBP = new ByteProcessor(width, height);
            emptyBP.setColorModel((ColorModel)cm);
            emptyBP.setPixels((Object)emptySliceData);
            String imageMapFileName = destinationDirectory + File.separator + "map-" + f5.format(z) + ".html";
            ps = new PrintStream(imageMapFileName);
            for (int material = 1; material < materialCount; ++material) {
                String regionName = ap.getMaterialName(material);
                DecimalFormat dfm = new DecimalFormat("000");
                String outputFileName2 = outputFileNameStem + "-" + dfm.format(material) + "-" + regionName + ".png";
                BufferedImage bi2 = new BufferedImage(width, height, 13, cm);
                Graphics2D g2 = (Graphics2D)bi2.getGraphics();
                if (materialsInThisSlice.contains(new Integer(material))) {
                    byte[] sliceData = new byte[pixels.length];
                    for (int i = 0; i < pixels.length; ++i) {
                        sliceData[i] = (pixels[i] & 0xFF) == material ? (byte)material : (byte)0;
                    }
                    byte[] sliceDataCopy = new byte[sliceData.length];
                    System.arraycopy(sliceData, 0, sliceDataCopy, 0, sliceData.length);
                    ByteProcessor singleMaterialBP = new ByteProcessor(width, height);
                    singleMaterialBP.setColorModel((ColorModel)cm);
                    singleMaterialBP.setPixels((Object)sliceData);
                    Image imageToDraw2 = singleMaterialBP.createImage();
                    g2.drawImage(imageToDraw2, 0, 0, null);
                    File f3 = new File(outputFileName2);
                    ImageIO.write((RenderedImage)bi2, "png", f3);
                    ArrayList<Polygon> polygons = this.getPolygonsNonBackground(singleMaterialBP);
                    for (Polygon p : polygons) {
                        String areaString = "<area shape=\"poly\" alt=\"" + regionName + "\" coords=\"" + Unpack_To_PNG.polygonToAreaCoords(p) + "\" href=\"#" + regionName + "-" + f5.format(z) + "\" onclick=\"selectedArea(" + z + ",'" + regionName + "')\">";
                        ps.println(areaString);
                        allps.println(areaString);
                    }
                    continue;
                }
                Image imageToDraw3 = emptyBP.createImage();
                g2.drawImage(imageToDraw3, 0, 0, null);
                File f4 = new File(outputFileName2);
                ImageIO.write((RenderedImage)bi2, "png", f4);
            }
            ps.close();
            allps.println(mapClose);
        }
        allps.close();
        String centresFileName = destinationDirectory + File.separator + "centres.js";
        ps = new PrintStream(centresFileName);
        ps.println("var centres_of_gravity = [");
        for (int i = 0; i < materialCount; ++i) {
            int n = i;
            xSumsForMaterial[n] = xSumsForMaterial[n] / (float)pixelCountsForMaterial[i];
            int n5 = i;
            ySumsForMaterial[n5] = ySumsForMaterial[n5] / (float)pixelCountsForMaterial[i];
            int n6 = i;
            zSumsForMaterial[n6] = zSumsForMaterial[n6] / (float)pixelCountsForMaterial[i];
            ps.print("[ " + (int)xSumsForMaterial[i] + ", " + (int)ySumsForMaterial[i] + ", " + (int)zSumsForMaterial[i] + " ]");
            if (i != materialCount - 1) {
                ps.println(",");
                continue;
            }
            ps.println("");
        }
        ps.println("];");
        ps.close();
    }

    void writeImage(ImagePlus imp, int slice, String path, int transparentColorIndex) throws Exception {
        LookUpTable lut;
        int width = imp.getWidth();
        int height = imp.getHeight();
        BufferedImage bi = null;
        if (imp.getType() == 0 || imp.getType() == 3) {
            lut = imp.createLut();
            if (lut != null && lut.getMapSize() > 0) {
                int size = lut.getMapSize();
                byte[] reds = lut.getReds();
                byte[] greens = lut.getGreens();
                byte[] blues = lut.getBlues();
                IndexColorModel cm = null;
                cm = transparentColorIndex < 0 ? new IndexColorModel(8, size, reds, greens, blues) : new IndexColorModel(8, size, reds, greens, blues, transparentColorIndex);
                bi = new BufferedImage(width, height, 13, cm);
            } else {
                if (lut == null && imp.getType() == 3) {
                    IJ.error((String)"createLut() returned null for a COLOR_256 image");
                    return;
                }
                bi = new BufferedImage(width, height, 10);
            }
        } else if (imp.getType() == 3) {
            lut = imp.createLut();
        } else {
            bi = new BufferedImage(width, height, 1);
        }
        Graphics2D g = (Graphics2D)bi.getGraphics();
        ImageStack stack = imp.getStack();
        ImageProcessor imageProcessor = stack.getProcessor(slice + 1);
        Image imageToDraw = imageProcessor.createImage();
        g.drawImage(imageToDraw, 0, 0, null);
        File f = new File(path);
        ImageIO.write((RenderedImage)bi, "png", f);
    }
}

