/*
 * Decompiled with CFR 0.152.
 */
package vib;

class Bins {
    int bins;
    double minDistance;
    double maxDistance;
    double distanceRange;
    double[] sum;
    double[] sumSquared;
    int[] n;

    public Bins(int bins, double minDistance, double maxDistance) {
        this.bins = bins;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.distanceRange = maxDistance - minDistance;
        this.sum = new double[bins];
        this.sumSquared = new double[bins];
        this.n = new int[bins];
    }

    public void add(int value, double distance) {
        double binDouble;
        int bin;
        if (value > 255) {
            System.out.println("Warning, adding value > 255: " + value);
        }
        if ((bin = (int)Math.floor(binDouble = (double)this.bins * (distance - this.minDistance) / this.distanceRange)) >= this.bins) {
            bin = this.bins - 1;
        }
        int n = bin;
        this.n[n] = this.n[n] + 1;
        int n2 = bin;
        this.sum[n2] = this.sum[n2] + (double)value;
        int n3 = bin;
        this.sumSquared[n3] = this.sumSquared[n3] + (double)(value * value);
    }

    public int numberOfBins() {
        return this.bins;
    }

    public double getMean(int bin) {
        return this.sum[bin] / (double)this.n[bin];
    }

    public double getVariance(int bin) {
        return this.sumSquared[bin] / (double)this.n[bin] - this.sum[bin] * this.sum[bin] / (double)(this.n[bin] * this.n[bin]);
    }

    public double getStandardDeviation(int bin) {
        return Math.sqrt(this.getVariance(bin));
    }

    public double getMinimumInBin(int bin) {
        return (double)bin * this.distanceRange / (double)this.bins;
    }

    public double getMaximumInBin(int bin) {
        return (double)(bin + 1) * this.distanceRange / (double)this.bins;
    }

    public double getMidPointOfBin(int bin) {
        return (this.getMaximumInBin(bin) + this.getMinimumInBin(bin)) / 2.0;
    }

    public int getN(int b) {
        return this.n[b];
    }
}

