/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.app.AppService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.module.ModuleSearchResult;

@Plugin(type=Searcher.class, priority=10000.0)
public class ModuleSearcher
implements Searcher {
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private AppService appService;

    @Override
    public String title() {
        return "Commands";
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        String baseDir = this.appService.getApp().getBaseDirectory().getAbsolutePath();
        LinkedHashSet matches = new LinkedHashSet();
        List modules = this.moduleService.getModules().stream().filter(this::isGoodModule).collect(Collectors.toList());
        String textLower = text.toLowerCase();
        List<String> textLowerParts = Arrays.asList(textLower.split("\\s+"));
        modules.stream().filter(info -> this.startsWith((ModuleInfo)info, textLower)).forEach(matches::add);
        modules.stream().filter(info -> this.hasSubstringInTitle((ModuleInfo)info, textLower)).forEach(matches::add);
        modules.stream().filter(info -> this.hasSubstringInMenu((ModuleInfo)info, textLower)).forEach(matches::add);
        modules.stream().filter(info -> this.hasSubstringsInTitle((ModuleInfo)info, textLowerParts)).forEach(matches::add);
        modules.stream().filter(info -> this.hasSubstringsInMenu((ModuleInfo)info, textLowerParts)).forEach(matches::add);
        return matches.stream().map(info -> new ModuleSearchResult((ModuleInfo)info, baseDir)).collect(Collectors.toList());
    }

    public static String title(ModuleInfo info) {
        MenuEntry menuLeaf;
        String menuName;
        String label = info.getLabel();
        if (label != null && !label.isEmpty()) {
            return label;
        }
        MenuPath menuPath = info.getMenuPath();
        if (menuPath != null && menuPath.size() > 0 && (menuName = (menuLeaf = menuPath.getLeaf()).getName()) != null && !menuName.isEmpty()) {
            return menuName;
        }
        return null;
    }

    public static String iconPath(ModuleInfo info) {
        String iconPath = info.getIconPath();
        if (iconPath != null) {
            return iconPath;
        }
        MenuPath menuPath = info.getMenuPath();
        return menuPath == null || menuPath.getLeaf() == null ? null : menuPath.getLeaf().getIconPath();
    }

    public static String location(ModuleInfo info, String baseDir) {
        String path = info.getLocation();
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:/")) {
            path = path.replaceFirst("file:/+", "/");
        }
        if (baseDir != null && path.startsWith(baseDir)) {
            if (path.length() == baseDir.length()) {
                return "";
            }
            path = path.substring(baseDir.length() + 1);
        }
        return path;
    }

    private boolean isGoodModule(ModuleInfo info) {
        return info.isVisible() && info.isEnabled() && ModuleSearcher.title(info) != null;
    }

    private boolean startsWith(ModuleInfo info, String desiredLower) {
        String title = ModuleSearcher.title(info);
        return title != null && title.toLowerCase().startsWith(desiredLower);
    }

    private boolean hasSubstringInTitle(ModuleInfo info, String desiredLower) {
        String title = ModuleSearcher.title(info);
        return title != null && title.toLowerCase().matches(".*" + desiredLower + ".*");
    }

    private boolean hasSubstringsInTitle(ModuleInfo info, List<String> desiredLower) {
        String title = ModuleSearcher.title(info);
        if (title == null) {
            return false;
        }
        return desiredLower.stream().allMatch(part -> title.toLowerCase().contains((CharSequence)part));
    }

    private boolean hasSubstringInMenu(ModuleInfo info, String desiredLower) {
        MenuPath menuPath = info.getMenuPath();
        if (menuPath == null) {
            return false;
        }
        return menuPath.stream().anyMatch(entry -> entry.getName().toLowerCase().contains(desiredLower));
    }

    private boolean hasSubstringsInMenu(ModuleInfo info, List<String> desiredLower) {
        MenuPath menuPath = info.getMenuPath();
        if (menuPath == null) {
            return false;
        }
        return desiredLower.stream().allMatch(part -> menuPath.stream().anyMatch(entry -> entry.getName().toLowerCase().contains((CharSequence)part)));
    }
}

