/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.ThreadedLoader;
import ij.IJ;
import ij.measure.ResultsTable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

class MyIO {
    MyIO() {
    }

    void loadTransformation(String filename, ResultsTable res) {
        try {
            String line;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            if (!br.readLine().equals(" \tZ-Step\tRaw Width minus Heigh\tCalibration Width minus Height")) {
                IJ.error((String)"File does not seam to be an Astigmatism calibration file");
                return;
            }
            int counter = 1;
            res.reset();
            while ((line = br.readLine()) != null) {
                IJ.showStatus((String)("Loading element " + counter + "... sit back and relax."));
                ++counter;
                line.trim();
                String[] elements = line.split("\t");
                res.incrementCounter();
                res.addValue("Z-Step", Double.parseDouble(elements[1]));
                res.addValue("Raw Width minus Heigh", Double.parseDouble(elements[2]));
                res.addValue("Calibration Width minus Height", Double.parseDouble(elements[3]));
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }

    void loadParticleResults(String filename, ResultsTable res) {
        try {
            String line;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String header = " \tIntensity\tX (px)\tY (px)\tX (nm)\tY (nm)\tZ (nm)\tLeft-Width(px)\tRight-Width (px)\tUp-Height (px)\tDown-Height (px)\tX Symmetry (%)\tY Symmetry (%)\tWidth minus Height (px)\tFrame Number";
            String firstline = br.readLine();
            if (!firstline.contains("X (px)\tY (px)\tX (nm)\tY (nm)\tZ (nm)")) {
                IJ.error((String)"File does not seam to be a Particles Table file");
                IJ.log((String)("Found header: " + firstline));
                IJ.log((String)("Expecting: " + header));
                return;
            }
            res.reset();
            int counter = 1;
            ReentrantLock lock = new ReentrantLock();
            ThreadedLoader tloader = new ThreadedLoader();
            while ((line = br.readLine()) != null) {
                tloader = new ThreadedLoader();
                tloader.mysetup(res, lock, line);
                tloader.start();
                IJ.showStatus((String)("Loading particle " + counter + "... sit back and relax."));
                ++counter;
            }
            try {
                tloader.join();
            }
            catch (Exception e) {
                IJ.error((String)("" + e));
            }
            if (res.getCounter() < 5000000) {
                IJ.showStatus((String)"Creating particle table, this should take a few seconds...");
                res.show("Results");
            } else {
                IJ.showMessage((String)"Warning", (String)"Results table has too many particles, they will not be shown but the data still exists within it\nyou can still use all the plugin functionality or save table changes though the 'Save Particle Table' command.");
            }
            fr.close();
            IJ.showStatus((String)"Done loading table...");
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }
}

