/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;

public abstract class GenericSolver
implements Optimisation.Solver {
    public final Optimisation.Options options;
    private final AtomicInteger myIterationsCount = new AtomicInteger(0);
    private long myResetTime;
    private Optimisation.State myState = Optimisation.State.UNEXPLORED;

    private GenericSolver() {
        this(new Optimisation.Options());
    }

    protected GenericSolver(Optimisation.Options solverOptions) {
        ProgrammingError.throwIfNull((Object)solverOptions);
        this.options = solverOptions;
    }

    protected Optimisation.Result buildResult() {
        MatrixStore<Double> tmpSolution = this.extractSolution();
        double tmpValue = this.evaluateFunction(tmpSolution);
        Optimisation.State tmpState = this.getState();
        return new Optimisation.Result(tmpState, tmpValue, tmpSolution);
    }

    protected final int countIterations() {
        return this.myIterationsCount.get();
    }

    protected final long countTime() {
        return System.currentTimeMillis() - this.myResetTime;
    }

    protected final void error(String messagePattern, Object ... arguments) {
        BasicLogger.error(messagePattern, arguments);
    }

    protected abstract double evaluateFunction(Access1D<?> var1);

    protected abstract MatrixStore<Double> extractSolution();

    protected final Optimisation.State getState() {
        return this.myState;
    }

    protected final int incrementIterationsCount() {
        return this.myIterationsCount.incrementAndGet();
    }

    protected final boolean isDebug() {
        return this.options.logger_detailed && this.isProgress();
    }

    protected final boolean isIterationAllowed() {
        return this.countTime() < this.options.time_abort && this.countIterations() < this.options.iterations_abort;
    }

    protected final boolean isProgress() {
        return this.options.logger_appender != null && this.options.logger_solver.isAssignableFrom(this.getClass());
    }

    protected final void log(String descripttion, Access2D<?> matrix) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.printmtrx(descripttion, matrix, this.options.print);
        }
    }

    protected final void log(String messagePattern, Object ... arguments) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.println(messagePattern, arguments);
        }
    }

    protected final void resetIterationsCount() {
        this.myIterationsCount.set(0);
        this.myResetTime = System.currentTimeMillis();
    }

    protected final void setState(Optimisation.State aState) {
        this.myState = aState;
    }

    public static abstract class Builder<B extends Builder<?, ?>, S extends GenericSolver> {
        protected Builder() {
        }

        public final S build() {
            return this.doBuild(new Optimisation.Options());
        }

        public final S build(Optimisation.Options options) {
            ProgrammingError.throwIfNull((Object)options);
            return this.doBuild(options);
        }

        public abstract int countConstraints();

        public abstract int countVariables();

        protected abstract S doBuild(Optimisation.Options var1);
    }
}

