/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.keyvalue;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.keyvalue.KeyValue;

public final class IntToDouble
implements KeyValue<Integer, Double> {
    public final int key;
    public final double value;

    public IntToDouble(int aKey, double aValue) {
        this.key = aKey;
        this.value = aValue;
    }

    public IntToDouble(int aKey, Double aValue) {
        this.key = aKey;
        this.value = aValue != null ? aValue : PrimitiveMath.ZERO;
    }

    public IntToDouble(Integer aKey, double aValue) {
        this.key = aKey != null ? aKey : 0;
        this.value = aValue;
    }

    public IntToDouble(Integer aKey, Double aValue) {
        this.key = aKey != null ? aKey : 0;
        this.value = aValue != null ? aValue : PrimitiveMath.ZERO;
    }

    IntToDouble() {
        this(0, PrimitiveMath.ZERO);
    }

    @Override
    public int compareTo(IntToDouble aReference) {
        return this.key < aReference.key ? -1 : (this.key == aReference.key ? 0 : 1);
    }

    @Override
    public int compareTo(KeyValue<Integer, ?> aReference) {
        return NumberContext.compare(this.key, aReference.getKey().intValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntToDouble)) {
            return false;
        }
        IntToDouble other = (IntToDouble)obj;
        return this.key == other.key;
    }

    @Override
    public Integer getKey() {
        return this.key;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key;
        return result;
    }

    public String toString() {
        return String.valueOf(this.key) + String.valueOf('=') + String.valueOf(this.value);
    }
}

