/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.Transcaler;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;

public abstract class TiledView {
    private Tile _tile;
    private Projector _bhp = null;
    private Projector _bvp = null;

    public abstract void paint(Graphics2D var1);

    public Tile getTile() {
        return this._tile;
    }

    public Projector getHorizontalProjector() {
        return this._tile != null ? this._tile.getHorizontalProjector() : null;
    }

    public Projector getVerticalProjector() {
        return this._tile != null ? this._tile.getVerticalProjector() : null;
    }

    public Transcaler getTranscaler() {
        return this._tile != null ? this._tile.getTranscaler() : null;
    }

    protected void setBestProjectors(Projector bhp, Projector bvp) {
        if (!this.equal(this._bhp, bhp) || !this.equal(this._bvp, bvp)) {
            this._bhp = bhp != null ? new Projector(bhp) : null;
            Projector projector = this._bvp = bvp != null ? new Projector(bvp) : null;
            if (this._tile != null) {
                this._tile.alignProjectors();
            }
        }
    }

    protected Projector getBestHorizontalProjector() {
        return this._bhp;
    }

    protected Projector getBestVerticalProjector() {
        return this._bvp;
    }

    protected void repaint() {
        if (this._tile != null) {
            this._tile.repaint();
        }
    }

    protected float getLineWidth(Graphics2D g2d) {
        float lineWidth = 1.0f;
        Stroke stroke = g2d.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            lineWidth = bs.getLineWidth();
        }
        return lineWidth;
    }

    void setTile(Tile tile) {
        this._tile = tile;
    }

    private boolean equal(Projector a, Projector b) {
        return a == null ? b == null : a.equals(b);
    }
}

