/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.InfoTreeGenerator;

public class DefaultInfoTreeGenerator
implements InfoTreeGenerator {
    @Override
    public InfoTree generate(OpEnvironment env, String signature, Map<String, OpInfo> idMap, Collection<InfoTreeGenerator> generators) {
        int dependencyStart = signature.indexOf(InfoTree.DEP_START_DELIM.charValue());
        int dependencyEnd = signature.lastIndexOf(InfoTree.DEP_END_DELIM.charValue());
        String infoID = signature.substring(0, dependencyStart);
        OpInfo info = idMap.get(infoID);
        if (info == null) {
            throw new IllegalArgumentException("Could not find an OpInfo corresponding to id " + infoID);
        }
        String dependencySignature = signature.substring(dependencyStart + 1, dependencyEnd);
        List<String> dependencies = this.getDependencies(dependencySignature);
        ArrayList<InfoTree> dependencyTrees = new ArrayList<InfoTree>();
        for (String dep : dependencies) {
            dependencyTrees.add(InfoTreeGenerator.generateDependencyTree(env, dep, idMap, generators));
        }
        return new InfoTree(info, dependencyTrees);
    }

    private List<String> getDependencies(String signature) {
        int parenDepth = 0;
        int start = 0;
        ArrayList<String> splits = new ArrayList<String>();
        for (int i = 0; i < signature.length(); ++i) {
            char ch = signature.charAt(i);
            if (ch == InfoTree.DEP_START_DELIM.charValue()) {
                ++parenDepth;
                continue;
            }
            if (ch != InfoTree.DEP_END_DELIM.charValue() || --parenDepth != 0) continue;
            splits.add(signature.substring(start, i + 1));
            start = i + 1;
        }
        return splits;
    }

    @Override
    public boolean canGenerate(String signature) {
        return signature.startsWith("|Info:");
    }
}

