/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.adapt;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.scijava.common3.Any;
import org.scijava.common3.Types;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.api.Ops;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.ops.engine.OpDependencyMember;
import org.scijava.ops.engine.matcher.MatchingRoutine;
import org.scijava.ops.engine.matcher.OpCandidate;
import org.scijava.ops.engine.matcher.OpMatcher;
import org.scijava.ops.engine.matcher.adapt.OpAdaptationInfo;
import org.scijava.ops.engine.matcher.impl.DefaultOpRequest;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.ItemIO;
import org.scijava.types.Nil;
import org.scijava.types.infer.GenericAssignability;

public class AdaptationMatchingRoutine
implements MatchingRoutine {
    @Override
    public void checkSuitability(MatchingConditions conditions) throws OpMatchingException {
        if (conditions.hints().containsAny(new String[]{"adaptation.IN_PROGRESS", "adaptation.FORBIDDEN"})) {
            throw new OpMatchingException("Adaptation is not suitable: Adaptation is disabled");
        }
    }

    @Override
    public OpCandidate findMatch(MatchingConditions conditions, OpMatcher matcher, OpEnvironment env) throws OpMatchingException {
        Hints adaptationHints = conditions.hints().plus(new String[]{"adaptation.IN_PROGRESS", "history.IGNORE"});
        ArrayList<Throwable> matchingExceptions = new ArrayList<Throwable>();
        for (OpInfo adaptor : env.infos("engine.adapt")) {
            HashMap map;
            Type adaptTo = adaptor.output().type();
            if (!this.adaptOpOutputSatisfiesReqTypes(adaptTo, map = new HashMap(), conditions.request()) || Types.isInstance((Object)adaptor.opType(), Function.class)) continue;
            try {
                Type adaptFrom = (Type)adaptor.inputTypes().get(0);
                Type srcOpType = Types.unroll((Type)adaptFrom, map);
                OpRequest srcOpRequest = this.inferOpRequest(srcOpType, conditions.request().name(), map);
                OpCandidate srcCandidate = matcher.match(MatchingConditions.from(srcOpRequest, adaptationHints), env);
                this.captureTypeVarsFromCandidate(adaptFrom, srcCandidate, map);
                List depTrees = Infos.dependencies(adaptor).stream().map(d -> {
                    OpRequest request = this.inferOpRequest((OpDependencyMember<?>)d, map);
                    Nil type = Nil.of((Type)request.type());
                    Nil[] args = (Nil[])Arrays.stream(request.argTypes()).map(Nil::of).toArray(Nil[]::new);
                    Nil outType = Nil.of((Type)request.outType());
                    Object op = env.op(request.name(), type, args, outType, adaptationHints);
                    return Ops.infoTree((Object)op);
                }).collect(Collectors.toList());
                Type adapterOpType = Types.unroll((Type)adaptor.output().type(), map);
                InfoTree adaptorTree = new InfoTree(adaptor, depTrees);
                OpAdaptationInfo adaptedInfo = new OpAdaptationInfo(srcCandidate.opInfo(), adapterOpType, adaptorTree);
                OpCandidate adaptedCandidate = new OpCandidate(env, conditions.request(), adaptedInfo, map);
                adaptedCandidate.setStatus(OpCandidate.StatusCode.MATCH);
                return adaptedCandidate;
            }
            catch (IllegalArgumentException | OpMatchingException e1) {
                matchingExceptions.add(e1);
            }
        }
        OpMatchingException agglomerated = new OpMatchingException("Unable to find an Op adaptation for " + conditions);
        matchingExceptions.forEach(agglomerated::addSuppressed);
        throw agglomerated;
    }

    private void captureTypeVarsFromCandidate(Type adaptorType, OpCandidate candidate, Map<TypeVariable<?>, Type> map) {
        ParameterizedType rawType = Types.parameterize((Class)Types.raw((Type)adaptorType), (Type[])new Type[0]);
        HashMap adaptorBounds = new HashMap();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{rawType}, (Type[])new Type[]{adaptorType}, adaptorBounds);
        Type infoType = Types.superTypeOf((Type)candidate.opInfo().opType(), (Class)Types.raw((Type)adaptorType));
        HashMap infoBounds = new HashMap();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{rawType}, (Type[])new Type[]{infoType}, infoBounds);
        Type candidateType = candidate.getType();
        HashMap candidateBounds = new HashMap();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{rawType}, (Type[])new Type[]{candidateType}, candidateBounds);
        for (TypeVariable typeVariable : adaptorBounds.keySet()) {
            Type adaptorBound = (Type)adaptorBounds.get(typeVariable);
            if (!(adaptorBound instanceof TypeVariable)) continue;
            TypeVariable adaptTV = (TypeVariable)adaptorBound;
            Type candidateBound = (Type)candidateBounds.get(typeVariable);
            if (this.hasAny(candidateBound)) {
                Type infoBound = (Type)infoBounds.get(typeVariable);
                map.put(adaptTV, infoBound);
                continue;
            }
            map.put(adaptTV, candidateBound);
        }
        for (Map.Entry entry : candidate.typeVarAssigns().entrySet()) {
            Type existing;
            TypeVariable key = (TypeVariable)entry.getKey();
            Type value = (Type)entry.getValue();
            if (map.containsKey(key) && Types.isAssignable((Type)(existing = map.get(key)), (Type)value) && !this.hasAny(existing) || this.hasAny(value)) continue;
            map.put(key, value);
        }
    }

    private boolean hasAny(Type t) {
        if (Any.is((Object)t)) {
            return true;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type arg : pt.getActualTypeArguments()) {
                if (!this.hasAny(arg)) continue;
                return true;
            }
        }
        return false;
    }

    private OpRequest inferOpRequest(OpDependencyMember<?> dependency, Map<TypeVariable<?>, Type> typeVarAssigns) {
        String dependencyName;
        Type mappedDependencyType = Types.unroll((Type[])new Type[]{dependency.type()}, typeVarAssigns)[0];
        OpRequest inferred = this.inferOpRequest(mappedDependencyType, dependencyName = dependency.getDependencyName(), typeVarAssigns);
        if (inferred != null) {
            return inferred;
        }
        throw new OpMatchingException("Could not infer functional method inputs and outputs of Op dependency field: " + dependency.key());
    }

    private boolean adaptOpOutputSatisfiesReqTypes(Type adaptTo, Map<TypeVariable<?>, Type> map, OpRequest request) {
        Type opType = request.type();
        return !(opType instanceof ParameterizedType ? !GenericAssignability.checkGenericAssignability((Type)adaptTo, (ParameterizedType)((ParameterizedType)opType), map, (boolean)true) : !Types.isAssignable((Type)opType, (Type)adaptTo, map));
    }

    private OpRequest inferOpRequest(Type type, String name, Map<TypeVariable<?>, Type> typeVarAssigns) {
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(type);
        if (fmts == null) {
            return null;
        }
        EnumSet<ItemIO> inIos = EnumSet.of(ItemIO.INPUT, ItemIO.CONTAINER, ItemIO.MUTABLE);
        EnumSet<ItemIO> outIos = EnumSet.of(ItemIO.OUTPUT, ItemIO.CONTAINER, ItemIO.MUTABLE);
        Type[] inputs = (Type[])fmts.stream().filter(fmt -> inIos.contains(fmt.itemIO())).map(fmt -> fmt.type()).toArray(Type[]::new);
        Object[] outputs = (Type[])fmts.stream().filter(fmt -> outIos.contains(fmt.itemIO())).map(fmt -> fmt.type()).toArray(Type[]::new);
        Type[] mappedInputs = Types.unroll((Type[])inputs, typeVarAssigns);
        Type[] mappedOutputs = Types.unroll((Type[])outputs, typeVarAssigns);
        int numOutputs = mappedOutputs.length;
        if (numOutputs != 1) {
            String error = "Op '" + name + "' of type " + type + " specifies ";
            error = error + (String)(numOutputs == 0 ? "no outputs" : "multiple outputs: " + Arrays.toString(outputs));
            error = error + ". This is not supported.";
            throw new OpMatchingException(error);
        }
        return new DefaultOpRequest(name, type, mappedOutputs[0], mappedInputs);
    }

    @Override
    public double priority() {
        return -100.0;
    }
}

