/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.reduce;

import com.google.common.collect.Streams;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.matcher.reduce.ReducedOpInfo;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.Member;
import org.scijava.types.infer.FunctionalInterfaces;

public final class ReductionUtils {
    private ReductionUtils() {
    }

    protected static Object javassistOp(Object originalOp, ReducedOpInfo reducedInfo) throws Throwable {
        Class c;
        ClassPool pool = ClassPool.getDefault();
        Module methodModule = originalOp.getClass().getModule();
        Module opsEngine = ReductionUtils.class.getModule();
        opsEngine.addReads(methodModule);
        String className = ReductionUtils.formClassName(reducedInfo);
        try {
            c = pool.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            CtClass cc = ReductionUtils.generateReducedWrapper(pool, className, reducedInfo);
            c = cc.toClass(MethodHandles.lookup());
        }
        return c.getDeclaredConstructor(Types.raw((Type)reducedInfo.srcInfo().opType())).newInstance(originalOp);
    }

    private static String formClassName(ReducedOpInfo reducedInfo) {
        String parameters;
        String packageName = ReductionUtils.getPackageName();
        StringBuilder sb = new StringBuilder(packageName + ".");
        String originalName = ReductionUtils.className(reducedInfo);
        String className = originalName.concat(parameters = ReductionUtils.memberNames(reducedInfo));
        if (className.chars().anyMatch(c -> !Character.isJavaIdentifierPart(c))) {
            throw new IllegalArgumentException(className + " is not a valid class name!");
        }
        sb.append(className);
        return sb.toString();
    }

    private static String getPackageName() {
        return ReductionUtils.class.getPackageName();
    }

    private static String className(ReducedOpInfo reducedInfo) {
        int classStart;
        String implName = reducedInfo.implementationName();
        int parenIndex = implName.indexOf(40);
        if (parenIndex == -1) {
            classStart = implName.lastIndexOf(46) + 1;
        } else {
            int methodStart = implName.substring(0, parenIndex).lastIndexOf(46);
            classStart = implName.substring(0, methodStart).lastIndexOf(46) + 1;
        }
        String originalName = implName.substring(classStart);
        return originalName.replaceAll("[^A-Z^a-z0-9$_]", "_");
    }

    private static String memberNames(ReducedOpInfo reducedInfo) {
        Stream<String> memberNames = Streams.concat((Stream[])new Stream[]{reducedInfo.inputTypes().stream(), Stream.of(reducedInfo.output().type())}).map(type -> ReductionUtils.getClassName(Types.raw((Type)type)));
        Iterable iterableNames = memberNames::iterator;
        return String.join((CharSequence)"_", iterableNames);
    }

    private static String getClassName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.chars().allMatch(c -> Character.isJavaIdentifierPart(c))) {
            return className;
        }
        if (clazz.isArray()) {
            return clazz.getComponentType().getSimpleName() + "_Arr";
        }
        return className;
    }

    private static CtClass generateReducedWrapper(ClassPool pool, String className, ReducedOpInfo reducedInfo) throws Throwable {
        CtClass cc = pool.makeClass(className);
        CtClass jasOpType = pool.get(Types.raw((Type)reducedInfo.opType()).getName());
        cc.addInterface(jasOpType);
        CtField opField = ReductionUtils.createOpField(pool, cc, Types.raw((Type)reducedInfo.srcInfo().opType()), "op");
        cc.addField(opField);
        CtConstructor constructor = CtNewConstructor.make((String)ReductionUtils.createConstructor(cc, reducedInfo), (CtClass)cc);
        cc.addConstructor(constructor);
        CtMethod functionalMethod = CtNewMethod.make((String)ReductionUtils.createFunctionalMethod(reducedInfo), (CtClass)cc);
        cc.addMethod(functionalMethod);
        return cc;
    }

    private static CtField createOpField(ClassPool pool, CtClass cc, Class<?> opType, String fieldName) throws NotFoundException, CannotCompileException {
        CtClass fType = pool.get(opType.getName());
        CtField f = new CtField(fType, fieldName, cc);
        f.setModifiers(18);
        return f;
    }

    private static String createConstructor(CtClass cc, ReducedOpInfo reducedInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("public " + cc.getSimpleName() + "(");
        Class opClass = Types.raw((Type)reducedInfo.srcInfo().opType());
        sb.append(" " + opClass.getName() + " op");
        sb.append(") {");
        sb.append("this.op = op;");
        sb.append("}");
        return sb.toString();
    }

    private static String createFunctionalMethod(ReducedOpInfo info) {
        StringBuilder sb = new StringBuilder();
        Class fIface = FunctionalInterfaces.findFrom((Type)info.opType());
        Method m = FunctionalInterfaces.functionalMethodOf((Type)fIface);
        Class srcFIface = FunctionalInterfaces.findFrom((Type)info.srcInfo().opType());
        Method srcM = FunctionalInterfaces.functionalMethodOf((Type)srcFIface);
        String opOutput = "out";
        sb.append(ReductionUtils.generateSignature(m));
        sb.append(" {");
        if (Infos.hasPureOutput(info)) {
            sb.append("return ");
        }
        sb.append("op." + srcM.getName() + "(");
        List totalArguments = info.srcInfo().inputs();
        int totalArgs = totalArguments.size();
        long totalOptionals = totalArguments.parallelStream().filter(member -> !member.isRequired()).count();
        long neededOptionals = totalOptionals - (long)info.paramsReduced();
        int reducedArg = 0;
        int nullables = 0;
        for (int i = 0; i < totalArgs; ++i) {
            if (((Member)totalArguments.get(i)).isRequired()) {
                sb.append(" in" + reducedArg++);
            } else if ((long)nullables < neededOptionals) {
                sb.append(" in" + reducedArg++);
                ++nullables;
            } else {
                sb.append(" null");
            }
            if (i + 1 >= totalArguments.size()) continue;
            sb.append(",");
        }
        sb.append(");");
        sb.append("}");
        return sb.toString();
    }

    private static int ioArgIndex(OpInfo info) {
        List inputs = info.inputs();
        Optional<Member> ioArg = inputs.stream().filter(m -> m.isInput() && m.isOutput()).findFirst();
        if (ioArg.isEmpty()) {
            return -1;
        }
        Member ioMember = ioArg.get();
        return inputs.indexOf(ioMember);
    }

    private static boolean hasPureOutput(OpInfo info) {
        return ReductionUtils.ioArgIndex(info) == -1;
    }

    private static String generateSignature(Method m) {
        StringBuilder sb = new StringBuilder();
        String methodName = m.getName();
        boolean isVoid = m.getReturnType() == Void.TYPE;
        sb.append("public " + (isVoid ? "void" : "Object") + " " + methodName + "(");
        int inputs = m.getParameterCount();
        for (int i = 0; i < inputs; ++i) {
            sb.append(" Object in" + i);
            if (i >= inputs - 1) continue;
            sb.append(",");
        }
        sb.append(" )");
        return sb.toString();
    }
}

