/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.RetypingRequest;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Member;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;

public class OpResizingMemberParser
implements MemberParser<RetypingRequest, Member<?>> {
    public List<Member<?>> parse(RetypingRequest source, Type structType) {
        List<FunctionalMethodType> newFmts = source.newFmts();
        long numInputs = newFmts.stream().filter(fmt -> fmt.itemIO() == ItemIO.INPUT).count();
        ArrayList newMembers = new ArrayList();
        long inputsAdded = 0L;
        for (Member m : source.struct().members()) {
            if (m.getIOType() == ItemIO.INPUT && ++inputsAdded > numInputs) continue;
            newMembers.add(m);
        }
        return newMembers;
    }

    public List<Member<?>> parse(Struct s, List<FunctionalMethodType> newFmts, Type structType) {
        return this.parse(new RetypingRequest(s, newFmts), structType);
    }
}

