/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ops.engine.exceptions.impl.NullablesOnMultipleMethodsException;
import org.scijava.ops.engine.struct.FieldInstance;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.ParameterData;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.struct.ItemIO;
import org.scijava.types.infer.FunctionalInterfaces;

public class SynthesizedFieldParameterData
implements ParameterData {
    private final FieldInstance fieldInstance;
    private final int numInputs;

    public SynthesizedFieldParameterData(FieldInstance fieldInstance) {
        this.fieldInstance = fieldInstance;
        this.numInputs = FunctionalInterfaces.functionalMethodOf(fieldInstance.field().getType()).getParameterCount();
    }

    @Override
    public List<SynthesizedParameterMember<?>> synthesizeMembers(List<FunctionalMethodType> fmts) {
        Boolean[] optionality = SynthesizedFieldParameterData.getParameterNullability(this.fieldInstance.instance(), this.fieldInstance.field(), this.numInputs);
        List<String> names = this.getParameterNames(fmts);
        int p = 0;
        ArrayList members = new ArrayList(fmts.size());
        for (FunctionalMethodType fmt : fmts) {
            String name = names.get(p);
            boolean optional = fmt.itemIO() != ItemIO.OUTPUT && optionality[p++] != false;
            members.add(new SynthesizedParameterMember(fmt, name, !optional, ""));
        }
        return members;
    }

    private List<String> getParameterNames(List<FunctionalMethodType> fmts) {
        ArrayList<String> fmtNames = new ArrayList<String>(fmts.size());
        int mutables = 1;
        int containers = 1;
        int outs = 1;
        int ins = 1;
        block6: for (FunctionalMethodType fmt : fmts) {
            switch (fmt.itemIO()) {
                case INPUT: {
                    fmtNames.add("input" + ins++);
                    continue block6;
                }
                case OUTPUT: {
                    fmtNames.add("output" + outs++);
                    continue block6;
                }
                case CONTAINER: {
                    fmtNames.add("container" + containers++);
                    continue block6;
                }
                case MUTABLE: {
                    fmtNames.add("mutable" + mutables++);
                    continue block6;
                }
            }
            throw new RuntimeException("Unexpected ItemIO type encountered!");
        }
        return fmtNames;
    }

    private static Boolean[] getParameterNullability(Object instance, Field field, int opParams) {
        Class<?> fieldClass;
        try {
            fieldClass = field.get(instance).getClass();
        }
        catch (IllegalAccessException | IllegalArgumentException exc) {
            throw new IllegalArgumentException(exc);
        }
        List<Method> fMethodsWithNullables = FunctionalParameters.fMethodsWithNullable(fieldClass);
        Class fIface = FunctionalInterfaces.findFrom(fieldClass);
        List<Method> fIfaceMethodsWithNullables = FunctionalParameters.fMethodsWithNullable(fIface);
        if (fMethodsWithNullables.isEmpty() && fIfaceMethodsWithNullables.isEmpty()) {
            return FunctionalParameters.generateAllRequiredArray(opParams);
        }
        if (!fMethodsWithNullables.isEmpty() && !fIfaceMethodsWithNullables.isEmpty()) {
            ArrayList<Method> nullables = new ArrayList<Method>(fMethodsWithNullables);
            nullables.addAll(fIfaceMethodsWithNullables);
            throw new NullablesOnMultipleMethodsException(field, nullables);
        }
        if (fMethodsWithNullables.isEmpty()) {
            return FunctionalParameters.findParameterNullability(fIfaceMethodsWithNullables.get(0));
        }
        if (fIfaceMethodsWithNullables.isEmpty()) {
            return FunctionalParameters.findParameterNullability(fMethodsWithNullables.get(0));
        }
        return FunctionalParameters.generateAllRequiredArray(opParams);
    }
}

