/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

public class SplineFitter {
    private double[] y2;
    private static int EXTEND_BY = 7;
    private int extendBy;
    private float[] xpoints;
    private float[] ypoints;
    private int npoints;
    private int[] ixpoints;
    private int[] iypoints;

    public SplineFitter(int[] x, int[] y, int n) {
        this.initSpline(x, y, n);
    }

    public SplineFitter(float[] x, float[] y, int n, boolean closed) {
        this.initSpline(x, y, n, closed);
    }

    public SplineFitter(float[] x, float[] y, int n) {
        this.initSpline(x, y, n, false);
    }

    private void initSpline(int[] x, int[] y, int n) {
        int j;
        this.y2 = new double[n];
        double[] c_p = new double[n];
        c_p[0] = 0.0;
        this.y2[0] = 0.0;
        c_p[n - 1] = 0.0;
        this.y2[n - 1] = 0.0;
        double new_x = x[1];
        double new_y = y[1];
        double cj = x[1] - x[0];
        double new_dj = (double)(y[1] - y[0]) / cj;
        for (j = 1; j < n - 1; ++j) {
            double old_x = new_x;
            double old_y = new_y;
            double aj = cj;
            double old_dj = new_dj;
            new_x = x[j + 1];
            new_y = y[j + 1];
            cj = new_x - old_x;
            new_dj = (new_y - old_y) / cj;
            double bj = 2.0 * (cj + aj);
            double inv_denom = 1.0 / (bj - aj * c_p[j - 1]);
            double dj = 6.0 * (new_dj - old_dj);
            this.y2[j] = (dj - aj * this.y2[j - 1]) * inv_denom;
            c_p[j] = cj * inv_denom;
        }
        while (j > 0) {
            this.y2[--j] = this.y2[j] - c_p[j] * this.y2[j + 1];
        }
        this.ixpoints = x;
        this.iypoints = y;
        this.npoints = n;
    }

    private void initSpline(float[] x, float[] y, int n, boolean closed) {
        int j;
        if (closed) {
            int i;
            this.extendBy = EXTEND_BY;
            if (this.extendBy >= n) {
                this.extendBy = n - 1;
            }
            int n2 = n + 2 * this.extendBy;
            float[] xx = new float[n2];
            float[] yy = new float[n2];
            for (i = 0; i < this.extendBy; ++i) {
                xx[i] = x[n - (this.extendBy - i + 1)] - x[n - 1];
                yy[i] = y[n - (this.extendBy - i + 1)];
            }
            for (i = this.extendBy; i < this.extendBy + n; ++i) {
                xx[i] = x[i - this.extendBy];
                yy[i] = y[i - this.extendBy];
            }
            for (i = this.extendBy + n; i < n2; ++i) {
                xx[i] = x[i + 1 - (this.extendBy + n)] - x[0] + x[n - 1];
                yy[i] = y[i + 1 - (this.extendBy + n)];
            }
            n = n2;
            x = xx;
            y = yy;
        }
        this.y2 = new double[n];
        double[] c_p = new double[n];
        c_p[0] = 0.0;
        this.y2[0] = 0.0;
        c_p[n - 1] = 0.0;
        this.y2[n - 1] = 0.0;
        double new_x = x[1];
        double new_y = y[1];
        double cj = x[1] - x[0];
        double new_dj = (double)(y[1] - y[0]) / cj;
        for (j = 1; j < n - 1; ++j) {
            double old_x = new_x;
            double old_y = new_y;
            double aj = cj;
            double old_dj = new_dj;
            new_x = x[j + 1];
            new_y = y[j + 1];
            cj = new_x - old_x;
            new_dj = (new_y - old_y) / cj;
            double bj = 2.0 * (cj + aj);
            double inv_denom = 1.0 / (bj - aj * c_p[j - 1]);
            double dj = 6.0 * (new_dj - old_dj);
            this.y2[j] = (dj - aj * this.y2[j - 1]) * inv_denom;
            c_p[j] = cj * inv_denom;
        }
        while (j > 0) {
            this.y2[--j] = this.y2[j] - c_p[j] * this.y2[j + 1];
        }
        this.xpoints = x;
        this.ypoints = y;
        this.npoints = n;
    }

    public double evalSpline(double xp) {
        if (this.xpoints != null) {
            return this.evalSpline(this.xpoints, this.ypoints, this.npoints, xp);
        }
        return this.evalSpline(this.ixpoints, this.iypoints, this.npoints, xp);
    }

    public double evalSpline(int[] x, int[] y, int n, double xp) {
        int ls = 0;
        int rs = n - 1;
        while (rs > 1 + ls) {
            int m = (int)Math.floor(0.5 * (double)(ls + rs));
            if ((double)x[m] < xp) {
                ls = m;
                continue;
            }
            rs = m;
        }
        double ba = x[rs] - x[ls];
        double xa = xp - (double)x[ls];
        double bx = (double)x[rs] - xp;
        double ba2 = ba * ba;
        double lower = xa * (double)y[rs] + bx * (double)y[ls];
        double C = (xa * xa - ba2) * xa * this.y2[rs];
        double D = (bx * bx - ba2) * bx * this.y2[ls];
        return (lower + (C + D) / 6.0) / ba;
    }

    public double evalSpline(float[] x, float[] y, int n, double xp) {
        int ls = 0;
        int rs = n - 1;
        while (rs > 1 + ls) {
            int m = (int)Math.floor(0.5 * (double)(ls + rs));
            if ((double)x[m] < xp) {
                ls = m;
                continue;
            }
            rs = m;
        }
        double ba = x[rs] - x[ls];
        double xa = xp - (double)x[ls];
        double bx = (double)x[rs] - xp;
        double ba2 = ba * ba;
        double lower = xa * (double)y[rs] + bx * (double)y[ls];
        double C = (xa * xa - ba2) * xa * this.y2[rs];
        double D = (bx * bx - ba2) * bx * this.y2[ls];
        return (lower + (C + D) / 6.0) / ba;
    }
}

