/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ops.flim.FitResults;

public class MeanLifetimes {
    public static Img<FloatType> defaultMeanLifetime(FitResults rslt) {
        Img<FloatType> paramMap = rslt.paramMap;
        int nComp = (int)(paramMap.dimension(rslt.ltAxis) - 1L) / 2;
        long[] dim = new long[paramMap.numDimensions() - 1];
        Views.hyperSlice(paramMap, (int)rslt.ltAxis, (long)0L).dimensions(dim);
        ArrayImg tauM = ArrayImgs.floats((long[])dim);
        ArrayImg tauASum = ArrayImgs.floats((long[])dim);
        for (int c = 0; c < nComp; ++c) {
            IntervalView A = Views.hyperSlice(rslt.paramMap, (int)rslt.ltAxis, (long)(c * 2 + 1));
            IntervalView tau = Views.hyperSlice(rslt.paramMap, (int)rslt.ltAxis, (long)(c * 2 + 2));
            LoopBuilder.setImages((RandomAccessibleInterval)tau, (RandomAccessibleInterval)A, (RandomAccessibleInterval)tauM, (RandomAccessibleInterval)tauASum).forEachPixel((t, a, tM, tASum) -> {
                FloatType f = new FloatType();
                f.set(a);
                f.mul(t);
                tASum.add(f);
                f.mul(t);
                tM.add(f);
            });
        }
        FloatType f = new FloatType();
        f.setReal(Float.MIN_VALUE);
        LoopBuilder.setImages((RandomAccessibleInterval)tauASum, (RandomAccessibleInterval)tauM).forEachPixel((tA, tM) -> {
            tA.add(f);
            tM.div(tA);
        });
        return tauM;
    }
}

