/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import bdv.BigDataViewer;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.img.list.ListImg;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.img.list.ListRandomAccess;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.apply.ApplyParameters;
import spim.fiji.plugin.apply.BigDataViewerTransformationWindow;
import spim.fiji.plugin.apply.ModelLink;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;
import spim.process.fusion.boundingbox.BigDataViewerBoundingBox;
import spim.vecmath.Transform3D;

public class Apply_Transformation
implements PlugIn {
    public static boolean defaultSameModelTimePoints = true;
    public static boolean defaultSameModelChannels = true;
    public static boolean defaultSameModelIlluminations = true;
    public static boolean defaultSameModelAngles = true;
    public static int defaultModel = 2;
    public static int defaultDefineAs = 1;
    public static int defaultApplyTo = 2;
    public static String[] applyToChoice = new String[]{"Identity transform (removes any existing transforms)", "Calibration (removes any existing transforms)", "Current view transformations (appends to current transforms)"};
    public static String[] modelChoice = new String[]{"Identity (no transformation)", "Translation", "Rigid", "Affine"};
    public static String[] defineAsChoice = new String[]{"Matrix", "Rotation around axis", "Interactively using the BigDataViewer"};
    public String[] axesChoice = new String[]{"x-axis", "y-axis", "z-axis"};
    public static int[] defaultAxis = null;
    public static double[] defaultDegrees = null;
    public static ArrayList<double[]> defaultModels;

    public void run(String arg0) {
        ArrayList<ViewId> viewIds;
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("applying a transformation", "Apply to", true, true, true, true)) {
            return;
        }
        SpimData2 data = (SpimData2)((Object)result.getData());
        ApplyParameters params = this.queryParams(data, viewIds = SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess()));
        if (params == null) {
            return;
        }
        Map<ViewDescription, Pair<double[], String>> modelLinks = params.defineAs == 0 ? this.queryString(data, viewIds, params) : (params.defineAs == 1 ? this.queryRotationAxis(data, viewIds, params) : this.queryBigDataViewer(data, viewIds, params));
        if (modelLinks == null) {
            return;
        }
        this.applyModels(data, params.minResolution, params.applyTo, modelLinks);
        SpimData2.saveXML((SpimData2)((Object)result.getData()), result.getXMLFileName(), result.getClusterExtension());
    }

    public final ApplyParameters queryParams(SpimData data, List<ViewId> viewIds) {
        ArrayList<Angle> angles = SpimData2.getAllAnglesSorted(data, viewIds);
        ArrayList<Channel> channels = SpimData2.getAllChannelsSorted(data, viewIds);
        ArrayList<Illumination> illums = SpimData2.getAllIlluminationsSorted(data, viewIds);
        ArrayList<TimePoint> tps = SpimData2.getAllTimePointsSorted(data, viewIds);
        boolean multipleTimePoints = tps.size() > 1;
        boolean multipleChannels = channels.size() > 1;
        boolean multipleIlluminations = illums.size() > 1;
        boolean multipleAngles = angles.size() > 1;
        GenericDialog gd = new GenericDialog("Choose transformation model");
        gd.addChoice("Transformation model", modelChoice, modelChoice[defaultModel]);
        gd.addChoice("Apply on top of", applyToChoice, applyToChoice[defaultApplyTo]);
        if (multipleTimePoints) {
            gd.addCheckbox("Same_transformation_for_all_timepoints", defaultSameModelTimePoints);
        }
        if (multipleChannels) {
            gd.addCheckbox("Same_transformation_for_all_channels", defaultSameModelChannels);
        }
        if (multipleIlluminations) {
            gd.addCheckbox("Same_transformation_for_all_illuminations", defaultSameModelIlluminations);
        }
        if (multipleAngles) {
            gd.addCheckbox("Same_transformation_for_all_angles", defaultSameModelAngles);
        }
        gd.addMessage("Interactive application of transformations using the BigDataViewer is available when selecting a Rigid Model.", GUIHelper.mediumstatusfont);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        ApplyParameters params = new ApplyParameters();
        params.model = defaultModel = gd.getNextChoiceIndex();
        params.applyTo = defaultApplyTo = gd.getNextChoiceIndex();
        if (params.model == 2) {
            GenericDialog gd2 = new GenericDialog("Choose application for transformation model");
            gd2.addChoice("Define as", defineAsChoice, defineAsChoice[defaultDefineAs]);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return null;
            }
            params.defineAs = defaultDefineAs = gd2.getNextChoiceIndex();
        } else {
            params.defineAs = 0;
        }
        params.sameModelTimePoints = multipleTimePoints ? (defaultSameModelTimePoints = gd.getNextBoolean()) : true;
        params.sameModelChannels = multipleChannels ? (defaultSameModelChannels = gd.getNextBoolean()) : true;
        params.sameModelIlluminations = multipleIlluminations ? (defaultSameModelIlluminations = gd.getNextBoolean()) : true;
        params.sameModelAngles = multipleAngles ? (defaultSameModelAngles = gd.getNextBoolean()) : true;
        if (params.applyTo == 1) {
            params.minResolution = Apply_Transformation.assembleAllMetaData((SequenceDescription)data.getSequenceDescription(), viewIds);
            if (Double.isNaN(params.minResolution)) {
                IOFunctions.println("Could not assemble the calibration, quitting.");
                return null;
            }
        } else {
            params.minResolution = 1.0;
        }
        return params;
    }

    public Map<ViewDescription, Pair<double[], String>> queryBigDataViewer(SpimData data, List<ViewId> viewIds, ApplyParameters params) {
        if (!(params.sameModelAngles && params.sameModelChannels && params.sameModelIlluminations && params.sameModelIlluminations)) {
            IOFunctions.println("You selected to not have the same transformation model for all views in the");
            IOFunctions.println("previous dialog. This is not supported using the interactive setup using the");
            IOFunctions.println("BigDataViewer. You can select single views in the xml open dialog though.");
            return null;
        }
        try {
            Pair<BigDataViewer, Boolean> bdvPair = BigDataViewerBoundingBox.getBDV(data, viewIds);
            if (bdvPair == null || bdvPair.getA() == null) {
                return null;
            }
            BigDataViewerTransformationWindow bdvw = new BigDataViewerTransformationWindow((BigDataViewer)bdvPair.getA());
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (bdvw.isRunning());
            if (((Boolean)bdvPair.getB()).booleanValue()) {
                BigDataViewerTransformationWindow.disposeViewerWindow((BigDataViewer)bdvPair.getA());
            }
            if (bdvw.wasCancelled()) {
                return null;
            }
            HashMap<ViewDescription, Pair<double[], String>> modelLinks = new HashMap<ViewDescription, Pair<double[], String>>();
            AffineTransform3D t = bdvw.getTransform();
            double[] m = t.getRowPackedCopy();
            String d = "Rigid transform defined by BigDataViewer";
            defaultModels = new ArrayList();
            defaultModels.add(m);
            for (ViewId viewId : viewIds) {
                ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
                modelLinks.put(vd, (Pair<double[], String>)new ValuePair((Object)m, (Object)"Rigid transform defined by BigDataViewer"));
            }
            return modelLinks;
        }
        catch (Exception e) {
            IOFunctions.println("Failed to run the BigDataViewer ... ");
            e.printStackTrace();
            return null;
        }
    }

    public Map<ViewDescription, Pair<double[], String>> queryRotationAxis(SpimData data, List<ViewId> viewIds, ApplyParameters params) {
        if (params.model != 2) {
            IOFunctions.println("No rigid model selected.");
            return null;
        }
        HashMap<TimePoint, Integer> mapT = new HashMap<TimePoint, Integer>();
        HashMap<Channel, Integer> mapC = new HashMap<Channel, Integer>();
        HashMap<Illumination, Integer> mapI = new HashMap<Illumination, Integer>();
        HashMap<Angle, Integer> mapA = new HashMap<Angle, Integer>();
        ListImg<ModelLink> img = Apply_Transformation.createTable(data, viewIds, params.sameModelTimePoints, params.sameModelChannels, params.sameModelIlluminations, params.sameModelAngles, mapT, mapC, mapI, mapA);
        ListRandomAccess ra = img.randomAccess();
        int[] l = new int[img.numDimensions()];
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            Apply_Transformation.locationForViewDescription(l, vd, mapT, mapC, mapI, mapA);
            ra.setPosition(l);
            if (ra.get() == null) {
                ra.set((Object)new ModelLink(vd));
                continue;
            }
            ((ModelLink)ra.get()).add(vd);
        }
        int numEntries = Apply_Transformation.numEntries(img);
        IOFunctions.println("Querying " + numEntries + " different rotation axis models.");
        if (defaultAxis == null || defaultDegrees == null || defaultAxis.length != numEntries || defaultDegrees.length != numEntries) {
            defaultAxis = new int[numEntries];
            defaultDegrees = new double[numEntries];
            int j = 0;
            for (Object ml : img) {
                if (ml == null) continue;
                Apply_Transformation.defaultDegrees[j] = 0.0;
                Apply_Transformation.defaultAxis[j] = 0;
                try {
                    Angle a = ((ViewSetup)((ModelLink)ml).viewDescriptions().get(0).getViewSetup()).getAngle();
                    double[] axis = a.getRotationAxis();
                    if (axis != null) {
                        if (axis[0] == 1.0 && axis[1] == 0.0 && axis[2] == 0.0) {
                            Apply_Transformation.defaultAxis[j] = 0;
                        } else if (axis[0] == 0.0 && axis[1] == 1.0 && axis[2] == 0.0) {
                            Apply_Transformation.defaultAxis[j] = 1;
                        } else if (axis[0] == 0.0 && axis[1] == 0.0 && axis[2] == 2.0) {
                            Apply_Transformation.defaultAxis[j] = 2;
                        }
                    }
                    Apply_Transformation.defaultDegrees[j] = !Double.isNaN(a.getRotationAngleDegrees()) ? a.getRotationAngleDegrees() : Double.parseDouble(a.getName());
                }
                catch (Exception a) {
                    // empty catch block
                }
                ++j;
            }
        }
        GenericDialog gd = new GenericDialog("Parameters for rigid model 3d");
        int j = 0;
        for (ModelLink ml : img) {
            if (ml == null) continue;
            gd.addChoice("Axis_" + ml.dialogName(), this.axesChoice, this.axesChoice[defaultAxis[j]]);
            gd.addSlider("Rotation_" + ml.dialogName(), -360.0, 360.0, defaultDegrees[j]);
            ++j;
        }
        if (numEntries > 5) {
            GUIHelper.addScrollBars((Container)gd);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        HashMap<ViewDescription, Pair<double[], String>> modelLinks = new HashMap<ViewDescription, Pair<double[], String>>();
        defaultModels = new ArrayList();
        int[] axes = new int[numEntries];
        double[] degrees = new double[numEntries];
        double[] tmp = new double[16];
        j = 0;
        for (ModelLink ml : img) {
            String d;
            if (ml == null) continue;
            axes[j] = gd.getNextChoiceIndex();
            degrees[j] = gd.getNextNumber();
            Transform3D t = new Transform3D();
            if (axes[j] == 0) {
                t.rotX(Math.toRadians(degrees[j]));
                d = "Rotation around x-axis by " + degrees[j] + " degrees";
            } else if (axes[j] == 1) {
                t.rotY(Math.toRadians(degrees[j]));
                d = "Rotation around y-axis by " + degrees[j] + " degrees";
            } else {
                t.rotZ(Math.toRadians(degrees[j]));
                d = "Rotation around z-axis by " + degrees[j] + " degrees";
            }
            t.get(tmp);
            double[] m = new double[]{tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5], tmp[6], tmp[7], tmp[8], tmp[9], tmp[10], tmp[11]};
            defaultModels.add(m);
            ml.setModel(m, d);
            for (ViewDescription vd : ml.viewDescriptions()) {
                modelLinks.put(vd, (Pair<double[], String>)new ValuePair((Object)ml.model(), (Object)ml.modelDescription()));
            }
        }
        defaultAxis = axes;
        defaultDegrees = degrees;
        return modelLinks;
    }

    public Map<ViewDescription, Pair<double[], String>> queryString(SpimData data, List<ViewId> viewIds, ApplyParameters params) {
        double[] m;
        GenericDialog gd;
        HashMap<TimePoint, Integer> mapT = new HashMap<TimePoint, Integer>();
        HashMap<Channel, Integer> mapC = new HashMap<Channel, Integer>();
        HashMap<Illumination, Integer> mapI = new HashMap<Illumination, Integer>();
        HashMap<Angle, Integer> mapA = new HashMap<Angle, Integer>();
        ListImg<ModelLink> img = Apply_Transformation.createTable(data, viewIds, params.sameModelTimePoints, params.sameModelChannels, params.sameModelIlluminations, params.sameModelAngles, mapT, mapC, mapI, mapA);
        ListRandomAccess ra = img.randomAccess();
        int[] l = new int[img.numDimensions()];
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            Apply_Transformation.locationForViewDescription(l, vd, mapT, mapC, mapI, mapA);
            ra.setPosition(l);
            if (ra.get() == null) {
                ra.set((Object)new ModelLink(vd));
                continue;
            }
            ((ModelLink)ra.get()).add(vd);
        }
        int numEntries = Apply_Transformation.numEntries(img);
        IOFunctions.println("Querying " + numEntries + " different transformation models.");
        if (defaultModels == null || defaultModels.size() == 0 || defaultModels.size() != numEntries) {
            defaultModels = new ArrayList();
            for (int i = 0; i < numEntries; ++i) {
                defaultModels.add(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0});
            }
        }
        if (params.model == 0) {
            gd = null;
        } else if (params.model == 1) {
            gd = new GenericDialog("Model parameters for translation model 3d");
            gd.addMessage("t(x) = m03, t(y) = m13, t(z) = m23");
            gd.addMessage("");
            gd.addMessage("Please provide 3d translation in this form (any brackets will be ignored): m03, m13, m23");
            int j = 0;
            for (ModelLink ml : img) {
                if (ml == null) continue;
                gd.addStringField(ml.dialogName(), defaultModels.get(j)[3] + ", " + defaultModels.get(j)[7] + ", " + defaultModels.get(j++)[11], 30);
            }
        } else {
            gd = new GenericDialog("Model parameters for rigid/affine model 3d");
            gd.addMessage("| m00 m01 m02 m03 |\n| m10 m11 m12 m13 |\n| m20 m21 m22 m23 |");
            gd.addMessage("Please provide 3d rigid/affine in this form (any brackets will be ignored):\nm00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23");
            int j = 0;
            for (ModelLink ml : img) {
                if (ml == null) continue;
                m = defaultModels.get(j++);
                gd.addStringField(ml.dialogName(), m[0] + ", " + m[1] + ", " + m[2] + ", " + m[3] + ", " + m[4] + ", " + m[5] + ", " + m[6] + ", " + m[7] + ", " + m[8] + ", " + m[9] + ", " + m[10] + ", " + m[11], 80);
            }
        }
        if (gd != null) {
            if (numEntries > 10) {
                GUIHelper.addScrollBars((Container)gd);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
        }
        HashMap<ViewDescription, Pair<double[], String>> modelLinks = new HashMap<ViewDescription, Pair<double[], String>>();
        defaultModels = new ArrayList();
        for (ModelLink ml : img) {
            String d;
            if (ml == null) continue;
            if (params.model == 0) {
                m = null;
                d = "Identity";
            } else if (params.model == 1) {
                double[] v = Apply_Transformation.parseString(gd.getNextString(), 3);
                if (v == null) {
                    return null;
                }
                m = new double[]{1.0, 0.0, 0.0, v[0], 0.0, 1.0, 0.0, v[1], 0.0, 0.0, 1.0, v[2]};
                d = "Translation [" + v[0] + "," + v[1] + "," + v[2] + "]";
            } else {
                m = Apply_Transformation.parseString(gd.getNextString(), 12);
                if (m == null) {
                    return null;
                }
                d = "Rigid/Affine by matrix";
            }
            if (m == null) {
                defaultModels.add(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0});
            } else {
                defaultModels.add(m);
            }
            ml.setModel(m, d);
            for (ViewDescription vd : ml.viewDescriptions()) {
                modelLinks.put(vd, (Pair<double[], String>)new ValuePair((Object)ml.model(), (Object)ml.modelDescription()));
            }
        }
        return modelLinks;
    }

    public void applyModels(SpimData spimData, double minResolution, int applyTo, Map<ViewDescription, Pair<double[], String>> modelLinks) {
        for (ViewDescription vd : modelLinks.keySet()) {
            double[] v = (double[])modelLinks.get(vd).getA();
            String modelDesc = (String)modelLinks.get(vd).getB();
            TimePoint t = vd.getTimePoint();
            Channel c = ((ViewSetup)vd.getViewSetup()).getChannel();
            Illumination i = ((ViewSetup)vd.getViewSetup()).getIllumination();
            Angle a = ((ViewSetup)vd.getViewSetup()).getAngle();
            if (applyTo == 0) {
                IOFunctions.println("Reseting model to identity transform for timepoint " + t.getName() + ", channel " + c.getName() + ", illum " + i.getName() + ", angle " + a.getName());
                Apply_Transformation.setModelToIdentity(spimData, (ViewId)vd);
            } else if (applyTo == 1) {
                IOFunctions.println("Reseting model to calibration for timepoint " + t.getName() + ", channel " + c.getName() + ", illum " + i.getName() + ", angle " + a.getName());
                Apply_Transformation.setModelToCalibration(spimData, (ViewId)vd, minResolution);
            }
            if (v == null) continue;
            IOFunctions.println("Applying model " + Util.printCoordinates((double[])v) + " (" + modelDesc + ") to timepoint " + t.getName() + ", channel " + c.getName() + ", illum " + i.getName() + ", angle " + a.getName());
            AffineTransform3D model = new AffineTransform3D();
            model.set(v);
            Apply_Transformation.preConcatenateTransform(spimData, (ViewId)vd, model, "Manually defined transformation (" + modelDesc + ")");
        }
    }

    private static final void locationForViewDescription(int[] l, ViewDescription vd, HashMap<TimePoint, Integer> mapT, HashMap<Channel, Integer> mapC, HashMap<Illumination, Integer> mapI, HashMap<Angle, Integer> mapA) {
        TimePoint t = vd.getTimePoint();
        Channel c = ((ViewSetup)vd.getViewSetup()).getChannel();
        Illumination i = ((ViewSetup)vd.getViewSetup()).getIllumination();
        Angle a = ((ViewSetup)vd.getViewSetup()).getAngle();
        l[0] = mapA.get(a);
        l[1] = mapI.get(i);
        l[2] = mapC.get(c);
        l[3] = mapT.get(t);
    }

    private static final int numEntries(ListImg<ModelLink> img) {
        int numEntries = 0;
        for (ModelLink l : img) {
            if (l == null) continue;
            ++numEntries;
        }
        return numEntries;
    }

    private static final ListImg<ModelLink> createTable(SpimData data, List<ViewId> viewIds, boolean sameModelTimePoints, boolean sameModelChannels, boolean sameModelIlluminations, boolean sameModelAngles, HashMap<TimePoint, Integer> mapT, HashMap<Channel, Integer> mapC, HashMap<Illumination, Integer> mapI, HashMap<Angle, Integer> mapA) {
        ArrayList<TimePoint> ts = SpimData2.getAllTimePointsSorted(data, viewIds);
        ArrayList<Channel> cs = SpimData2.getAllChannelsSorted(data, viewIds);
        ArrayList<Illumination> is = SpimData2.getAllIlluminationsSorted(data, viewIds);
        ArrayList<Angle> as = SpimData2.getAllAnglesSorted(data, viewIds);
        int nT = sameModelTimePoints ? 1 : ts.size();
        for (int i = 0; i < ts.size(); ++i) {
            mapT.put((TimePoint)ts.get(i), sameModelTimePoints ? 0 : i);
        }
        int nC = sameModelChannels ? 1 : cs.size();
        for (int i = 0; i < cs.size(); ++i) {
            mapC.put((Channel)cs.get(i), sameModelChannels ? 0 : i);
        }
        int nI = sameModelIlluminations ? 1 : is.size();
        for (int i = 0; i < is.size(); ++i) {
            mapI.put((Illumination)is.get(i), sameModelIlluminations ? 0 : i);
        }
        int nA = sameModelAngles ? 1 : as.size();
        for (int i = 0; i < as.size(); ++i) {
            mapA.put((Angle)as.get(i), sameModelAngles ? 0 : i);
        }
        return new ListImgFactory().create(new long[]{nA, nI, nC, nT}, (Object)new ModelLink(null));
    }

    protected static final double[] parseString(String entry, int numValues) {
        while (entry.contains("(")) {
            entry.replace("(", "");
        }
        while (entry.contains(")")) {
            entry.replace(")", "");
        }
        while (entry.contains("[")) {
            entry.replace("[", "");
        }
        while (entry.contains("]")) {
            entry.replace("]", "");
        }
        String[] entries = (entry = entry.replaceAll(" ", "").trim()).split(",");
        if (entries.length != numValues) {
            IOFunctions.println("Cannot parse: '" + entry + "', has " + entries.length + " numbers, but should be " + numValues);
            return null;
        }
        double[] v = new double[numValues];
        for (int j = 0; j < numValues; ++j) {
            v[j] = Double.parseDouble(entries[j].trim());
        }
        return v;
    }

    public static void preConcatenateTransform(SpimData spimData, ViewId viewId, AffineTransform3D model, String name) {
        ViewRegistrations viewRegistrations = spimData.getViewRegistrations();
        ViewRegistration vr = viewRegistrations.getViewRegistration(viewId);
        ViewTransformAffine vt = new ViewTransformAffine(name, model);
        vr.preconcatenateTransform((ViewTransform)vt);
    }

    public static void setModelToCalibration(SpimData spimData, ViewId viewId, double minResolution) {
        Apply_Transformation.setModelToIdentity(spimData, viewId);
        ViewRegistrations viewRegistrations = spimData.getViewRegistrations();
        ViewRegistration r = viewRegistrations.getViewRegistration(viewId);
        ViewDescription viewDescription = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
        VoxelDimensions voxelSize = ViewSetupUtils.getVoxelSizeOrLoad(viewDescription.getViewSetup(), viewDescription.getTimePoint(), (ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader());
        double calX = voxelSize.dimension(0) / minResolution;
        double calY = voxelSize.dimension(1) / minResolution;
        double calZ = voxelSize.dimension(2) / minResolution;
        AffineTransform3D m = new AffineTransform3D();
        m.set(calX, 0.0, 0.0, 0.0, 0.0, calY, 0.0, 0.0, 0.0, 0.0, calZ, 0.0);
        ViewTransformAffine vt = new ViewTransformAffine("calibration", m);
        r.preconcatenateTransform((ViewTransform)vt);
    }

    public static void setModelToIdentity(SpimData spimData, ViewId viewId) {
        ViewRegistrations viewRegistrations = spimData.getViewRegistrations();
        ViewRegistration r = viewRegistrations.getViewRegistration(viewId);
        r.identity();
    }

    public static double assembleAllMetaData(SequenceDescription sequenceDescription, Collection<? extends ViewId> viewIdsToProcess) {
        double minResolution = Double.MAX_VALUE;
        for (ViewId viewId : viewIdsToProcess) {
            VoxelDimensions voxelSize;
            ViewDescription vd = sequenceDescription.getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
            if (!vd.isPresent()) continue;
            ViewSetup setup = (ViewSetup)vd.getViewSetup();
            if (!setup.hasVoxelSize()) {
                voxelSize = ((ImgLoader)sequenceDescription.getImgLoader()).getSetupImgLoader(viewId.getViewSetupId()).getVoxelSize(viewId.getTimePointId());
                if (voxelSize == null) {
                    IOFunctions.println("An error occured. Cannot load calibration for timepoint: " + vd.getTimePoint().getName() + " angle: " + ((ViewSetup)vd.getViewSetup()).getAngle().getName() + " channel: " + ((ViewSetup)vd.getViewSetup()).getChannel().getName() + " illum: " + ((ViewSetup)vd.getViewSetup()).getIllumination().getName());
                    IOFunctions.println("Quitting. Please set it manually when defining the dataset or by modifying the XML");
                    return Double.NaN;
                }
                setup.setVoxelSize(voxelSize);
            }
            if (!setup.hasVoxelSize()) {
                IOFunctions.println("An error occured. No calibration available for timepoint: " + vd.getTimePoint().getName() + " angle: " + ((ViewSetup)vd.getViewSetup()).getAngle().getName() + " channel: " + ((ViewSetup)vd.getViewSetup()).getChannel().getName() + " illum: " + ((ViewSetup)vd.getViewSetup()).getIllumination().getName());
                IOFunctions.println("Quitting. Please set it manually when defining the dataset or by modifying the XML.");
                IOFunctions.println("Note: if you selected to load calibration independently for each image, it should.");
                IOFunctions.println("      have been loaded during interest point detection.");
                return Double.NaN;
            }
            voxelSize = setup.getVoxelSize();
            double calX = voxelSize.dimension(0);
            double calY = voxelSize.dimension(1);
            double calZ = voxelSize.dimension(2);
            minResolution = Math.min(minResolution, calX);
            minResolution = Math.min(minResolution, calY);
            minResolution = Math.min(minResolution, calZ);
        }
        return minResolution;
    }

    public static void applyAxis(SpimData data) {
        ViewRegistrations viewRegistrations = data.getViewRegistrations();
        for (ViewDescription vd : ((SequenceDescription)data.getSequenceDescription()).getViewDescriptions().values()) {
            String d;
            Angle a;
            if (!vd.isPresent() || !(a = ((ViewSetup)vd.getViewSetup()).getAngle()).hasRotation()) continue;
            ViewRegistration vr = viewRegistrations.getViewRegistration((ViewId)vd);
            Dimensions dim = ((ViewSetup)vd.getViewSetup()).getSize();
            AffineTransform3D model = new AffineTransform3D();
            model.set(1.0, 0.0, 0.0, (double)(-dim.dimension(0) / 2L), 0.0, 1.0, 0.0, (double)(-dim.dimension(1) / 2L), 0.0, 0.0, 1.0, (double)(-dim.dimension(2) / 2L));
            ViewTransformAffine vt = new ViewTransformAffine("Center view", model);
            vr.preconcatenateTransform((ViewTransform)vt);
            double[] tmp = new double[16];
            double[] axis = a.getRotationAxis();
            double degrees = a.getRotationAngleDegrees();
            Transform3D t = new Transform3D();
            if (axis[0] == 1.0 && axis[1] == 0.0 && axis[2] == 0.0) {
                t.rotX(Math.toRadians(degrees));
                d = "Rotation around x-axis by " + degrees + " degrees";
            } else if (axis[0] == 0.0 && axis[1] == 1.0 && axis[2] == 0.0) {
                t.rotY(Math.toRadians(degrees));
                d = "Rotation around y-axis by " + degrees + " degrees";
            } else if (axis[0] == 1.0 && axis[0] == 0.0 && axis[2] == 1.0) {
                t.rotZ(Math.toRadians(degrees));
                d = "Rotation around z-axis by " + degrees + " degrees";
            } else {
                IOFunctions.println("Arbitrary rotation axis not supported yet.");
                continue;
            }
            t.get(tmp);
            model = new AffineTransform3D();
            model.set(tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5], tmp[6], tmp[7], tmp[8], tmp[9], tmp[10], tmp[11]);
            vt = new ViewTransformAffine(d, model);
            vr.preconcatenateTransform((ViewTransform)vt);
            vr.updateModel();
        }
    }

    public static void main(String[] args) {
        new Apply_Transformation().run(null);
    }
}

