/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class DoubleFFT_1DTest {
    public static final String DEFAULT_MESSAGE = "%d-threaded FFT of size %d: ";
    private static final String FFTW_INPUT_PATTERN = "fftw%d.in";
    private static final String FFTW_OUTPUT_PATTERN = "fftw%d.out";
    public static final int SEED = 20110602;
    private final DoubleFFT_1D fft;
    private final int n;
    private final Random random;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Object[]{nArray[i], 1, 20110602});
            arrayList.add(new Object[]{nArray[i], 2, 20110602});
            arrayList.add(new Object[]{nArray[i], 4, 20110602});
        }
        return arrayList;
    }

    public DoubleFFT_1DTest(int n, int n2, long l) {
        this.n = n;
        this.fft = new DoubleFFT_1D(n);
        this.random = new Random(l);
        ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(512);
        ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(512);
        ConcurrencyUtils.setNumberOfThreads(n2);
    }

    public FloatingPointEqualityChecker createEqualityChecker(double d, double d2) {
        String string = String.format(DEFAULT_MESSAGE, ConcurrencyUtils.getNumberOfThreads(), this.n);
        return new FloatingPointEqualityChecker(string, d, d2, 0.0f, 0.0f);
    }

    public void readData(String string, double[] dArray) {
        try {
            File file = new File(this.getClass().getClassLoader().getResource(string).getFile());
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(8 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            fileChannel.read(byteBuffer);
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = byteBuffer.getDouble(8 * i);
            }
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
    }

    @Test
    public void testComplexForward() {
        double d = 1.0E-9;
        double d2 = 1.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.n];
        double[] dArray2 = new double[2 * this.n];
        this.readData(String.format(FFTW_INPUT_PATTERN, this.n), dArray);
        this.readData(String.format(FFTW_OUTPUT_PATTERN, this.n), dArray2);
        this.fft.complexForward(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            floatingPointEqualityChecker.assertEquals("[" + i + "]", dArray2[i], dArray[i]);
        }
    }

    @Test
    public void testComplexInverseScaled() {
        int n;
        double d = 1.0E-9;
        double d2 = 1.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.n];
        double[] dArray2 = new double[2 * this.n];
        for (n = 0; n < 2 * this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[n] = dArray[n];
        }
        this.fft.complexForward(dArray);
        this.fft.complexInverse(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }

    @Test
    public void testComplexInverseUnscaled() {
        double d = 1.0E-9;
        double d2 = 1.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.n];
        double[] dArray2 = new double[2 * this.n];
        for (int i = 0; i < 2 * this.n; ++i) {
            dArray[i] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[i] = dArray[i];
        }
        this.fft.complexForward(dArray);
        this.fft.complexInverse(dArray, false);
        double d4 = 1.0 / (double)this.n;
        for (int i = 0; i < dArray.length; ++i) {
            floatingPointEqualityChecker.assertEquals("[" + i + "]", dArray2[i], d4 * dArray[i]);
        }
    }

    @Test
    public void testRealForward() {
        int n;
        double d = 1.0E-9;
        double d2 = 1.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[2 * n] = dArray[n];
            dArray2[2 * n + 1] = 0.0;
        }
        this.fft.complexForward(dArray2);
        this.fft.realForward(dArray);
        floatingPointEqualityChecker.assertEquals("[0]", dArray2[0], dArray[0]);
        if (this.n > 1) {
            floatingPointEqualityChecker.assertEquals("[1]", dArray2[this.n], dArray[1]);
        }
        for (n = 2; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }

    @Test
    public void testRealForwardFull() {
        int n;
        double d = 1.0E-8;
        double d2 = 5.0E-6;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.n];
        double[] dArray2 = new double[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[2 * n] = dArray[n];
            dArray2[2 * n + 1] = 0.0;
        }
        this.fft.complexForward(dArray2);
        this.fft.realForwardFull(dArray);
        for (n = 0; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }

    @Test
    public void testRealInverseFullScaled() {
        int n;
        double d = 1.0E-9;
        double d2 = 1.0E-7;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.n];
        double[] dArray2 = new double[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[2 * n] = dArray[n];
            dArray2[2 * n + 1] = 0.0;
        }
        this.fft.realInverseFull(dArray, true);
        this.fft.complexInverse(dArray2, true);
        for (n = 0; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }

    @Test
    public void testRealInverseFullUnscaled() {
        int n;
        double d = 1.0E-7;
        double d2 = 5.0E-7;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.n];
        double[] dArray2 = new double[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[2 * n] = dArray[n];
            dArray2[2 * n + 1] = 0.0;
        }
        this.fft.realInverseFull(dArray, false);
        this.fft.complexInverse(dArray2, false);
        for (n = 0; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }

    @Test
    public void testRealInverseScaled() {
        int n;
        double d = 1.0E-9;
        double d2 = 1.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[n] = dArray[n];
        }
        this.fft.realForward(dArray);
        this.fft.realInverse(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }

    @Test
    public void testRealInverseUnscaled() {
        int n;
        double d = 1.0E-9;
        double d2 = 1.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            dArray[n] = 2.0 * this.random.nextDouble() - 1.0;
            dArray2[n] = dArray[n];
        }
        this.fft.realForward(dArray);
        this.fft.realInverse(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", dArray2[n], dArray[n]);
        }
    }
}

