/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AbstractTranslation;
import net.imglib2.realtransform.TranslationGet;

public class Translation
extends AbstractTranslation
implements Concatenable<TranslationGet>,
PreConcatenable<TranslationGet> {
    protected final Translation inverse;

    protected Translation(double[] t, Translation inverse) {
        super(t, inverse.ds);
        this.inverse = inverse;
    }

    public Translation(int n) {
        super(n);
        this.inverse = new Translation(new double[n], this);
    }

    public Translation(double ... t) {
        this(t.length);
        this.set(t);
    }

    @Override
    public void set(double ... t) {
        assert (t.length <= this.t.length) : "Too many inputs.";
        for (int d = 0; d < t.length; ++d) {
            this.t[d] = t[d];
            this.inverse.t[d] = -t[d];
        }
    }

    @Override
    public void set(double t, int d) {
        assert (d >= 0 && d < this.numDimensions()) : "Dimension index out of bounds.";
        this.t[d] = t;
        this.inverse.t[d] = -t;
    }

    @Override
    public Translation copy() {
        return new Translation(this.t);
    }

    @Override
    public Translation inverse() {
        return this.inverse;
    }

    public Translation preConcatenate(TranslationGet a) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            this.set(this.t[d] + a.getTranslation(d));
        }
        return this;
    }

    public Class<TranslationGet> getPreConcatenableClass() {
        return TranslationGet.class;
    }

    public Translation concatenate(TranslationGet a) {
        return this.preConcatenate(a);
    }

    public Class<TranslationGet> getConcatenableClass() {
        return TranslationGet.class;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.t.length; ++i) {
            if (this.t[i] == 0.0) continue;
            return false;
        }
        return true;
    }
}

