/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.io.PrintStream;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Shader;
import org.jogamp.java3d.ShaderAppearance;
import org.jogamp.java3d.ShaderAttribute;
import org.jogamp.java3d.ShaderAttributeSet;
import org.jogamp.java3d.ShaderProgram;
import org.jogamp.java3d.Shape3D;

public class ShaderError {
    private int errorCode = 0;
    private String errorMessage = null;
    private String detailMessage = null;
    private Canvas3D canvas = null;
    private Shape3D shape = null;
    private Geometry geometry = null;
    private ShaderAppearance shaderApp = null;
    private ShaderProgram shaderProgram = null;
    private Shader shader = null;
    private ShaderAttributeSet shaderAttributeSet = null;
    private ShaderAttribute shaderAttribute = null;
    public static final int NO_ERROR = 0;
    public static final int COMPILE_ERROR = 1;
    public static final int LINK_ERROR = 2;
    public static final int VERTEX_ATTRIBUTE_LOOKUP_ERROR = 3;
    public static final int SHADER_ATTRIBUTE_LOOKUP_ERROR = 4;
    public static final int SHADER_ATTRIBUTE_NAME_NOT_SET_ERROR = 5;
    public static final int SHADER_ATTRIBUTE_TYPE_ERROR = 6;
    public static final int UNSUPPORTED_LANGUAGE_ERROR = 7;

    public ShaderError() {
    }

    public ShaderError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public void printVerbose() {
        this.printVerbose(System.err);
    }

    public void printVerbose(PrintStream printStream) {
        printStream.println(this);
        if (this.canvas != null) {
            printStream.println("canvas = " + this.canvas);
        }
        if (this.shape != null) {
            printStream.println("shape = " + this.shape);
        }
        if (this.geometry != null) {
            printStream.println("geometry = " + this.geometry);
        }
        if (this.shaderApp != null) {
            printStream.println("shaderApp = " + this.shaderApp);
        }
        if (this.shaderProgram != null) {
            printStream.println("shaderProgram = " + this.shaderProgram);
        }
        if (this.shader != null) {
            printStream.println("shader = " + this.shader);
        }
        if (this.shaderAttributeSet != null) {
            printStream.println("shaderAttributeSet = " + this.shaderAttributeSet);
        }
        if (this.shaderAttribute != null) {
            printStream.println("shaderAttribute = " + this.shaderAttribute);
        }
        if (this.detailMessage != null) {
            printStream.println();
            printStream.println("Detail Message");
            printStream.println("--------------");
            printStream.println(this.detailMessage);
        }
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setDetailMessage(String detailMessage) {
        this.detailMessage = detailMessage;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public void setCanvas3D(Canvas3D canvas) {
        this.canvas = canvas;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas;
    }

    public void setShape3D(Shape3D shape) {
        this.shape = shape;
    }

    public Shape3D getShape3D() {
        return this.shape;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setShaderAppearance(ShaderAppearance shaderApp) {
        this.shaderApp = shaderApp;
    }

    public ShaderAppearance getShaderAppearance() {
        return this.shaderApp;
    }

    public void setShaderProgram(ShaderProgram shaderProgram) {
        this.shaderProgram = shaderProgram;
    }

    public ShaderProgram getShaderProgram() {
        return this.shaderProgram;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShaderAttributeSet(ShaderAttributeSet shaderAttributeSet) {
        this.shaderAttributeSet = shaderAttributeSet;
    }

    public ShaderAttributeSet getShaderAttributeSet() {
        return this.shaderAttributeSet;
    }

    public void setShaderAttribute(ShaderAttribute shaderAttribute) {
        this.shaderAttribute = shaderAttribute;
    }

    public ShaderAttribute getShaderAttribute() {
        return this.shaderAttribute;
    }

    public String toString() {
        String errorCodeStr;
        switch (this.errorCode) {
            case 0: {
                errorCodeStr = "NO_ERROR";
                break;
            }
            case 1: {
                errorCodeStr = "COMPILE_ERROR";
                break;
            }
            case 2: {
                errorCodeStr = "LINK_ERROR";
                break;
            }
            case 3: {
                errorCodeStr = "VERTEX_ATTRIBUTE_LOOKUP_ERROR";
                break;
            }
            case 4: {
                errorCodeStr = "SHADER_ATTRIBUTE_LOOKUP_ERROR";
                break;
            }
            case 5: {
                errorCodeStr = "SHADER_ATTRIBUTE_NAME_NOT_SET_ERROR";
                break;
            }
            case 6: {
                errorCodeStr = "SHADER_ATTRIBUTE_TYPE_ERROR";
                break;
            }
            case 7: {
                errorCodeStr = "UNSUPPORTED_LANGUAGE_ERROR";
                break;
            }
            default: {
                errorCodeStr = "UNKNOWN ERROR CODE (" + this.errorCode + ")";
            }
        }
        if (this.errorMessage == null) {
            return errorCodeStr;
        }
        return errorCodeStr + ": " + this.errorMessage;
    }
}

