/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.LineConvolution;
import net.imglib2.algorithm.convolution.LineConvolverFactory;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.numeric.RealType;

class MinMaxFilter {
    MinMaxFilter() {
    }

    public static <T extends RealType<?>> Convolution<T> maxFilter(int ... windowSize) {
        return MinMaxFilter.minMaxFilter(Operation.MAX, windowSize);
    }

    public static <T extends RealType<?>> Convolution<T> minFilter(int ... windowSize) {
        return MinMaxFilter.minMaxFilter(Operation.MIN, windowSize);
    }

    private static <T extends RealType<?>> Convolution<T> minMaxFilter(Operation operation, int[] windowSize) {
        ArrayList<Convolution<T>> convolutions = new ArrayList<Convolution<T>>();
        for (int d = 0; d < windowSize.length; ++d) {
            int radius = windowSize[d];
            if (radius == 0) continue;
            convolutions.add(MinMaxFilter.minMaxFilter1d(operation, radius, d));
        }
        return Convolution.concat(convolutions);
    }

    public static <T extends RealType<?>> Convolution<T> maxFilter1d(int windowSize, int d) {
        return MinMaxFilter.minMaxFilter1d(Operation.MAX, windowSize, d);
    }

    public static <T extends RealType<?>> Convolution<T> minFilter1d(int windowSize, int d) {
        return MinMaxFilter.minMaxFilter1d(Operation.MIN, windowSize, d);
    }

    private static <T extends RealType<?>> Convolution<T> minMaxFilter1d(Operation operation, int windowSize, int d) {
        return new LineConvolution(new CenteredMinMaxFilter(operation, windowSize), d);
    }

    public static class LongDoubleQueue {
        private final int capacity;
        private final long[] longs;
        private final double[] doubles;
        private int first;
        private int last;
        private int size;

        public LongDoubleQueue(int capacity) {
            this.capacity = capacity;
            this.longs = new long[capacity];
            this.doubles = new double[capacity];
            this.first = 0;
            this.last = capacity - 1;
            this.size = 0;
        }

        public void reset() {
            this.first = 0;
            this.last = this.capacity - 1;
            this.size = 0;
        }

        public long getFirstLong() {
            return this.longs[this.first];
        }

        public double getFirstDouble() {
            return this.doubles[this.first];
        }

        public double getLastDouble() {
            return this.doubles[this.last];
        }

        public void addLast(long longValue, double doubleValue) {
            this.last = Math.floorMod(this.last + 1, this.capacity);
            this.longs[this.last] = longValue;
            this.doubles[this.last] = doubleValue;
            ++this.size;
        }

        public void removeFirst() {
            this.first = Math.floorMod(this.first + 1, this.capacity);
            --this.size;
        }

        public void removeLast() {
            this.last = Math.floorMod(this.last - 1, this.capacity);
            --this.size;
        }

        public boolean isEmpty() {
            return this.size <= 0;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (int i = 0; i < this.size; ++i) {
                int index = Math.floorMod(this.first + i, this.capacity);
                joiner.add(this.longs[index] + ":" + this.doubles[index]);
            }
            return joiner.toString();
        }
    }

    public static class MinMaxConvolver
    implements Runnable {
        private final RandomAccess<? extends RealType<?>> in;
        private final RandomAccess<? extends RealType<?>> out;
        private final int width;
        private final long lineLength;
        private final LongDoubleQueue queue;
        private final int d;
        private final Operation operation;

        public MinMaxConvolver(Operation operation, int width, RandomAccess<? extends RealType<?>> in, RandomAccess<? extends RealType<?>> out, int d, long lineLength) {
            this.in = in;
            this.out = out;
            this.width = width;
            this.d = d;
            this.lineLength = lineLength;
            this.queue = new LongDoubleQueue(width);
            this.operation = operation;
        }

        @Override
        public void run() {
            this.queue.reset();
            this.prefill();
            this.process();
        }

        private void prefill() {
            for (long i = (long)(-this.width + 1); i < 0L; ++i) {
                this.step(i);
            }
        }

        private void process() {
            for (long i = 0L; i < this.lineLength; ++i) {
                this.step(i);
                this.write(this.queue.getFirstDouble());
            }
        }

        private void step(long i) {
            double value = this.read();
            if (!this.queue.isEmpty() && this.queue.getFirstLong() <= i) {
                this.queue.removeFirst();
            }
            while (!this.queue.isEmpty() && this.useFirst(value, this.queue.getLastDouble())) {
                this.queue.removeLast();
            }
            this.queue.addLast(i + (long)this.width, value);
        }

        private boolean useFirst(double a, double b) {
            return this.operation == Operation.MAX ? a >= b : a <= b;
        }

        private double read() {
            double v = ((RealType)this.in.get()).getRealDouble();
            this.in.fwd(this.d);
            return v;
        }

        private void write(double v) {
            ((RealType)this.out.get()).setReal(v);
            this.out.fwd(this.d);
        }
    }

    static class CenteredMinMaxFilter<T extends RealType<?>>
    implements LineConvolverFactory<T> {
        private static final ClassCopyProvider<Runnable> provider = new ClassCopyProvider(MinMaxConvolver.class, Runnable.class, new Class[0]);
        private final Operation operation;
        private final int windowSize;

        CenteredMinMaxFilter(Operation operation, int windowSize) {
            assert (windowSize > 0);
            this.operation = operation;
            this.windowSize = windowSize;
        }

        public long getBorderBefore() {
            return this.windowSize / 2;
        }

        public long getBorderAfter() {
            return (this.windowSize - 1) / 2;
        }

        public Runnable getConvolver(RandomAccess<? extends T> in, RandomAccess<? extends T> out, int d, long lineLength) {
            List<Object> key = Arrays.asList(new Object[]{this.operation, in.getClass(), out.getClass(), ((RealType)in.get()).getClass(), ((RealType)out.get()).getClass()});
            return (Runnable)provider.newInstanceForKey(key, new Object[]{this.operation, this.windowSize, in, out, d, lineLength});
        }

        public T preferredSourceType(T targetType) {
            return targetType;
        }
    }

    public static enum Operation {
        MIN,
        MAX;

    }
}

