/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.TranslationModel3D;
import mpicbg.util.Matrix3x3;

public class RigidModel3D
extends AbstractAffineModel3D<RigidModel3D>
implements InvertibleBoundable {
    private static final long serialVersionUID = 4703083104338949996L;
    protected static final int MIN_NUM_MATCHES = 3;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m03 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m13 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected double m23 = 0.0;
    protected double i00 = 1.0;
    protected double i01 = 0.0;
    protected double i02 = 0.0;
    protected double i03 = 0.0;
    protected double i10 = 0.0;
    protected double i11 = 1.0;
    protected double i12 = 0.0;
    protected double i13 = 0.0;
    protected double i20 = 0.0;
    protected double i21 = 0.0;
    protected double i22 = 1.0;
    protected double i23 = 0.0;
    protected boolean isInvertible = true;

    @Override
    public double[] getMatrix(double[] m) {
        double[] a = m == null || m.length != 12 ? new double[12] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        a[2] = this.m02;
        a[3] = this.m03;
        a[4] = this.m10;
        a[5] = this.m11;
        a[6] = this.m12;
        a[7] = this.m13;
        a[8] = this.m20;
        a[9] = this.m21;
        a[10] = this.m22;
        a[11] = this.m23;
        return a;
    }

    @Override
    public final int getMinNumMatches() {
        return 3;
    }

    @Override
    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02 + this.m03;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12 + this.m13;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22 + this.m23;
    }

    @Override
    public final double[] applyInverse(double[] l) throws NoninvertibleModelException {
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(double[] l) throws NoninvertibleModelException {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.i00 + l1 * this.i01 + l[2] * this.i02 + this.i03;
        l[1] = l0 * this.i10 + l1 * this.i11 + l[2] * this.i12 + this.i13;
        l[2] = l0 * this.i20 + l1 * this.i21 + l[2] * this.i22 + this.i23;
    }

    public final String toString() {
        return "3d-rigid: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + ")";
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 3) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 3d rigid transformation model, at least " + 3 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double pcz = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double qcz = 0.0;
        double sumW = 0.0;
        for (PointMatch pm : matches) {
            double[] p1 = pm.getP1().getL();
            double[] p2 = pm.getP2().getW();
            double w = pm.getWeight();
            pcx += p1[0] * w;
            pcy += p1[1] * w;
            pcz += p1[2] * w;
            qcx += p2[0] * w;
            qcy += p2[1] * w;
            qcz += p2[2] * w;
            sumW += w;
        }
        pcx /= sumW;
        pcy /= sumW;
        pcz /= sumW;
        qcx /= sumW;
        qcy /= sumW;
        qcz /= sumW;
        double Sxx = 0.0;
        double Sxy = 0.0;
        double Sxz = 0.0;
        double Syx = 0.0;
        double Syy = 0.0;
        double Syz = 0.0;
        double Szx = 0.0;
        double Szy = 0.0;
        double Szz = 0.0;
        for (PointMatch pm : matches) {
            double[] p1 = pm.getP1().getL();
            double[] p2 = pm.getP2().getW();
            double w = pm.getWeight();
            double x1 = (p1[0] - pcx) * w;
            double y1 = (p1[1] - pcy) * w;
            double z1 = (p1[2] - pcz) * w;
            double x2 = (p2[0] - qcx) * w;
            double y2 = (p2[1] - qcy) * w;
            double z2 = (p2[2] - qcz) * w;
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        double[][] N = new double[4][4];
        N[0][0] = Sxx + Syy + Szz;
        N[0][1] = Syz - Szy;
        N[0][2] = Szx - Sxz;
        N[0][3] = Sxy - Syx;
        N[1][0] = Syz - Szy;
        N[1][1] = Sxx - Syy - Szz;
        N[1][2] = Sxy + Syx;
        N[1][3] = Szx + Sxz;
        N[2][0] = Szx - Sxz;
        N[2][1] = Sxy + Syx;
        N[2][2] = -Sxx + Syy - Szz;
        N[2][3] = Syz + Szy;
        N[3][0] = Sxy - Syx;
        N[3][1] = Szx + Sxz;
        N[3][2] = Syz + Szy;
        N[3][3] = -Sxx - Syy + Szz;
        EigenvalueDecomposition evd = new EigenvalueDecomposition(new Matrix(N));
        double[] eigenvalues = evd.getRealEigenvalues();
        Matrix eigenVectors = evd.getV();
        int index = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(eigenvalues[i] > eigenvalues[index])) continue;
            index = i;
        }
        double q0 = eigenVectors.get(0, index);
        double qx = eigenVectors.get(1, index);
        double qy = eigenVectors.get(2, index);
        double qz = eigenVectors.get(3, index);
        this.m00 = q0 * q0 + qx * qx - qy * qy - qz * qz;
        this.m01 = 2.0 * (qx * qy - q0 * qz);
        this.m02 = 2.0 * (qx * qz + q0 * qy);
        this.m10 = 2.0 * (qy * qx + q0 * qz);
        this.m11 = q0 * q0 - qx * qx + qy * qy - qz * qz;
        this.m12 = 2.0 * (qy * qz - q0 * qx);
        this.m20 = 2.0 * (qz * qx - q0 * qy);
        this.m21 = 2.0 * (qz * qy + q0 * qx);
        this.m22 = q0 * q0 - qx * qx - qy * qy + qz * qz;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final void set(RigidModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.m03 = m.m03;
        this.m13 = m.m13;
        this.m23 = m.m23;
        this.cost = m.cost;
        this.invert();
    }

    public final void reset() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.i00 = 1.0;
        this.i01 = 0.0;
        this.i02 = 0.0;
        this.i03 = 0.0;
        this.i10 = 0.0;
        this.i11 = 1.0;
        this.i12 = 0.0;
        this.i13 = 0.0;
        this.i20 = 0.0;
        this.i21 = 0.0;
        this.i22 = 1.0;
        this.i23 = 0.0;
        this.cost = Double.MAX_VALUE;
    }

    @Override
    public final void set(TranslationModel3D m) {
        this.reset();
        this.m03 = m.translation[0];
        this.m13 = m.translation[1];
        this.m23 = m.translation[2];
        this.cost = m.getCost();
        this.invert();
    }

    @Override
    public RigidModel3D copy() {
        RigidModel3D m = new RigidModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        m.m03 = this.m03;
        m.m13 = this.m13;
        m.m23 = this.m23;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    protected void invert() {
        double det = Matrix3x3.det(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        if (det == 0.0) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        double idet = 1.0 / det;
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) * idet;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) * idet;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) * idet;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) * idet;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) * idet;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) * idet;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) * idet;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) * idet;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) * idet;
        this.i03 = -this.i00 * this.m03 - this.i01 * this.m13 - this.i02 * this.m23;
        this.i13 = -this.i10 * this.m03 - this.i11 * this.m13 - this.i12 * this.m23;
        this.i23 = -this.i20 * this.m03 - this.i21 * this.m13 - this.i22 * this.m23;
    }

    @Override
    public final void preConcatenate(RigidModel3D model) {
        double a00 = model.m00 * this.m00 + model.m01 * this.m10 + model.m02 * this.m20;
        double a01 = model.m00 * this.m01 + model.m01 * this.m11 + model.m02 * this.m21;
        double a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02 * this.m22;
        double a03 = model.m00 * this.m03 + model.m01 * this.m13 + model.m02 * this.m23 + model.m03;
        double a10 = model.m10 * this.m00 + model.m11 * this.m10 + model.m12 * this.m20;
        double a11 = model.m10 * this.m01 + model.m11 * this.m11 + model.m12 * this.m21;
        double a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12 * this.m22;
        double a13 = model.m10 * this.m03 + model.m11 * this.m13 + model.m12 * this.m23 + model.m13;
        double a20 = model.m20 * this.m00 + model.m21 * this.m10 + model.m22 * this.m20;
        double a21 = model.m20 * this.m01 + model.m21 * this.m11 + model.m22 * this.m21;
        double a22 = model.m20 * this.m02 + model.m21 * this.m12 + model.m22 * this.m22;
        double a23 = model.m20 * this.m03 + model.m21 * this.m13 + model.m22 * this.m23 + model.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(RigidModel3D model) {
        double a00 = this.m00 * model.m00 + this.m01 * model.m10 + this.m02 * model.m20;
        double a01 = this.m00 * model.m01 + this.m01 * model.m11 + this.m02 * model.m21;
        double a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02 * model.m22;
        double a03 = this.m00 * model.m03 + this.m01 * model.m13 + this.m02 * model.m23 + this.m03;
        double a10 = this.m10 * model.m00 + this.m11 * model.m10 + this.m12 * model.m20;
        double a11 = this.m10 * model.m01 + this.m11 * model.m11 + this.m12 * model.m21;
        double a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12 * model.m22;
        double a13 = this.m10 * model.m03 + this.m11 * model.m13 + this.m12 * model.m23 + this.m13;
        double a20 = this.m20 * model.m00 + this.m21 * model.m10 + this.m22 * model.m20;
        double a21 = this.m20 * model.m01 + this.m21 * model.m11 + this.m22 * model.m21;
        double a22 = this.m20 * model.m02 + this.m21 * model.m12 + this.m22 * model.m22;
        double a23 = this.m20 * model.m03 + this.m21 * model.m13 + this.m22 * model.m23 + this.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(TranslationModel3D model) {
        double[] t = model.getTranslation();
        this.m03 = this.m00 * t[0] + this.m01 * t[1] + this.m02 * t[2] + this.m03;
        this.m13 = this.m10 * t[0] + this.m11 * t[1] + this.m12 * t[2] + this.m13;
        this.m23 = this.m20 * t[0] + this.m21 * t[1] + this.m22 * t[2] + this.m23;
        this.invert();
    }

    @Override
    public final void preConcatenate(TranslationModel3D model) {
        double[] t = model.getTranslation();
        this.m03 += t[0];
        this.m13 += t[1];
        this.m23 += t[2];
        this.invert();
    }

    @Deprecated
    public final void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.invert();
    }

    @Override
    public RigidModel3D createInverse() {
        RigidModel3D ict = new RigidModel3D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m20 = this.i20;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m21 = this.i21;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.m22 = this.i22;
        ict.m03 = this.i03;
        ict.m13 = this.i13;
        ict.m23 = this.i23;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i20 = this.m20;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i21 = this.m21;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.i22 = this.m22;
        ict.i03 = this.m03;
        ict.i13 = this.m13;
        ict.i23 = this.m23;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    public void rotate(int axis, double d) {
        double dcos = Math.cos(d);
        double dsin = Math.sin(d);
        RigidModel3D dR = new RigidModel3D();
        switch (axis) {
            case 0: {
                dR.set(1.0, 0.0, 0.0, 0.0, 0.0, dcos, -dsin, 0.0, 0.0, dsin, dcos, 0.0);
                break;
            }
            case 1: {
                dR.set(dcos, 0.0, dsin, 0.0, 0.0, 1.0, 0.0, 0.0, -dsin, 0.0, dcos, 0.0);
                break;
            }
            default: {
                dR.set(dcos, -dsin, 0.0, 0.0, dsin, dcos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            }
        }
        this.preConcatenate(dR);
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }
}

